/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import hermes.browser.HermesBrowser;
import hermes.browser.actions.BrowseContextAction;
import hermes.swing.actions.ActionSupport;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class JNDIAction
extends ActionSupport
implements DocumentComponentListener,
TreeSelectionListener {
    public JNDIAction() {
        if (!HermesBrowser.getBrowser().isRestricted()) {
            HermesBrowser.getBrowser().addDocumentComponentListener(this);
        }
    }

    protected abstract boolean checkEnabled(TreePath var1);

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void documentComponentMoved(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoving(DocumentComponentEvent arg0) {
    }

    public void documentComponentActivated(DocumentComponentEvent event) {
        if (event.getDocumentComponent() instanceof BrowseContextAction) {
            BrowseContextAction browseContext = (BrowseContextAction)event.getDocumentComponent();
            this.setEnabled(this.checkEnabled(browseContext.getContextTree().getSelectionPath()));
            this.addListener(event);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.setEnabled(this.checkEnabled(e.getPath()));
    }

    private void addListener(DocumentComponentEvent event) {
        if (event.getDocumentComponent() instanceof BrowseContextAction) {
            BrowseContextAction browseContext = (BrowseContextAction)event.getDocumentComponent();
            browseContext.getContextTree().addTreeSelectionListener(this);
        }
    }

    private void removeListener(DocumentComponentEvent event) {
        if (event.getDocumentComponent() instanceof BrowseContextAction) {
            BrowseContextAction browseContext = (BrowseContextAction)event.getDocumentComponent();
            browseContext.getContextTree().removeTreeSelectionListener(this);
        }
    }

    public void documentComponentClosed(DocumentComponentEvent event) {
        this.setEnabled(false);
        this.removeListener(event);
    }

    public void documentComponentClosing(DocumentComponentEvent event) {
        this.setEnabled(false);
        this.removeListener(event);
    }

    public void documentComponentDeactivated(DocumentComponentEvent event) {
        this.setEnabled(false);
        this.removeListener(event);
    }

    public void documentComponentOpened(DocumentComponentEvent event) {
        this.setEnabled(event.getDocumentComponent() instanceof BrowseContextAction);
        this.addListener(event);
    }
}

