/*
 * Decompiled with CFR 0.152.
 */
import com.eviware.soapui.analytics.providers.BaseAnalyticsProvider;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsManager;
import com.smartbear.analytics.AnalyticsUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class MixpanelAnalyticsProvider
extends BaseAnalyticsProvider {
    private static final String MIXPANEL_PROJECT_TOKEN = "a7a40dd8c352c105c64708bbb09e5371";
    private final MixpanelAPI mixpanelAPI = new MixpanelAPI();
    private final MessageBuilder messageBuilder = new MessageBuilder("a7a40dd8c352c105c64708bbb09e5371");
    private final String userId;
    private final String productName;
    private final String productVersion;

    MixpanelAnalyticsProvider(String productName, String productVersion, String userId) {
        this.userId = userId;
        this.productName = productName;
        this.productVersion = productVersion;
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
        this.sendEventData(actionDescription);
    }

    private void sendEventData(ActionDescription actionDescription) {
        if (actionDescription.getCategory().equals((Object)AnalyticsManager.Category.ACTION)) {
            JSONObject props = new JSONObject(this.populateEventMapWithActionData(actionDescription));
            JSONObject event = this.messageBuilder.event(this.userId, actionDescription.getActionName(), props);
            final ClientDelivery delivery = new ClientDelivery();
            delivery.addMessage(event);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MixpanelAnalyticsProvider.this.mixpanelAPI.deliver(delivery);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    private Map<String, Object> populateEventMapWithActionData(ActionDescription actionDescription) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("action", actionDescription.getActionName());
        event.put("session_id", actionDescription.getSessionId());
        event.put("category", (Object)actionDescription.getCategory());
        event.put("screensize", AnalyticsUtils.getScreenSize());
        this.addProductVersionAndLicenseInfo(event);
        Map<String, String> params = actionDescription.getParams();
        if (params != null) {
            for (String key : params.keySet()) {
                event.put(key, params.get(key));
            }
        }
        return event;
    }

    private void addProductVersionAndLicenseInfo(Map<String, Object> event) {
        event.put("product_name", this.productName);
        event.put("product_version", this.productVersion);
    }
}

