/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics;

import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.preferences.UserPreferences;
import com.smartbear.analytics.api.UserIdentificationInformation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UniqueUserIdentifier
implements UserIdentificationInformation {
    private String userId;
    private static UniqueUserIdentifier instance;
    private String email;
    private String name;

    private UniqueUserIdentifier(UserPreferences prefs) {
        this.userId = prefs.getAnalyticsUserId();
        if (StringUtils.isNullOrEmpty(this.userId)) {
            this.userId = UUID.randomUUID().toString();
            prefs.setAnalyticsUserId(this.userId);
        }
    }

    public static UniqueUserIdentifier initialize(UserPreferences prefs) {
        if (instance == null) {
            instance = new UniqueUserIdentifier(prefs);
        }
        return instance;
    }

    public static UniqueUserIdentifier getInstance() {
        if (instance == null) {
            return UniqueUserIdentifier.initialize(new UserPreferences());
        }
        return instance;
    }

    public Map<String, String> prepareUserProfile() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("userId", this.userId);
        if (StringUtils.hasContent(this.name)) {
            props.put("$name", this.name);
        }
        if (StringUtils.hasContent(this.email)) {
            props.put("$email", this.email);
        }
        return props;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setName(String name) {
        this.name = name;
    }
}

