/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.explorer.callback;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestURIParser;
import com.eviware.soapui.impl.rest.actions.explorer.RequestInspectionData;
import com.eviware.soapui.impl.rest.actions.method.SaveRequestAction;
import com.eviware.soapui.impl.rest.support.RestURIParserImpl;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpPatch;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.HttpCopyMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.HttpDeleteWithBody;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.HttpLockMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.HttpPropFindMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.HttpPurgeMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.HttpUnlockMethod;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EndpointExplorerCallback {
    public static final String CALLBACK = "inspectorCallback";
    private static final String METHOD_PROPERTY = "method";
    private static final String URL_PROPERTY = "url";
    private static final String PAYLOAD_PROPERTY = "payload";
    private static final String HEADERS_PROPERTY = "headers";
    private final WebViewBasedBrowserComponent browserComponent;
    private boolean requestCreated = false;
    private static final String UNKNOWN_HOST_EXCEPTION_RESPONSE_TEXT = "<missing raw response data>";

    public EndpointExplorerCallback(WebViewBasedBrowserComponent browserComponent) {
        this.browserComponent = browserComponent;
    }

    public RestURIParser getUrlParser(String url) {
        if (StringUtils.hasContent(url)) {
            try {
                return new RestURIParserImpl(url);
            }
            catch (MalformedURLException e) {
                SoapUI.logError(e);
                return null;
            }
        }
        return null;
    }

    public void createFromInspection(String json) {
        JSONObject request;
        try {
            request = new JSONObject(json);
        }
        catch (JSONException e) {
            SoapUI.logError(e);
            return;
        }
        Analytics.trackAction(SoapUIActions.EXPLORE_API_CLICK_SAVE_REQUEST, "HTTPMethod", this.extractMethod(request), "Endpoint", this.extractUrl(request));
        final String url = this.extractUrl(request);
        if (StringUtils.isNullOrEmpty(url)) {
            return;
        }
        final RestRequestInterface.HttpMethod method = RestRequestInterface.HttpMethod.valueOf(this.extractMethod(request));
        final RequestInspectionData inspectionData = new RequestInspectionData(this.extractHeaders(request), this.extractPayload(request));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("URLs", Arrays.asList(url));
                context.put("Methods", Arrays.asList(method));
                context.put("InspectionData", Arrays.asList(inspectionData));
                SaveRequestAction saveRequestAction = new SaveRequestAction(context);
                EndpointExplorerCallback.this.requestCreated = saveRequestAction.showNewRestRequestDialog();
                EndpointExplorerCallback.this.browserComponent.executeJavaScript(String.format("window.closeHandler(%s)", EndpointExplorerCallback.this.requestCreated));
            }
        });
    }

    private static String sendRequest(HttpUriRequest httpUriRequest) throws IOException {
        CloseableHttpResponse response = HttpClientSupport.getHttpClient().execute(httpUriRequest);
        return EndpointExplorerCallback.getResponseAsString((HttpResponse)response);
    }

    public String sendRequest(String json) {
        Analytics.trackAction(SoapUIActions.EXPLORE_API_CLICK_SEND);
        String url = "";
        String method = "";
        HashMap headersMap = null;
        String payload = "";
        try {
            JSONObject request = new JSONObject(json);
            url = this.extractUrl(request);
            method = this.extractMethod(request);
            headersMap = this.extractHeaders(request);
            payload = this.extractPayload(request);
        }
        catch (JSONException e) {
            SoapUI.logError(e);
        }
        try {
            switch (method) {
                case "GET": {
                    HttpGet httpGet = new HttpGet(url);
                    this.setHeaders((AbstractHttpMessage)httpGet, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpGet);
                }
                case "POST": {
                    HttpPost httpPost = new HttpPost(url);
                    this.setHeadersAndPayload((HttpEntityEnclosingRequestBase)httpPost, headersMap, payload);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpPost);
                }
                case "PUT": {
                    HttpPut httpPut = new HttpPut(url);
                    this.setHeadersAndPayload((HttpEntityEnclosingRequestBase)httpPut, headersMap, payload);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpPut);
                }
                case "DELETE": {
                    HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url);
                    this.setHeadersAndPayload(httpDelete, headersMap, payload);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpDelete);
                }
                case "HEAD": {
                    HttpHead httpHead = new HttpHead(url);
                    this.setHeaders((AbstractHttpMessage)httpHead, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpHead);
                }
                case "OPTIONS": {
                    HttpOptions httpOptions = new HttpOptions(url);
                    this.setHeaders((AbstractHttpMessage)httpOptions, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpOptions);
                }
                case "TRACE": {
                    HttpTrace httpTrace = new HttpTrace(url);
                    this.setHeaders((AbstractHttpMessage)httpTrace, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpTrace);
                }
                case "PATCH": {
                    HttpPatch httpPatch = new HttpPatch(url);
                    this.setHeadersAndPayload(httpPatch, headersMap, payload);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpPatch);
                }
                case "PROPFIND": {
                    HttpPropFindMethod httpPropFind = new HttpPropFindMethod(url);
                    this.setHeadersAndPayload(httpPropFind, headersMap, payload);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpPropFind);
                }
                case "LOCK": {
                    HttpLockMethod httpLock = new HttpLockMethod(url);
                    this.setHeadersAndPayload(httpLock, headersMap, payload);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpLock);
                }
                case "UNLOCK": {
                    HttpUnlockMethod httpUnlock = new HttpUnlockMethod(url);
                    this.setHeaders((AbstractHttpMessage)httpUnlock, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpUnlock);
                }
                case "COPY": {
                    HttpCopyMethod httpCopy = new HttpCopyMethod(url);
                    this.setHeaders((AbstractHttpMessage)httpCopy, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpCopy);
                }
                case "PURGE": {
                    HttpPurgeMethod httpPurge = new HttpPurgeMethod(url);
                    this.setHeaders((AbstractHttpMessage)httpPurge, headersMap);
                    return EndpointExplorerCallback.sendRequest((HttpUriRequest)httpPurge);
                }
            }
            return "Unsupported method";
        }
        catch (Exception e) {
            SoapUI.logError(e);
            if (e instanceof UnknownHostException) {
                return UNKNOWN_HOST_EXCEPTION_RESPONSE_TEXT;
            }
            if (StringUtils.hasContent(e.getMessage())) {
                return e.getMessage();
            }
            return e.getCause().getMessage();
        }
    }

    public void exploreAPIAddHeader() {
        Analytics.trackAction(SoapUIActions.EXPLORE_API_ADD_HEADER);
    }

    public void exploreAPIchangeHTTPMethod(String changeMethodTo) {
        Analytics.trackAction(SoapUIActions.EXPLORE_API_CHANGE_HTTP_METHOD, "ChangeMethodTo", changeMethodTo);
    }

    public void exploreAPIClickAuthHeadersTab() {
        Analytics.trackAction(SoapUIActions.EXPLORE_API_CLICK_AUTH_HEADERS_TAB);
    }

    public void exploreAPIClickBodyTab() {
        Analytics.trackAction(SoapUIActions.EXPLORE_API_CLICK_BODY_TAB);
    }

    public void exploreAPIDontShowAgain(boolean newValue) {
        if (newValue) {
            Analytics.trackAction(SoapUIActions.EXPLORE_API_DONT_SHOW_ON_LAUNCH);
        }
        SoapUI.getSettings().setBoolean(UISettings.SHOW_ENDPOINT_EXPLORER_ON_START, !newValue);
    }

    private String extractUrl(JSONObject request) {
        try {
            if (request.getString(URL_PROPERTY) != null) {
                return request.getString(URL_PROPERTY);
            }
        }
        catch (JSONException e) {
            return "";
        }
        return "";
    }

    private String extractMethod(JSONObject request) {
        try {
            if (request.getString(METHOD_PROPERTY) != null) {
                return request.getString(METHOD_PROPERTY);
            }
        }
        catch (JSONException e) {
            return "";
        }
        return "";
    }

    private String extractPayload(JSONObject request) {
        try {
            if (request.getString(PAYLOAD_PROPERTY) != null) {
                return request.getString(PAYLOAD_PROPERTY);
            }
        }
        catch (JSONException e) {
            return "";
        }
        return "";
    }

    private static String getResponseAsString(HttpResponse response) {
        StringBuilder builder = new StringBuilder();
        builder.append(response.getStatusLine().toString());
        try {
            builder.append(StringUtils.fixLineSeparator("\r\n"));
        }
        catch (UnsupportedEncodingException e) {
            SoapUI.logError(e);
        }
        for (Header header : response.getAllHeaders()) {
            builder.append(header.getName());
            builder.append("=");
            builder.append(header.getValue());
            builder.append("\r\n");
        }
        builder.append("\r\n");
        if (response.getEntity() != null) {
            try {
                builder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    private HashMap extractHeaders(JSONObject request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        try {
            if (request.getJSONArray(HEADERS_PROPERTY) != null) {
                JSONArray headersArray = request.getJSONArray(HEADERS_PROPERTY);
                for (int i = 0; i < headersArray.length(); ++i) {
                    JSONArray headerGroup = (JSONArray)headersArray.get(i);
                    String headerName = (String)headerGroup.get(0);
                    if (!StringUtils.hasContent(headerName)) continue;
                    String headerValue = (String)headerGroup.get(1);
                    headersMap.put(headerName, headerValue);
                }
            }
        }
        catch (JSONException e) {
            return headersMap;
        }
        return headersMap;
    }

    private void setHeaders(AbstractHttpMessage message, Map<String, String> headersMap) {
        for (Map.Entry<String, String> entry : headersMap.entrySet()) {
            if (!StringUtils.hasContent(entry.getKey())) continue;
            message.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private void setHeadersAndPayload(HttpEntityEnclosingRequestBase request, Map<String, String> headersMap, String payload) {
        this.setHeaders((AbstractHttpMessage)request, headersMap);
        request.setEntity((HttpEntity)new ByteArrayEntity(payload.getBytes()));
    }
}

