/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.method;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.actions.RestServiceBuilder;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.actions.explorer.RequestInspectionData;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.ModelItemNamer;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.tools.JavaFXTools;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javax.swing.AbstractAction;
import javax.swing.JPanel;

public class SaveRequestAction
extends AbstractAction {
    private static final MessageSupport messages = MessageSupport.getMessages(SaveRequestAction.class);
    private static final String NEW_PROJECT_OPTION = "[new project]";
    private static final String DEFAULT_PROJECT_NAME = "Project";
    private static final int DIALOG_WIDTH = 520;
    private static final int DIALOG_HEIGHT = 300;
    private static final Dimension PROJECTS_FORM_SIZE = new Dimension(400, 100);
    private XFormDialog dialog;
    private Project selectedProject;
    private Map<String, Object> context;

    public SaveRequestAction(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showNewRestRequestDialog();
    }

    public boolean showNewRestRequestDialog() {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        } else {
            this.dialog.setValue(Form.RESOURCENAME, "");
        }
        this.dialog.getFormField(Form.PROJECTS).setProperty("component", this.getProjectListComponent());
        this.dialog.getFormField(Form.PROJECTS).setProperty("preferredSize", PROJECTS_FORM_SIZE);
        this.dialog.setSize(520, 300);
        boolean dialogResult = this.dialog.show();
        if (dialogResult) {
            String requestName = this.dialog.getValue(Form.RESOURCENAME);
            RestRequest request = this.addRequest(this.context, requestName);
            if (this.dialog.getBooleanValue(Form.OPENSREQUEST)) {
                UISupport.selectAndShow(request);
            } else {
                UISupport.select(request.getResource().getService().getProject());
            }
        }
        return dialogResult;
    }

    private JPanel getProjectListComponent() {
        final Workspace workspace = SoapUI.getWorkspace();
        ObservableList projectNames = FXCollections.observableArrayList();
        projectNames.add((Object)NEW_PROJECT_OPTION);
        for (Project project : workspace.getProjectList()) {
            if (!project.isOpen()) continue;
            projectNames.add((Object)project.getName());
        }
        ListView projectsListView = new ListView(projectNames);
        projectsListView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SaveRequestAction.this.selectedProject = workspace.getProjectByName(newValue);
            }
        });
        final Scene scene = new Scene((Parent)projectsListView);
        final JFXPanel panel = new JFXPanel();
        JavaFXTools.runAndWait(new Runnable(){

            @Override
            public void run() {
                panel.setScene(scene);
            }
        });
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)panel, "Center");
        return container;
    }

    private RestRequest addRequest(Map<String, Object> context, String requestName) {
        RestRequest restRequest;
        block2: {
            RestServiceBuilder serviceBuilder = new RestServiceBuilder();
            WsdlProject project = null;
            restRequest = null;
            WorkspaceImpl workspace = (WorkspaceImpl)SoapUI.getWorkspace();
            List urls = (List)context.get("URLs");
            List methods = (List)context.get("Methods");
            List inspectionDataList = (List)context.get("InspectionData");
            try {
                String url = urls == null ? null : (String)urls.get(0);
                RestRequestInterface.HttpMethod method = methods == null ? null : (RestRequestInterface.HttpMethod)((Object)methods.get(0));
                RequestInspectionData inspectionData = inspectionDataList == null ? null : (RequestInspectionData)inspectionDataList.get(0);
                project = this.selectedProject == null ? workspace.createProject(ModelItemNamer.createName(DEFAULT_PROJECT_NAME, workspace.getProjectList()), null) : (WsdlProject)this.selectedProject;
                restRequest = inspectionData == null ? serviceBuilder.createRestServiceWithMethod(project, url, method, false, requestName) : serviceBuilder.createRestServiceFromInspectionData(project, url, method, inspectionData, false, requestName);
            }
            catch (Exception ex) {
                UISupport.showErrorMessage(ex.getMessage());
                if (project == null) break block2;
                workspace.removeProject(project);
            }
        }
        return restRequest;
    }

    static /* synthetic */ MessageSupport access$100() {
        return messages;
    }

    @AForm(name="Form.Title", description="Form.Description")
    public static interface Form {
        @AField(description="Form.ResourceName.Description", type=AField.AFieldType.STRING)
        public static final String RESOURCENAME = SaveRequestAction.access$100().get("Form.ResourceName.Label");
        @AField(description="Form.OpenRequest.Description", type=AField.AFieldType.BOOLEAN)
        public static final String OPENSREQUEST = SaveRequestAction.access$100().get("Form.OpenRequest.Label");
        @AField(description="Form.Projects.Description", type=AField.AFieldType.COMPONENT)
        public static final String PROJECTS = SaveRequestAction.access$100().get("Form.Projects.Label");
    }
}

