/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth1Profile;
import com.eviware.soapui.impl.rest.actions.oauth.GoogleOAuth1ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuthParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth1ClientFacade;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class GetOAuth1TokenAction
extends AbstractAction {
    private static final MessageSupport messages = MessageSupport.getMessages(GetOAuth1TokenAction.class);
    private final OAuth1Profile target;

    public GetOAuth1TokenAction(OAuth1Profile target, String name) {
        this.target = target;
        this.putValue("Name", name);
        this.putValue("ShortDescription", messages.get("GetOAuth1TokenAction.Description"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.getOAuthClientFacade().requestAccessToken(this.target);
        }
        catch (InvalidOAuthParametersException e) {
            UISupport.showErrorMessage(messages.get("GetOAuth1TokenAction.Error.InvalidParameters") + e.getMessage());
        }
        catch (Exception e) {
            SoapUI.logError(e, messages.get("GetOAuth1TokenAction.Error.CommonError"));
            UISupport.showErrorMessage(messages.get("GetOAuth1TokenAction.Error.GUIMessage"));
        }
    }

    protected OAuth1ClientFacade getOAuthClientFacade() {
        return new GoogleOAuth1ClientFacade();
    }
}

