/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.config.AccessTokenStatusConfig;
import com.eviware.soapui.impl.rest.OAuth1Profile;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;

public class OAuth1Parameters {
    final String temporaryTokenUri;
    final String authorizationUri;
    final String redirectUri;
    final String accessTokenUri;
    final String consumerKey;
    final String consumerSecret;
    private final OAuth1Profile profile;

    public OAuth1Parameters(OAuth1Profile profile) {
        this.profile = profile;
        this.temporaryTokenUri = this.expandProperty(profile, profile.getTemporaryTokenURI());
        this.authorizationUri = this.expandProperty(profile, profile.getAuthorizationURI());
        this.redirectUri = this.expandProperty(profile, profile.getRedirectURI());
        this.accessTokenUri = this.expandProperty(profile, profile.getAccessTokenURI());
        this.consumerKey = this.expandProperty(profile, profile.getConsumerKey());
        this.consumerSecret = this.expandProperty(profile, profile.getConsumerSecret());
    }

    void setAccessTokenInProfile(String accessToken) {
        this.profile.applyRetrievedAccessToken(accessToken);
    }

    void setTokenSecretInProfile(String tokenSecret) {
        this.profile.applyRetrievedTokenSecret(tokenSecret);
    }

    public void setAccessTokenIssuedTimeInProfile(long issuedTime) {
        this.profile.setAccessTokenIssuedTime(issuedTime);
    }

    public void waitingForAuthorization() {
        this.profile.setAccessTokenStatus(AccessTokenStatusConfig.WAITING_FOR_AUTHORIZATION);
    }

    private String expandProperty(OAuth1Profile profile, String value) {
        return PropertyExpander.expandProperties(profile.getContainer().getProject(), value);
    }

    public void receivedAuthorizationCode() {
        this.profile.setAccessTokenStatus(AccessTokenStatusConfig.RECEIVED_AUTHORIZATION_CODE);
    }

    public void retrievalCanceled() {
        this.profile.setAccessTokenStatus(AccessTokenStatusConfig.RETRIEVAL_CANCELED);
    }

    public void applyRetrievedAccessToken(String accessToken) {
        this.profile.applyRetrievedAccessToken(accessToken);
    }

    public boolean isAccessTokenRetrievedFromServer() {
        return this.profile.getAccessTokenStatus() == AccessTokenStatusConfig.RETRIEVED_FROM_SERVER;
    }
}

