/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.component;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.panels.component.RestResourceEditor;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

class RestResourceEditorPopupWindow
extends JDialog {
    private static final ImageIcon CONNECTOR_ICON = UISupport.createImageIcon("/connector.png");
    JTextField basePathTextField;
    List<RestSubResourceTextField> restSubResourceTextFields;
    private RestResource targetResource;
    private RestResource focusedResource;

    RestResourceEditorPopupWindow(RestResource resource, RestResource focusedResource) {
        super(SoapUI.getFrame());
        this.targetResource = resource;
        this.focusedResource = focusedResource;
        this.setModal(true);
        this.setResizable(false);
        this.setMinimumSize(new Dimension(230, 0));
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        JButton okButton = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RestResourceEditorPopupWindow.this.basePathTextField != null) {
                    RestResourceEditorPopupWindow.this.targetResource.getInterface().setBasePath(RestResourceEditorPopupWindow.this.basePathTextField.getText().trim());
                }
                for (RestSubResourceTextField restSubResourceTextField : RestResourceEditorPopupWindow.this.restSubResourceTextFields) {
                    restSubResourceTextField.getRestResource().setPath(restSubResourceTextField.getTextField().getText().trim());
                }
                RestResourceEditor.scanForTemplateParameters(RestResourceEditorPopupWindow.this.targetResource);
                RestResourceEditorPopupWindow.this.dispose();
            }
        });
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestResourceEditorPopupWindow.this.dispose();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        cancelButton.getActionMap().put("cancel", cancelAction);
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)okButton, (JButton)cancelButton);
        buttonBar.setLayout(new FlowLayout(2));
        contentPane.add((Component)this.createResourceEditorPanel(focusedResource), "Center");
        contentPane.add((Component)buttonBar, "South");
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
    }

    private JPanel createResourceEditorPanel(RestResource focusedResource) {
        JPanel panel = new JPanel(new BorderLayout());
        Box contentBox = Box.createVerticalBox();
        JLabel changeWarningLabel = new JLabel(" ");
        changeWarningLabel.setBorder(BorderFactory.createCompoundBorder(contentBox.getBorder(), BorderFactory.createEmptyBorder(10, 0, 0, 0)));
        this.addBasePathFieldIfApplicable(contentBox, changeWarningLabel);
        this.addResourceFields(focusedResource, contentBox, changeWarningLabel);
        panel.add((Component)contentBox, "North");
        panel.add((Component)changeWarningLabel, "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return panel;
    }

    private void addResourceFields(RestResource focusedResource, Box contentBox, JLabel changeWarningLabel) {
        this.restSubResourceTextFields = new ArrayList<RestSubResourceTextField>();
        int rowIndex = contentBox.getComponents().length;
        for (RestResource restResource : RestUtils.extractAncestorsParentFirst(this.targetResource)) {
            Box row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this.addConnectorIfApplicable(rowIndex, row);
            RestSubResourceTextField restSubResourceTextField = new RestSubResourceTextField(restResource);
            JTextField innerTextField = restSubResourceTextField.getTextField();
            innerTextField.getDocument().addDocumentListener(new PathChangeListener(changeWarningLabel, restResource));
            this.restSubResourceTextFields.add(restSubResourceTextField);
            Box textFieldBox = this.createBoxWith(innerTextField);
            row.add(textFieldBox);
            contentBox.add(row);
            if (restResource == focusedResource) {
                this.moveFocusToField(innerTextField);
            }
            ++rowIndex;
        }
    }

    private void addConnectorIfApplicable(int rowIndex, Box row) {
        if (rowIndex > 1) {
            row.add(Box.createHorizontalStrut((rowIndex - 1) * CONNECTOR_ICON.getIconWidth()));
        }
        if (rowIndex >= 1) {
            row.add(new JLabel(CONNECTOR_ICON));
        }
    }

    private void moveFocusToField(final JTextField innerTextField) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                innerTextField.requestFocusInWindow();
                innerTextField.selectAll();
            }
        });
    }

    private Box createBoxWith(JTextField innerTextField) {
        Box textFieldBox = Box.createVerticalBox();
        textFieldBox.add(Box.createVerticalGlue());
        textFieldBox.add(innerTextField);
        return textFieldBox;
    }

    private void addBasePathFieldIfApplicable(Box contentBox, JLabel changeWarningLabel) {
        if (!StringUtils.isNullOrEmpty(this.targetResource.getInterface().getBasePath())) {
            this.basePathTextField = new JTextField(this.targetResource.getInterface().getBasePath());
            this.basePathTextField.getDocument().addDocumentListener(new PathChangeListener(changeWarningLabel, this.targetResource.getTopLevelResource()));
            this.basePathTextField.setMaximumSize(new Dimension(340, (int)this.basePathTextField.getPreferredSize().getHeight()));
            Box row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(this.createBoxWith(this.basePathTextField));
            contentBox.add(row);
            if (this.focusedResource == null) {
                this.moveFocusToField(this.basePathTextField);
            }
        }
    }

    class RestSubResourceTextField {
        private RestResource restResource;
        private JTextField textField;

        private RestSubResourceTextField(RestResource restResource) {
            this.restResource = restResource;
            this.textField = new JTextField(restResource.getPath());
            this.textField.setMaximumSize(new Dimension(340, (int)this.textField.getPreferredSize().getHeight()));
            this.textField.setPreferredSize(new Dimension(340, (int)this.textField.getPreferredSize().getHeight()));
        }

        public JTextField getTextField() {
            return this.textField;
        }

        public RestResource getRestResource() {
            return this.restResource;
        }
    }

    private class PathChangeListener
    extends DocumentListenerAdapter {
        private final JLabel changeWarningLabel;
        private RestResource affectedRestResource;

        public PathChangeListener(JLabel changeWarningLabel, RestResource affectedRestResource) {
            this.changeWarningLabel = changeWarningLabel;
            this.affectedRestResource = affectedRestResource;
        }

        @Override
        public void update(Document document) {
            int affectedRequestCount = this.getRequestCountForResource(this.affectedRestResource);
            if (affectedRequestCount > 0) {
                this.changeWarningLabel.setText(String.format("<html>Changes will affect <b>%d</b> request%s</html>", affectedRequestCount, affectedRequestCount > 1 ? "s" : ""));
                this.changeWarningLabel.setVisible(true);
            } else {
                this.changeWarningLabel.setVisible(false);
            }
        }

        private int getRequestCountForResource(RestResource affectedRestResource) {
            int affectedRequestCount = affectedRestResource.getRequestCount();
            for (RestResource childResource : affectedRestResource.getAllChildResources()) {
                affectedRequestCount += childResource.getRequestCount();
            }
            return affectedRequestCount;
        }
    }
}

