/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.inspectors.representations;

import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.panels.request.inspectors.representations.AbstractRestRepresentationsInspector;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import org.apache.xmlbeans.XmlCursor;

public class RestResponseRepresentationsInspector
extends AbstractRestRepresentationsInspector
implements SubmitListener {
    private JCheckBox enableRecordingCheckBox;
    public static final String RECORD_RESPONSE_REPRESENTATIONS = "RecordResponseRepresentations";
    private RestRequestInterface request;

    protected RestResponseRepresentationsInspector(RestRequestInterface request) {
        super(request.getRestMethod(), "Representations", "Response Representations", new RestRepresentation.Type[]{RestRepresentation.Type.RESPONSE, RestRepresentation.Type.FAULT});
        request.addSubmitListener(this);
        this.request = request;
    }

    @Override
    protected void addToToolbar(JXToolBar toolbar) {
        this.enableRecordingCheckBox = new JCheckBox("Auto-Create");
        this.enableRecordingCheckBox.setToolTipText("Automatically create Representations from received Responses");
        this.enableRecordingCheckBox.setOpaque(false);
        UISupport.setFixedSize(this.enableRecordingCheckBox, 150, 20);
        toolbar.addFixed(this.enableRecordingCheckBox);
        XmlBeansSettingsImpl settings = this.getMethod().getSettings();
        if (settings.isSet(RECORD_RESPONSE_REPRESENTATIONS)) {
            this.enableRecordingCheckBox.setSelected(settings.getBoolean(RECORD_RESPONSE_REPRESENTATIONS));
        } else {
            this.enableRecordingCheckBox.setSelected(this.getMethod().getResource() == null || this.getMethod().getResource().getService().isGenerated());
        }
        this.enableRecordingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RestResponseRepresentationsInspector.this.getMethod().getSettings().setBoolean(RestResponseRepresentationsInspector.RECORD_RESPONSE_REPRESENTATIONS, RestResponseRepresentationsInspector.this.enableRecordingCheckBox.isSelected());
            }
        });
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        return true;
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        HttpResponse response = (HttpResponse)submit.getResponse();
        if (response != null && this.enableRecordingCheckBox.isSelected()) {
            if (HttpUtils.isErrorStatus(response.getStatusCode())) {
                this.extractRepresentation(response, RestRepresentation.Type.FAULT);
            } else {
                this.extractRepresentation(response, RestRepresentation.Type.RESPONSE);
            }
        }
    }

    protected void extractRepresentation(HttpResponse response, RestRepresentation.Type type) {
        int c;
        RestRepresentation[] representations = this.getMethod().getRepresentations(type, null);
        for (c = 0; c < representations.length; ++c) {
            if (representations[c].getMediaType() == null || !representations[c].getMediaType().equals(response.getContentType())) continue;
            List<?> status = representations[c].getStatus();
            if (status != null && status.contains(response.getStatusCode())) break;
            status = status == null ? new ArrayList() : new ArrayList(status);
            status.add(response.getStatusCode());
            representations[c].setStatus(status);
            break;
        }
        if (c == representations.length) {
            RestRepresentation representation = this.getMethod().addNewRepresentation(type);
            representation.setMediaType(response.getContentType());
            representation.setStatus(Arrays.asList(response.getStatusCode()));
            String xmlContent = response.getContentAsXml();
            if (xmlContent != null && !xmlContent.equals("<xml/>")) {
                try {
                    XmlCursor cursor = XmlUtils.createXmlObject(xmlContent).newCursor();
                    cursor.toFirstChild();
                    representation.setElement(cursor.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void release() {
        super.release();
        this.request.removeSubmitListener(this);
    }
}

