/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.content;

import com.eviware.soapui.impl.wsdl.panels.teststeps.GraphQLRequestTestStepDesktopPanel;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequestInterface;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class GraphQLRequestContentView
extends AbstractXmlEditorView<XmlDocument>
implements PropertyChangeListener {
    private static final String VIEW_ID = "GraphQLRequestView";
    private static final String TITLE = "Request";
    protected final GraphQLTestRequestInterface graphQLRequest;
    protected RSyntaxTextArea contentEditor;
    private boolean updatingRequest;
    private JSplitPane splitter;
    protected JComponent mainPanel;

    public GraphQLRequestContentView(GraphQLRequestTestStepDesktopPanel.GraphQLRequestMessageEditor editor, GraphQLTestRequestInterface graphQLRequest) {
        super(TITLE, editor, VIEW_ID);
        this.graphQLRequest = graphQLRequest;
        this.graphQLRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.mainPanel == null) {
            this.buildComponent();
        }
        return this.mainPanel;
    }

    protected void buildComponent() {
        Component queryPanel = this.buildQueryPanel();
        Component variablesPanel = this.buildVariablesPanel();
        this.splitter = UISupport.createVerticalSplit(queryPanel, variablesPanel);
        this.splitter.setResizeWeight(0.5);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.splitter);
    }

    protected Component buildQueryPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.contentEditor = SyntaxEditorUtil.createDefaultJsonSyntaxTextArea();
        this.contentEditor.setCurrentLineHighlightColor(Color.WHITE);
        SyntaxEditorUtil.setMediaType(this.contentEditor, this.graphQLRequest.getMediaType());
        this.contentEditor.setText(this.graphQLRequest.getQuery());
        this.addPropertyExpansionPopup(this.contentEditor);
        this.contentEditor.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                if (!GraphQLRequestContentView.this.updatingRequest) {
                    GraphQLRequestContentView.this.updatingRequest = true;
                    GraphQLRequestContentView.this.graphQLRequest.setQuery(this.getText(document));
                    GraphQLRequestContentView.this.updatingRequest = false;
                }
            }
        });
        this.applyCodeCompletion();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView((Component)this.contentEditor);
        contentPanel.add((Component)scrollPane, "Center");
        return contentPanel;
    }

    protected void applyCodeCompletion() {
    }

    protected void removeCodeCompletion() {
    }

    protected Component buildVariablesPanel() {
        JPanel variablesPanel = new JPanel(new BorderLayout());
        JLabel variablesLabel = new JLabel("Query Variables");
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add(variablesLabel);
        variablesPanel.add((Component)innerPanel, "North");
        RSyntaxTextArea variablesEditor = SyntaxEditorUtil.createDefaultJsonSyntaxTextArea();
        variablesEditor.setCurrentLineHighlightColor(Color.WHITE);
        SyntaxEditorUtil.setMediaType(variablesEditor, this.graphQLRequest.getMediaType());
        variablesEditor.setText(this.graphQLRequest.getVariables());
        this.addPropertyExpansionPopup(variablesEditor);
        variablesEditor.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                if (!GraphQLRequestContentView.this.updatingRequest) {
                    GraphQLRequestContentView.this.updatingRequest = true;
                    GraphQLRequestContentView.this.graphQLRequest.setVariables(this.getText(document));
                    GraphQLRequestContentView.this.updatingRequest = false;
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView((Component)variablesEditor);
        variablesPanel.add((Component)scrollPane, "Center");
        return variablesPanel;
    }

    protected void addPropertyExpansionPopup(RSyntaxTextArea textField) {
        PropertyExpansionPopupListener.enable(textField, (ModelItem)this.graphQLRequest);
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }

    @Override
    public void release() {
        this.removeCodeCompletion();
        super.release();
    }

    @Override
    public int getSupportScoreForContentType(String contentType) {
        return JsonUtil.seemsToBeJsonContentType(contentType) ? 2 : 0;
    }
}

