/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.html;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.monitor.JProxyServletWsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponentFactory;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HttpHtmlMessageExchangeResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final MessageExchangeModelItem messageExchangeModelItem;
    private JPanel panel;
    private WebViewBasedBrowserComponent browser;
    private JPanel contentPanel;
    private boolean initialized = false;

    public HttpHtmlMessageExchangeResponseView(XmlEditor editor, MessageExchangeModelItem messageExchangeModelItem) {
        super("HTML", editor, "HTML Response");
        this.messageExchangeModelItem = messageExchangeModelItem;
        messageExchangeModelItem.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add(this.buildToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        if (this.browser != null) {
            this.browser.close(true);
        }
        this.messageExchangeModelItem.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        JLabel statusLabel = new JLabel();
        statusLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return statusLabel;
    }

    private Component buildContent() {
        this.contentPanel = new JPanel(new BorderLayout());
        return this.contentPanel;
    }

    @Override
    public boolean activate(EditorLocation<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument> location) {
        boolean activated = super.activate(location);
        if (activated && !this.initialized) {
            this.initialized = true;
            if (SoapUI.isBrowserDisabled()) {
                this.contentPanel.add(new JLabel("Browser component is disabled."));
            } else {
                this.browser = WebViewBasedBrowserComponentFactory.createBrowserComponent(false);
                Component component = this.browser.getComponent();
                component.setMinimumSize(new Dimension(100, 100));
                this.contentPanel.add(new JScrollPane(component));
                this.setEditorContent(this.messageExchangeModelItem);
            }
        }
        return activated;
    }

    @Override
    public boolean deactivate() {
        boolean deactivated = super.deactivate();
        if (deactivated && this.browser != null) {
            this.browser.setContent("");
        }
        return deactivated;
    }

    protected void setEditorContent(JProxyServletWsdlMonitorMessageExchange jproxyServletWsdlMonitorMessageExchange) {
        if (this.browser == null) {
            return;
        }
        if (jproxyServletWsdlMonitorMessageExchange != null) {
            String contentType = jproxyServletWsdlMonitorMessageExchange.getResponseContentType();
            if (contentType.contains("html") || contentType.contains("text")) {
                try {
                    String content = jproxyServletWsdlMonitorMessageExchange.getResponseContent();
                    this.browser.setContent(content, contentType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.isSupportedContentType(contentType)) {
                try {
                    String ext = ContentTypeHandler.getExtensionForContentType(contentType);
                    File temp = File.createTempFile("response", "." + ext);
                    FileOutputStream fileOutputStream = new FileOutputStream(temp);
                    this.writeHttpBody(jproxyServletWsdlMonitorMessageExchange.getRawResponseData(), fileOutputStream);
                    fileOutputStream.close();
                    this.browser.navigate(temp.toURI().toURL().toString());
                    temp.deleteOnExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.browser.setContent("unsupported content-type [" + contentType + "]");
            }
        } else {
            this.browser.setContent("-missing content-");
        }
    }

    private boolean isSupportedContentType(String contentType) {
        return contentType.toLowerCase().contains("image");
    }

    protected void setEditorContent(MessageExchangeModelItem messageExchangeModelItem2) {
        if (this.browser == null) {
            return;
        }
        if (messageExchangeModelItem2 != null && messageExchangeModelItem2.getMessageExchange() != null) {
            String contentType = messageExchangeModelItem2.getMessageExchange().getResponseHeaders().get("Content-Type", "");
            if (contentType.contains("html") || contentType.contains("text")) {
                try {
                    String content = messageExchangeModelItem2.getMessageExchange().getResponseContent();
                    this.browser.setContent(content, contentType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!contentType.contains("xml")) {
                try {
                    String ext = ContentTypeHandler.getExtensionForContentType(contentType);
                    File temp = File.createTempFile("response", "." + ext);
                    FileOutputStream fileOutputStream = new FileOutputStream(temp);
                    this.writeHttpBody(messageExchangeModelItem2.getMessageExchange().getRawResponseData(), fileOutputStream);
                    fileOutputStream.close();
                    this.browser.navigate(temp.toURI().toURL().toString());
                    temp.deleteOnExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.browser.setContent("<missing content>");
        }
    }

    private void writeHttpBody(byte[] rawResponse, FileOutputStream out) throws IOException {
        byte[] divider = "\r\n\r\n".getBytes();
        for (int index = 0; index < rawResponse.length - divider.length; ++index) {
            int i;
            for (i = 0; i < divider.length && rawResponse[index + i] == divider[i]; ++i) {
            }
            if (i != divider.length) continue;
            out.write(rawResponse, index + divider.length, rawResponse.length - (index + divider.length));
            return;
        }
        out.write(rawResponse);
    }

    private Component buildToolbar() {
        return UISupport.createToolbar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("messageExchange") && this.browser != null && evt.getNewValue() != null && this.isActive()) {
            this.setEditorContent((JProxyServletWsdlMonitorMessageExchange)evt.getNewValue());
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }

    @Override
    public int getSupportScoreForContentType(String contentType) {
        return contentType.toLowerCase().endsWith("html") ? 2 : 0;
    }
}

