/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.DirectAccessPropertyHolderTableModel;

public class RestParamsTableModel
extends DirectAccessPropertyHolderTableModel<RestParamsPropertyHolder> {
    private static final String NAME = "Name";
    private static final String VALUE = "Value";
    private static final String STYLE = "Style";
    public static final int NAME_COLUMN_INDEX = 0;
    public static final int VALUE_COLUMN_INDEX = 1;
    public static final int STYLE_COLUMN_INDEX = 2;
    public static final int LOCATION_COLUMN_INDEX = 3;
    static String[] COLUMN_NAMES = new String[]{"Name", "Default value", "Style", "Level"};
    static Class[] COLUMN_TYPES = new Class[]{String.class, String.class, RestParamsPropertyHolder.ParameterStyle.class, NewRestResourceActionBase.ParamLocation.class};
    private Mode mode;

    public RestParamsTableModel(RestParamsPropertyHolder params, Mode mode) {
        super(params);
        this.mode = mode;
        if (params.getModelItem() != null) {
            params.getModelItem().addPropertyChangeListener(this);
        }
    }

    public RestParamsTableModel(RestParamsPropertyHolder params) {
        this(params, Mode.FULL);
    }

    public boolean isInMinimalMode() {
        return this.mode == Mode.MINIMAL;
    }

    @Override
    public int getColumnCount() {
        return this.mode.columnTypes.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.isColumnIndexOutOfBound(columnIndex)) {
            return null;
        }
        return this.mode.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.isColumnIndexOutOfBound(columnIndex)) {
            return null;
        }
        return this.mode.columnTypes[columnIndex];
    }

    private boolean isColumnIndexOutOfBound(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.mode.columnTypes.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public NewRestResourceActionBase.ParamLocation getParamLocationAt(int rowIndex) {
        return this.getParameterAt(rowIndex).getParamLocation();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RestParamProperty prop = this.getParameterAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return prop.getName();
            }
            case 1: {
                return prop.getValue();
            }
            case 2: {
                return this.mode == Mode.MINIMAL ? null : prop.getStyle();
            }
            case 3: {
                return this.mode != Mode.FULL ? null : prop.getParamLocation();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        RestParamProperty prop = this.getParameterAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (this.propertyExists(value, prop)) {
                    return;
                }
                ((RestParamsPropertyHolder)this.params).renameProperty(prop.getName(), value.toString());
                return;
            }
            case 1: {
                prop.setDefaultValue(value.toString());
                prop.setValue(value.toString());
                return;
            }
            case 2: {
                if (this.mode != Mode.MINIMAL) {
                    prop.setStyle((RestParamsPropertyHolder.ParameterStyle)((Object)value));
                }
                return;
            }
            case 3: {
                if (this.mode != Mode.FULL) break;
                if (((RestParamsPropertyHolder)this.params).getModelItem() != null && ((RestParamsPropertyHolder)this.params).getModelItem() instanceof RestRequest) {
                    this.isLastChangeParameterLevelChange = true;
                }
                ((RestParamsPropertyHolder)this.params).setParameterLocation(prop, (NewRestResourceActionBase.ParamLocation)((Object)value));
            }
        }
    }

    public RestParamProperty getParameterAt(int selectedRow) {
        return (RestParamProperty)super.getPropertyAtRow(selectedRow);
    }

    public NewRestResourceActionBase.ParamLocation[] getParameterLevels() {
        return NewRestResourceActionBase.ParamLocation.values();
    }

    public void setParams(RestParamsPropertyHolder params) {
        ((RestParamsPropertyHolder)this.params).removeTestPropertyListener(this.testPropertyListener);
        this.params = params;
        ((RestParamsPropertyHolder)this.params).addTestPropertyListener(this.testPropertyListener);
        this.fireTableDataChanged();
    }

    public void removeProperty(String propertyName) {
        ((RestParamsPropertyHolder)this.params).remove(propertyName);
    }

    public static enum Mode {
        MINIMAL(new String[]{"Name", "Value"}, new Class[]{String.class, String.class}),
        MEDIUM(new String[]{"Name", "Value", "Style"}, new Class[]{String.class, String.class, RestParamsPropertyHolder.ParameterStyle.class}),
        FULL(COLUMN_NAMES, COLUMN_TYPES);

        private final String[] columnNames;
        private final Class[] columnTypes;

        private Mode(String[] columnNames, Class[] columnTypes) {
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
        }
    }
}

