/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.UISupport;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.logging.log4j.Logger;

public class SSLUtils {
    private static final String INIT_KEYSTORE_INFO_MESSAGE = "Initializing KeyStore";

    public static KeyStore getReadyApiKeystore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        return SSLUtils.getReadyApiKeystore(null);
    }

    public static KeyStore getReadyApiKeystore(Logger logger) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        Settings settings = SoapUI.getSettings();
        if (UISupport.isWindows()) {
            // empty if block
        }
        String keyStoreUrl = SSLUtils.getKeyStoreUrl();
        String password = SSLUtils.getKeyStorePassword();
        KeyStore keyStore = SSLUtils.getKeyStore(keyStoreUrl, password, logger);
        return keyStore;
    }

    public static String getKeyStoreUrl() {
        Settings settings = SoapUI.getSettings();
        String keyStoreUrl = System.getProperty("soapui.ssl.keystore.location", settings.getString(SSLSettings.KEYSTORE, ""));
        return keyStoreUrl.trim();
    }

    public static String getKeyStorePassword() {
        Settings settings = SoapUI.getSettings();
        return System.getProperty("soapui.ssl.keystore.password", settings.getString(SSLSettings.KEYSTORE_PASSWORD, ""));
    }

    private static KeyStore getKeyStore(String keyStoreUrl, String password, Logger logger) {
        File f;
        KeyStore keyStore = null;
        char[] pwd = password.toCharArray();
        if (keyStoreUrl.trim().length() > 0 && (f = new File(keyStoreUrl)).exists()) {
            if (logger != null) {
                logger.info(INIT_KEYSTORE_INFO_MESSAGE);
            }
            try {
                KeyMaterial km = new KeyMaterial(f, pwd);
                keyStore = km.getKeyStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return keyStore;
    }

    public static X509ExtendedTrustManager getTrustAllManager() {
        return new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            }
        };
    }
}

