/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.definition.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.DefinitionContext;
import com.eviware.soapui.impl.support.definition.DefinitionCache;
import com.eviware.soapui.impl.support.definition.DefinitionLoader;
import com.eviware.soapui.impl.support.definition.InterfaceDefinition;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.support.definition.support.AbstractDefinitionCache;
import com.eviware.soapui.impl.support.definition.support.AbstractInterfaceDefinition;
import com.eviware.soapui.impl.support.definition.support.InterfaceConfigDefinitionCache;
import com.eviware.soapui.impl.support.definition.support.InvalidDefinitionException;
import com.eviware.soapui.impl.support.definition.support.StandaloneDefinitionCache;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaException;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;

public abstract class AbstractDefinitionContext<T extends AbstractInterface<?>, T2 extends DefinitionLoader, T3 extends AbstractInterfaceDefinition<T>>
implements DefinitionContext<T> {
    private String url;
    private T3 definition;
    private boolean loaded;
    private SchemaException schemaException;
    private static final Logger log = LogManager.getLogger(AbstractDefinitionContext.class);
    private T2 currentLoader;
    private T iface;
    private static Map<String, InterfaceDefinition<?>> definitionCache = new HashMap();
    private static Map<String, Integer> urlReferences = new HashMap<String, Integer>();
    private static XProgressDialog progressDialog = null;

    public AbstractDefinitionContext(String url, T iface) {
        this.url = PathUtils.ensureFilePathIsUrl(url);
        this.iface = iface;
    }

    public AbstractDefinitionContext(String url) {
        this(url, null);
    }

    @Override
    public T getInterface() {
        return this.iface;
    }

    public T3 getInterfaceDefinition() throws Exception {
        this.loadIfNecessary();
        return (T3)((AbstractInterfaceDefinition)(this.definition == null ? definitionCache.get(this.url) : this.definition));
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public synchronized boolean loadIfNecessary() throws Exception {
        if (!this.loaded) {
            this.load();
        }
        return this.loaded;
    }

    public synchronized void setDefinition(String url, boolean updateCache) throws Exception {
        if (!url.equals(this.url)) {
            this.url = url;
            if (updateCache) {
                definitionCache.remove(url);
                this.loaded = false;
                this.load();
            }
            this.loaded = this.iface != null && definitionCache.containsKey(url);
        }
    }

    public synchronized boolean load() throws Exception {
        return this.load(null);
    }

    public synchronized boolean load(T2 wsdlLoader) throws Exception {
        if (!this.loaded && this.iface != null) {
            this.loaded = definitionCache.containsKey(this.url);
        }
        if (this.loaded) {
            return true;
        }
        Loader loader = new Loader(this, wsdlLoader);
        if (progressDialog != null) {
            progressDialog.run(loader);
        } else {
            progressDialog = UISupport.getDialogs().createProgressDialog("Loading Definition", 3, "Loading definition..", true);
            progressDialog.run(loader);
        }
        if (loader.hasError()) {
            if (loader.getError() instanceof InvalidDefinitionException) {
                throw (InvalidDefinitionException)loader.getError();
            }
            if (loader.getError() instanceof SchemaException) {
                this.schemaException = (SchemaException)loader.getError();
                ArrayList<?> errorList = this.schemaException.getErrorList();
                log.error("Error loading schema types from " + this.url + ", see log for details");
                if (errorList != null) {
                    for (int c = 0; c < errorList.size(); ++c) {
                        log.error(errorList.get(c).toString());
                    }
                }
                throw new InvalidDefinitionException(this.schemaException);
            }
            throw new Exception(loader.getError());
        }
        this.loaded = true;
        return this.loaded;
    }

    public SchemaTypeLoader getSchemaTypeLoader() throws Exception {
        this.loadIfNecessary();
        return this.iface != null && definitionCache.containsKey(this.url) ? definitionCache.get(this.url).getSchemaTypeLoader() : (this.definition != null ? this.definition.getSchemaTypeLoader() : null);
    }

    public SchemaException getSchemaException() {
        return this.schemaException;
    }

    private void cacheDefinition(DefinitionCache cache) throws Exception {
        this.currentLoader = this.createDefinitionLoader(cache);
        this.currentLoader.setProgressInfo("Loading Definition");
        this.definition = this.loadDefinition(this.currentLoader);
        if (this.definition != null) {
            ((AbstractInterfaceDefinition)this.definition).setDefinitionCache(cache);
        }
        log.debug("Loaded Definition: " + (this.definition != null ? "ok" : "null"));
        if (!this.currentLoader.isAborted() && this.iface != null && ((AbstractInterface)this.iface).isDefinitionShareble()) {
            definitionCache.put(this.url, (InterfaceDefinition<?>)this.definition);
            if (urlReferences.containsKey(this.url)) {
                urlReferences.put(this.url, urlReferences.get(this.url) + 1);
            } else {
                urlReferences.put(this.url, 1);
            }
        }
        if (this.currentLoader.isAborted()) {
            throw new Exception("Loading of Definition from [" + this.url + "] was aborted");
        }
        this.loaded = true;
    }

    protected abstract T2 createDefinitionLoader(DefinitionCache var1);

    protected abstract T2 createDefinitionLoader(String var1);

    protected abstract T3 loadDefinition(T2 var1) throws Exception;

    public void release() {
        if (this.iface != null && urlReferences.containsKey(this.url)) {
            Integer i = urlReferences.get(this.url);
            if (i <= 1) {
                urlReferences.remove(this.url);
                definitionCache.remove(this.url);
            } else {
                urlReferences.put(this.url, i - 1);
            }
        }
    }

    public SchemaTypeSystem getSchemaTypeSystem() throws Exception {
        if (!this.isLoaded()) {
            this.load();
        }
        if (!definitionCache.containsKey(this.url)) {
            return null;
        }
        return definitionCache.get(this.url).getSchemaTypeSystem();
    }

    @Override
    public boolean hasSchemaTypes() {
        try {
            this.loadIfNecessary();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return false;
        }
        T3 def = this.definition != null ? this.definition : definitionCache.get(this.url);
        return def != null && def.hasSchemaTypes();
    }

    public String getUrl() {
        return this.url;
    }

    public void setInterface(T iface) {
        if (this.iface == null && iface != null) {
            if (this.definition != null) {
                if (((AbstractInterfaceDefinition)this.definition).getDefinitionCache().validate()) {
                    InterfaceConfigDefinitionCache<T> cache = new InterfaceConfigDefinitionCache<T>(iface);
                    try {
                        cache.importCache(((AbstractInterfaceDefinition)this.definition).getDefinitionCache());
                    }
                    catch (Exception e) {
                        SoapUI.logError(e);
                    }
                    ((AbstractInterfaceDefinition)this.definition).setDefinitionCache(cache);
                }
                ((AbstractInterfaceDefinition)this.definition).setIface(iface);
                definitionCache.put(this.url, (InterfaceDefinition<?>)this.definition);
            } else {
                this.loaded = false;
            }
        }
        this.iface = iface;
    }

    public static void uncache(String url) {
        definitionCache.remove(url);
        urlReferences.remove(url);
    }

    public void reload() throws Exception {
        this.getDefinitionCache().clear();
        definitionCache.remove(this.url);
        this.loaded = false;
        this.load();
    }

    @Override
    public boolean isCached() {
        return this.isLoaded() && this.definition != null && ((AbstractInterfaceDefinition)this.definition).getDefinitionCache() != null;
    }

    public List<InterfaceDefinitionPart> getDefinitionParts() throws Exception {
        this.loadIfNecessary();
        return ((AbstractInterfaceDefinition)this.getInterfaceDefinition()).getDefinitionParts();
    }

    public DefinitionCache getDefinitionCache() throws Exception {
        this.loadIfNecessary();
        return ((AbstractInterfaceDefinition)this.getInterfaceDefinition()).getDefinitionCache();
    }

    private static class Loader
    extends Worker.WorkerAdapter {
        private Throwable error;
        private T2 wsdlLoader;
        final /* synthetic */ AbstractDefinitionContext this$0;

        public Loader(T2 wsdlLoader) {
            this.this$0 = var1_1;
            this.wsdlLoader = wsdlLoader;
        }

        private T2 getDefinitionLoader() {
            if (this.wsdlLoader != null) {
                return this.wsdlLoader;
            }
            return this.this$0.createDefinitionLoader(this.this$0.url);
        }

        public boolean hasError() {
            return this.error != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct(XProgressMonitor monitor) {
            try {
                AbstractDefinitionCache cache;
                AbstractDefinitionCache abstractDefinitionCache = cache = this.this$0.iface == null ? new StandaloneDefinitionCache() : new InterfaceConfigDefinitionCache<AbstractInterface>(this.this$0.iface);
                if (!cache.validate()) {
                    monitor.setProgress(1, "Caching Definition from url [" + this.this$0.url + "]");
                    this.this$0.currentLoader = this.getDefinitionLoader();
                    this.this$0.currentLoader.setProgressMonitor(monitor, 2);
                    cache.update(this.this$0.currentLoader);
                    if (this.this$0.currentLoader.isAborted()) {
                        throw new Exception("Loading of Definition from [" + this.this$0.url + "] was aborted");
                    }
                }
                monitor.setProgress(1, "Loading Definition from " + (this.this$0.iface == null ? "url" : "cache"));
                log.debug("Loading Definition...");
                this.this$0.cacheDefinition(cache);
                Object var3_4 = null;
                return var3_4;
            }
            catch (Throwable e) {
                SoapUI.logError(e);
                this.error = e;
                Throwable throwable = e;
                return throwable;
            }
            finally {
                this.this$0.currentLoader = null;
            }
        }

        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean onCancel() {
            if (this.this$0.currentLoader == null) {
                return false;
            }
            return this.this$0.currentLoader.abort();
        }
    }
}

