/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.definition.support;

import com.eviware.soapui.impl.support.definition.DefinitionCache;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.wsdl.support.wsdl.AbstractWsdlDefinitionLoader;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class InterfaceCacheDefinitionLoader
extends AbstractWsdlDefinitionLoader {
    private String rootInConfig = "";
    private DefinitionCache config;

    public InterfaceCacheDefinitionLoader(DefinitionCache config) {
        super(config.getRootPart().getUrl());
        this.config = config;
    }

    @Override
    public InputStream load(String url) throws Exception {
        XmlObject xmlObject = this.loadXmlObject(url, null);
        return xmlObject == null ? null : xmlObject.newInputStream();
    }

    @Override
    public XmlObject loadXmlObject(String url, XmlOptions options) throws Exception {
        if (url.endsWith(this.config.getRootPart().getUrl())) {
            this.rootInConfig = url.substring(0, url.length() - this.config.getRootPart().getUrl().length());
        }
        List<InterfaceDefinitionPart> partList = this.config.getDefinitionParts();
        for (InterfaceDefinitionPart part : partList) {
            if (!(this.rootInConfig + part.getUrl()).equalsIgnoreCase(url)) continue;
            return InterfaceCacheDefinitionLoader.getPartContent(part);
        }
        if (File.separatorChar == '/') {
            url = url.replace('/', '\\');
            for (InterfaceDefinitionPart part : partList) {
                if (!(this.rootInConfig + part.getUrl()).equalsIgnoreCase(url)) continue;
                return InterfaceCacheDefinitionLoader.getPartContent(part);
            }
        } else if (File.separatorChar == '\\') {
            url = url.replace('\\', '/');
            for (InterfaceDefinitionPart part : partList) {
                if (!(this.rootInConfig + part.getUrl()).equalsIgnoreCase(url)) continue;
                return InterfaceCacheDefinitionLoader.getPartContent(part);
            }
        }
        log.error("Failed to find [" + url + "] in InterfaceCache");
        return null;
    }

    public static XmlObject getPartContent(InterfaceDefinitionPart part) throws XmlException {
        return XmlUtils.createXmlObject(part.getContent(), new XmlOptions().setLoadLineNumbers());
    }

    public void close() {
    }

    @Override
    public void setNewBaseURI(String uri) {
    }

    @Override
    public String getFirstNewURI() {
        return this.getBaseURI();
    }
}

