/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.panels;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.support.MediaTypeHandlerRegistry;
import com.eviware.soapui.impl.rest.support.handlers.JsonXmlSerializer;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public abstract class AbstractHttpXmlRequestDesktopPanel<T extends ModelItem, T2 extends HttpRequestInterface<?>>
extends AbstractHttpRequestDesktopPanel<T, T2> {
    public AbstractHttpXmlRequestDesktopPanel(T modelItem, T2 requestItem) {
        super(modelItem, requestItem);
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        return new HttpRequestMessageEditor((HttpRequestInterface)this.getRequest());
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new HttpResponseMessageEditor((HttpRequestInterface)this.getRequest());
    }

    public class HttpRequestMessageEditor
    extends AbstractHttpRequestDesktopPanel.AbstractHttpRequestMessageEditor {
        public HttpRequestMessageEditor(HttpRequestInterface<?> modelItem) {
            super((AbstractHttpRequestDesktopPanel)AbstractHttpXmlRequestDesktopPanel.this, (XmlDocument)new HttpRequestDocument(modelItem));
        }
    }

    public class HttpResponseMessageEditor
    extends AbstractHttpRequestDesktopPanel.AbstractHttpResponseMessageEditor {
        public HttpResponseMessageEditor(HttpRequestInterface<?> modelItem) {
            super((AbstractHttpRequestDesktopPanel)AbstractHttpXmlRequestDesktopPanel.this, (XmlDocument)new HttpResponseDocument(modelItem));
        }
    }

    public static class HttpResponseDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        private final HttpRequestInterface<?> modelItem;

        public HttpResponseDocument(HttpRequestInterface<?> modelItem) {
            this.modelItem = modelItem;
            modelItem.addPropertyChangeListener(RestRequestInterface.RESPONSE_PROPERTY, this);
        }

        public HttpRequestInterface<?> getRequest() {
            return this.modelItem;
        }

        @Override
        @Nonnull
        public DocumentContent getDocumentContent(EditorDocument.Format format) {
            return this.extractContentFrom(this.modelItem.getResponse(), format);
        }

        @Override
        public void setDocumentContent(DocumentContent documentContent) {
            HttpResponse response = this.getRequest().getResponse();
            if (response != null) {
                response.setResponseContent(documentContent.getContentAsString());
            }
        }

        @Override
        public String getContentType() {
            return this.modelItem.getResponse() == null ? null : this.modelItem.getResponse().getContentType();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireContentChanged();
        }

        private DocumentContent extractContentFrom(HttpResponse response, EditorDocument.Format format) {
            if (response == null) {
                return new DocumentContent(null, null);
            }
            String contentAsString = format == EditorDocument.Format.XML ? MediaTypeHandlerRegistry.getTypeHandler(response.getContentType()).createXmlRepresentation(response) : response.getContentAsString();
            return new DocumentContent(response.getContentType(), contentAsString);
        }

        @Override
        public void release() {
            super.release();
            this.modelItem.removePropertyChangeListener(RestRequestInterface.RESPONSE_PROPERTY, this);
        }
    }

    public static class HttpRequestDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        private final HttpRequestInterface<?> request;
        private boolean updating;

        public HttpRequestDocument(HttpRequestInterface<?> request) {
            this.request = request;
            request.addPropertyChangeListener(this);
        }

        public HttpRequestInterface<?> getRequest() {
            return this.request;
        }

        @Override
        @Nonnull
        public DocumentContent getDocumentContent(EditorDocument.Format format) {
            return new DocumentContent(this.getRequest().getMediaType(), this.getRequest().getRequestContent());
        }

        @Override
        public void release() {
            super.release();
            this.request.removePropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDocumentContent(DocumentContent documentContent) {
            if (!this.updating) {
                this.updating = true;
                try {
                    String contentAsString = documentContent.getContentAsString();
                    if (JsonUtil.seemsToBeJsonContentType(this.getRequest().getMediaType()) && XmlUtils.seemsToBeXml(contentAsString)) {
                        JSON json = new JsonXmlSerializer().read(contentAsString);
                        this.processNullsAndEmptyValuesIn(json);
                        this.request.setRequestContent(json.toString(3, 0));
                    } else {
                        this.request.setRequestContent(contentAsString);
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }

        @Override
        public String getContentType() {
            return this.request.getMediaType();
        }

        private void processNullsAndEmptyValuesIn(JSON json) {
            String requestContent = this.request.getRequestContent();
            if (!StringUtils.hasContent(requestContent)) {
                return;
            }
            try {
                JSON oldJson = new JsonUtil().parseTrimmedText(requestContent);
                if (!(json instanceof JSONObject) || !(oldJson instanceof JSONObject)) {
                    return;
                }
                this.overwriteNullValues((JSONObject)json, (JSONObject)oldJson);
            }
            catch (Exception e) {
                SoapUI.logError(e, "Unexpected error while parsing JSON");
            }
        }

        private void overwriteNullValues(JSONObject json, JSONObject oldJson) {
            for (Object key : json.keySet()) {
                Object value = json.get(key);
                Object oldValue = oldJson.get(key);
                if (this.isNullValue(value) && this.isEmptyJson(oldValue)) {
                    json.put(key, oldJson.get(key));
                    continue;
                }
                if (!this.isEmptyJson(value) || !(oldValue instanceof String)) continue;
                json.put(key, (Object)"");
            }
        }

        private boolean isEmptyJson(Object oldValue) {
            return oldValue != null && oldValue instanceof JSON && ((JSON)oldValue).isEmpty();
        }

        private boolean isNullValue(Object value) {
            return value == null || value.toString().equals("null");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.updating) {
                try {
                    this.updating = true;
                    if (evt.getPropertyName().equals("request") || evt.getPropertyName().equals("mediaType")) {
                        this.fireContentChanged();
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }
}

