/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.particles;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Particle;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.inferredSchema.AttributeParticleConfig;
import com.eviware.soapui.inferredSchema.MapEntryConfig;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;

public class AttributeParticle
implements Particle {
    private String name;
    private Schema schema;
    private Type type;
    private Map<String, String> attributes;

    public AttributeParticle(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
        this.type = Type.Factory.newType(schema);
        this.attributes = new HashMap<String, String>();
    }

    public AttributeParticle(AttributeParticleConfig xml, Schema schema) {
        this.schema = schema;
        this.name = xml.getName();
        this.type = Type.Factory.parse(xml.getType(), schema);
        this.attributes = new HashMap<String, String>();
        for (MapEntryConfig entry : xml.getAttributeList()) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public AttributeParticleConfig save() {
        AttributeParticleConfig xml = AttributeParticleConfig.Factory.newInstance();
        xml.setName(this.name);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            MapEntryConfig mapEntry = xml.addNewAttribute();
            mapEntry.setKey(entry.getKey());
            mapEntry.setValue(entry.getValue());
        }
        xml.setType(this.type.save());
        return xml;
    }

    @Override
    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public QName getName() {
        return new QName(this.schema.getNamespace(), this.name);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void validate(Context context) throws XmlException {
        context.getCursor().push();
        Type newType = this.type.validate(context);
        if (newType != this.type) {
            String problem = "Illegal value for attribute '" + this.name + "' with type '" + this.type.getName() + "'.";
            if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.ATTRIBUTE, this.getName(), context.getPath(), "Illegal value.")) {
                this.type = newType;
                context.getCursor().pop();
                this.validate(context);
                return;
            }
            throw new XmlException(problem);
        }
        context.getCursor().pop();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("<" + this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + ":" + this.getPType() + " name=\"" + this.name + "\" type=\"");
        if (this.type.getSchema() != this.schema) {
            s.append(this.schema.getPrefixForNamespace(this.type.getSchema().getNamespace()) + ":");
        }
        s.append(this.type.getName() + "\"");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            s.append(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
        }
        s.append("/>");
        return s.toString();
    }

    @Override
    public Particle.ParticleType getPType() {
        return Particle.ParticleType.ATTRIBUTE;
    }
}

