/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.particles;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Particle;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.impl.wadl.inference.schema.types.TypeReferenceType;
import com.eviware.soapui.inferredSchema.ElementParticleConfig;
import com.eviware.soapui.inferredSchema.MapEntryConfig;
import com.eviware.soapui.inferredSchema.TypeConfig;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;

public class ElementParticle
implements Particle {
    private String name;
    private Schema schema;
    private Type type;
    private Map<String, String> attributes;

    public ElementParticle(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
        this.type = Type.Factory.newType(schema);
        this.attributes = new HashMap<String, String>();
    }

    public ElementParticle(ElementParticleConfig xml, Schema schema) {
        this.schema = schema;
        this.name = xml.getName();
        this.type = Type.Factory.parse(xml.getType(), schema);
        this.attributes = new HashMap<String, String>();
        for (MapEntryConfig entry : xml.getAttributeList()) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ElementParticleConfig save() {
        ElementParticleConfig xml = ElementParticleConfig.Factory.newInstance();
        xml.setName(this.name);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            MapEntryConfig mapEntry = xml.addNewAttribute();
            mapEntry.setKey(entry.getKey());
            mapEntry.setValue(entry.getValue());
        }
        TypeConfig xml2 = this.type.save();
        xml.setType(xml2);
        return xml;
    }

    @Override
    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        if ((key.equals("minOccurs") || key.equals("maxOccurs")) && value == null) {
            value = "1";
        }
        return value;
    }

    @Override
    public QName getName() {
        return new QName(this.schema.getNamespace(), this.name);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void validate(Context context) throws XmlException {
        Type newType;
        context.cd(this.name);
        context.getCursor().push();
        String nil = context.getCursor().getAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil"));
        if (nil != null && nil.equals("true")) {
            if (this.getAttribute("nillable") == null || !this.getAttribute("nillable").equals("true")) {
                if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.ELEMENT, this.getName(), context.getPath(), "Non-nillable element is nil.")) {
                    this.setAttribute("nillable", "true");
                } else {
                    throw new XmlException("Non-nillable element is nil!");
                }
            }
            context.putAttribute("nil", "true");
        }
        if ((newType = this.type.validate(context)) != this.type) {
            String problem = "Illegal content for element '" + this.name + "' with type '" + this.type.getName() + "'.";
            if (this.type instanceof TypeReferenceType || context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.ELEMENT, this.getName(), context.getPath(), "Illegal content.")) {
                this.type = newType;
                context.getCursor().pop();
                context.up();
                this.validate(context);
                return;
            }
            throw new XmlException(problem);
        }
        context.clearAttribute("nil");
        context.up();
        context.getCursor().pop();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("<" + this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + ":" + this.getPType() + " name=\"" + this.name + "\" type=\"");
        if (this.type.getSchema() != this.schema) {
            s.append(this.schema.getPrefixForNamespace(this.type.getSchema().getNamespace()) + ":");
        }
        s.append(this.type.getName() + "\"");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            s.append(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
        }
        s.append("/>");
        return s.toString();
    }

    @Override
    public Particle.ParticleType getPType() {
        return Particle.ParticleType.ELEMENT;
    }
}

