/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.config.WsdlRequestConfig;
import com.eviware.soapui.config.WsrmVersionTypeConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlAttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportRegistry;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.support.jms.header.JMSHeaderConfig;
import com.eviware.soapui.impl.wsdl.support.jms.property.JMSPropertiesConfig;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaConfig;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaContainer;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmConfig;
import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmContainer;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WsdlRequest
extends AbstractHttpRequest<WsdlRequestConfig>
implements WsdlAttachmentContainer,
PropertyExpansionContainer,
WsaContainer,
WsrmContainer,
PropertyChangeListener {
    public static final Logger log = LogManager.getLogger(WsdlRequest.class);
    public static final String RESPONSE_CONTENT_PROPERTY = WsdlRequest.class.getName() + "@response-content";
    public static final String INLINE_RESPONSE_ATTACHMENTS = WsdlRequest.class.getName() + "@inline-response-attachments";
    public static final String EXPAND_MTOM_RESPONSE_ATTACHMENTS = WsdlRequest.class.getName() + "@expand-mtom-attachments";
    public static final String FORCE_MTOM = WsdlRequest.class.getName() + "@force_mtom";
    public static final String ENABLE_INLINE_FILES = WsdlRequest.class.getName() + "@enable_inline_files";
    public static final String SKIP_SOAP_ACTION = WsdlRequest.class.getName() + "@skip_soap_action";
    public static final String ENCODE_ATTACHMENTS = WsdlRequest.class.getName() + "@encode_attachments";
    public static final String WSS_TIMETOLIVE = WsdlRequest.class.getName() + "@wss-time-to-live";
    public static final String OPERATION_PROPERTY = WsdlRequest.class.getName() + "@operation";
    public static final String INCOMING_WSS = WsdlRequest.class.getName() + "@incoming-wss";
    public static final String OUGOING_WSS = WsdlRequest.class.getName() + "@outgoing-wss";
    public static final String PW_TYPE_NONE = "None";
    public static final String PW_TYPE_DIGEST = "PasswordDigest";
    public static final String PW_TYPE_TEXT = "PasswordText";
    private WsdlOperation operation;
    private List<HttpAttachmentPart> definedAttachmentParts;
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private WsaConfig wsaConfig;
    private WsrmConfig wsrmConfig;
    private JMSHeaderConfig jmsHeaderConfig;
    private JMSPropertiesConfig jmsPropertyConfig;

    public WsdlRequest(WsdlOperation operation, WsdlRequestConfig callConfig) {
        this(operation, callConfig, false);
    }

    public WsdlRequest(WsdlOperation operation, WsdlRequestConfig callConfig, boolean forLoadTest) {
        super(callConfig, operation, null, forLoadTest);
        this.operation = operation;
        this.initEndpoints();
        if (callConfig.getEncoding() == null || callConfig.getEncoding().length() == 0) {
            callConfig.setEncoding("UTF-8");
        }
        if (!forLoadTest) {
            operation.getInterface().addPropertyChangeListener(this.interfaceListener);
            operation.getInterface().addInterfaceListener(this.interfaceListener);
        }
    }

    public void updateConfig(WsdlRequestConfig request) {
        this.setConfig(request);
        if (this.wsaConfig != null) {
            this.wsaConfig.setConfig(request.getWsaConfig());
        }
        if (this.wsrmConfig != null) {
            this.wsrmConfig.setWsrmConfig(request.getWsrmConfig());
        }
        if (this.jmsHeaderConfig != null) {
            this.jmsHeaderConfig.setJMSHeaderConfConfig(request.getJmsConfig());
        }
        if (this.jmsPropertyConfig != null) {
            this.jmsPropertyConfig.setJmsPropertyConfConfig(request.getJmsPropertyConfig());
        }
    }

    protected void initEndpoints() {
        String[] endpoints;
        if (this.getEndpoint() == null && (endpoints = this.operation.getInterface().getEndpoints()).length > 0) {
            this.setEndpoint(endpoints[0]);
        }
    }

    public boolean isInlineResponseAttachments() {
        return this.getSettings().getBoolean(INLINE_RESPONSE_ATTACHMENTS);
    }

    public void setInlineResponseAttachments(boolean inlineResponseAttachments) {
        boolean old = this.getSettings().getBoolean(INLINE_RESPONSE_ATTACHMENTS);
        this.getSettings().setBoolean(INLINE_RESPONSE_ATTACHMENTS, inlineResponseAttachments);
        this.notifyPropertyChanged(INLINE_RESPONSE_ATTACHMENTS, old, inlineResponseAttachments);
    }

    public boolean isExpandMtomResponseAttachments() {
        return this.getSettings().getBoolean(EXPAND_MTOM_RESPONSE_ATTACHMENTS);
    }

    public void setExpandMtomResponseAttachments(boolean expandMtomResponseAttachments) {
        boolean old = this.getSettings().getBoolean(EXPAND_MTOM_RESPONSE_ATTACHMENTS);
        this.getSettings().setBoolean(EXPAND_MTOM_RESPONSE_ATTACHMENTS, expandMtomResponseAttachments);
        this.notifyPropertyChanged(EXPAND_MTOM_RESPONSE_ATTACHMENTS, old, expandMtomResponseAttachments);
    }

    @Deprecated
    public String getResponseContent() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    @Override
    public WsdlResponse getResponse() {
        return (WsdlResponse)super.getResponse();
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(WsdlOperation wsdlOperation) {
        WsdlOperation oldOperation = this.operation;
        this.operation = wsdlOperation;
        this.definedAttachmentParts = null;
        this.notifyPropertyChanged(OPERATION_PROPERTY, oldOperation, this.operation);
    }

    @Override
    public void setRequestContent(String request) {
        this.definedAttachmentParts = null;
        super.setRequestContent(request);
    }

    @Override
    public WsdlSubmit<WsdlRequest> submit(SubmitContext submitContext, boolean async) throws Request.SubmitException {
        String endpoint = PropertyExpander.expandProperties(submitContext, this.getEndpoint());
        if (endpoint == null || endpoint.trim().length() == 0) {
            UISupport.showErrorMessage("Missing endpoint for request [" + this.getName() + "]");
            return null;
        }
        try {
            WsdlSubmit<WsdlRequest> submitter = new WsdlSubmit<WsdlRequest>(this, this.getSubmitListeners(), RequestTransportRegistry.getTransport(endpoint, submitContext));
            submitter.submitRequest(submitContext, async);
            return submitter;
        }
        catch (Exception e) {
            throw new Request.SubmitException(e.toString());
        }
    }

    public String getWssPasswordType() {
        String wssPasswordType = ((WsdlRequestConfig)this.getConfig()).getWssPasswordType();
        return StringUtils.isNullOrEmpty(wssPasswordType) || PW_TYPE_NONE.equals(wssPasswordType) ? null : wssPasswordType;
    }

    public void setWssPasswordType(String wssPasswordType) {
        if (wssPasswordType == null || wssPasswordType.equals(PW_TYPE_NONE)) {
            if (((WsdlRequestConfig)this.getConfig()).isSetWssPasswordType()) {
                ((WsdlRequestConfig)this.getConfig()).unsetWssPasswordType();
            }
        } else {
            ((WsdlRequestConfig)this.getConfig()).setWssPasswordType(wssPasswordType);
        }
    }

    public synchronized HttpAttachmentPart[] getDefinedAttachmentParts() {
        if (this.definedAttachmentParts == null) {
            try {
                UISupport.setHourglassCursor();
                this.definedAttachmentParts = AttachmentUtils.extractAttachmentParts(this.operation, this.getRequestContent(), true, false, this.isMtomEnabled());
            }
            catch (Exception e) {
                log.warn(e.toString());
                this.definedAttachmentParts = new ArrayList<HttpAttachmentPart>();
            }
            finally {
                UISupport.resetCursor();
            }
        }
        return this.definedAttachmentParts.toArray(new HttpAttachmentPart[this.definedAttachmentParts.size()]);
    }

    @Override
    public RestRequestInterface.HttpMethod getMethod() {
        return RestRequestInterface.HttpMethod.POST;
    }

    @Override
    public HttpAttachmentPart getAttachmentPart(String partName) {
        HttpAttachmentPart[] parts;
        for (HttpAttachmentPart part : parts = this.getDefinedAttachmentParts()) {
            if (!part.getName().equals(partName)) continue;
            return part;
        }
        return null;
    }

    public void copyTo(WsdlRequest newRequest, boolean copyAttachments, boolean copyHeaders) {
        newRequest.setEncoding(this.getEncoding());
        newRequest.setEndpoint(this.getEndpoint());
        newRequest.setRequestContent(this.getRequestContent());
        newRequest.setWssPasswordType(this.getWssPasswordType());
        CredentialsConfig credentials = ((WsdlRequestConfig)this.getConfig()).getCredentials();
        if (credentials != null) {
            ((WsdlRequestConfig)newRequest.getConfig()).setCredentials((CredentialsConfig)credentials.copy());
        }
        if (copyAttachments) {
            this.copyAttachmentsTo(newRequest);
        }
        if (copyHeaders) {
            newRequest.setRequestHeaders(this.getRequestHeaders());
        }
    }

    @Override
    public boolean isMtomEnabled() {
        return this.getSettings().getBoolean(WsdlSettings.ENABLE_MTOM);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.getSettings().setBoolean(WsdlSettings.ENABLE_MTOM, mtomEnabled);
        this.definedAttachmentParts = null;
    }

    @Override
    public boolean isInlineFilesEnabled() {
        return this.getSettings().getBoolean(ENABLE_INLINE_FILES);
    }

    public void setInlineFilesEnabled(boolean inlineFilesEnabled) {
        this.getSettings().setBoolean(ENABLE_INLINE_FILES, inlineFilesEnabled);
    }

    public boolean isSkipSoapAction() {
        return this.getSettings().getBoolean(SKIP_SOAP_ACTION);
    }

    public void setSkipSoapAction(boolean skipSoapAction) {
        this.getSettings().setBoolean(SKIP_SOAP_ACTION, skipSoapAction);
    }

    @Override
    public void release() {
        super.release();
        this.getOperation().getInterface().removeInterfaceListener(this.interfaceListener);
        this.getOperation().getInterface().removePropertyChangeListener(this.interfaceListener);
    }

    @Override
    public MessagePart[] getRequestParts() {
        try {
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            result.addAll(Arrays.asList(this.getOperation().getDefaultRequestParts()));
            result.addAll(Arrays.asList(this.getDefinedAttachmentParts()));
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    @Override
    public MessagePart[] getResponseParts() {
        try {
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            result.addAll(Arrays.asList(this.getOperation().getDefaultResponseParts()));
            if (this.getResponse() != null) {
                result.addAll(AttachmentUtils.extractAttachmentParts(this.getOperation(), this.getResponse().getContentAsString(), true, true, this.isMtomEnabled()));
            }
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    public String getWssTimeToLive() {
        return this.getSettings().getString(WSS_TIMETOLIVE, null);
    }

    public void setWssTimeToLive(String ttl) {
        this.getSettings().setString(WSS_TIMETOLIVE, ttl);
    }

    public long getContentLength() {
        return this.getRequestContent().length();
    }

    public boolean isForceMtom() {
        return this.getSettings().getBoolean(FORCE_MTOM);
    }

    public void setForceMtom(boolean forceMtom) {
        boolean old = this.getSettings().getBoolean(FORCE_MTOM);
        this.getSettings().setBoolean(FORCE_MTOM, forceMtom);
        this.notifyPropertyChanged(FORCE_MTOM, old, forceMtom);
    }

    @Override
    public boolean isEncodeAttachments() {
        return this.getSettings().getBoolean(ENCODE_ATTACHMENTS);
    }

    public void setEncodeAttachments(boolean encodeAttachments) {
        boolean old = this.getSettings().getBoolean(ENCODE_ATTACHMENTS);
        this.getSettings().setBoolean(ENCODE_ATTACHMENTS, encodeAttachments);
        this.notifyPropertyChanged(ENCODE_ATTACHMENTS, old, encodeAttachments);
    }

    public String getIncomingWss() {
        return ((WsdlRequestConfig)this.getConfig()).getIncomingWss();
    }

    public void setIncomingWss(String incomingWss) {
        String old = this.getIncomingWss();
        ((WsdlRequestConfig)this.getConfig()).setIncomingWss(incomingWss);
        this.notifyPropertyChanged(INCOMING_WSS, old, incomingWss);
    }

    public String getOutgoingWss() {
        return ((WsdlRequestConfig)this.getConfig()).getOutgoingWss();
    }

    public void setOutgoingWss(String outgoingWss) {
        String old = this.getOutgoingWss();
        ((WsdlRequestConfig)this.getConfig()).setOutgoingWss(outgoingWss);
        this.notifyPropertyChanged(OUGOING_WSS, old, outgoingWss);
    }

    public boolean isWsAddressing() {
        return ((WsdlRequestConfig)this.getConfig()).getUseWsAddressing();
    }

    public void setWsAddressing(boolean wsAddressing) {
        boolean old = ((WsdlRequestConfig)this.getConfig()).getUseWsAddressing();
        ((WsdlRequestConfig)this.getConfig()).setUseWsAddressing(wsAddressing);
        this.notifyPropertyChanged("wsAddressing", old, wsAddressing);
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this);
        result.addAll(super.getPropertyExpansions());
        StringToStringsMap requestHeaders = this.getRequestHeaders();
        for (Map.Entry headerEntry : requestHeaders.entrySet()) {
            for (String value : (List)headerEntry.getValue()) {
                result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, new HttpTestRequestStep.RequestHeaderHolder((String)headerEntry.getKey(), value, this), "value"));
            }
        }
        this.addWsaPropertyExpansions(result, this.getWsaConfig(), this);
        this.addJMSHeaderExpansions(result, this.getJMSHeaderConfig(), this);
        return result.toArray();
    }

    public void addWsaPropertyExpansions(PropertyExpansionsResult result, WsaConfig wsaConfig, ModelItem modelItem) {
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "action"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "from"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "to"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "replyTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "replyToRefParams"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "faultTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "faultToRefParams"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "relatesTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "relationshipType"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "messageID"));
    }

    public void addJMSHeaderExpansions(PropertyExpansionsResult result, JMSHeaderConfig jmsHeaderConfig, ModelItem modelItem) {
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSCorrelationID"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSReplyTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSType"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "JMSPriority"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "durableSubscriptionName"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "clientID"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "sendAsBytesMessage"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, jmsHeaderConfig, "soapActionAdd"));
    }

    @Override
    public Attachment.AttachmentEncoding getAttachmentEncoding(String partName) {
        HttpAttachmentPart attachmentPart = this.getAttachmentPart(partName);
        if (attachmentPart == null) {
            return AttachmentUtils.getAttachmentEncoding(this.getOperation(), partName, false);
        }
        return AttachmentUtils.getAttachmentEncoding(this.getOperation(), attachmentPart, false);
    }

    @Override
    public WsaConfig getWsaConfig() {
        if (this.wsaConfig == null) {
            if (!((WsdlRequestConfig)this.getConfig()).isSetWsaConfig()) {
                ((WsdlRequestConfig)this.getConfig()).addNewWsaConfig();
            }
            this.wsaConfig = new WsaConfig(((WsdlRequestConfig)this.getConfig()).getWsaConfig(), this);
        }
        return this.wsaConfig;
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public boolean isWsaEnabled() {
        return this.isWsAddressing();
    }

    @Override
    public void setWsaEnabled(boolean arg0) {
        this.setWsAddressing(arg0);
    }

    public boolean isWsReliableMessaging() {
        return ((WsdlRequestConfig)this.getConfig()).getUseWsReliableMessaging();
    }

    public void setWsReliableMessaging(boolean wsReliableMessaging) {
        boolean old = ((WsdlRequestConfig)this.getConfig()).getUseWsReliableMessaging();
        ((WsdlRequestConfig)this.getConfig()).setUseWsReliableMessaging(wsReliableMessaging);
        this.notifyPropertyChanged("wsReliableMessaging", old, wsReliableMessaging);
    }

    @Override
    public WsrmConfig getWsrmConfig() {
        if (this.wsrmConfig == null) {
            if (!((WsdlRequestConfig)this.getConfig()).isSetWsrmConfig()) {
                ((WsdlRequestConfig)this.getConfig()).addNewWsrmConfig();
            }
            this.wsrmConfig = new WsrmConfig(((WsdlRequestConfig)this.getConfig()).getWsrmConfig(), this);
            this.wsrmConfig.addPropertyChangeListener("version", this);
        }
        return this.wsrmConfig;
    }

    @Override
    public boolean isWsrmEnabled() {
        return this.isWsReliableMessaging();
    }

    @Override
    public void setWsrmEnabled(boolean arg0) {
        this.setWsReliableMessaging(arg0);
    }

    public String getResponseContentAsXml() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    @Override
    public JMSHeaderConfig getJMSHeaderConfig() {
        if (this.jmsHeaderConfig == null) {
            if (!((WsdlRequestConfig)this.getConfig()).isSetJmsConfig()) {
                ((WsdlRequestConfig)this.getConfig()).addNewJmsConfig();
            }
            this.jmsHeaderConfig = new JMSHeaderConfig(((WsdlRequestConfig)this.getConfig()).getJmsConfig(), this);
        }
        return this.jmsHeaderConfig;
    }

    @Override
    public JMSPropertiesConfig getJMSPropertiesConfig() {
        if (this.jmsPropertyConfig == null) {
            if (!((WsdlRequestConfig)this.getConfig()).isSetJmsPropertyConfig()) {
                ((WsdlRequestConfig)this.getConfig()).addNewJmsPropertyConfig();
            }
            this.jmsPropertyConfig = new JMSPropertiesConfig(((WsdlRequestConfig)this.getConfig()).getJmsPropertyConfig(), this);
        }
        return this.jmsPropertyConfig;
    }

    public String getAction() {
        if (this.isWsaEnabled() && StringUtils.hasContent(this.getWsaConfig().getAction())) {
            return this.getWsaConfig().getAction();
        }
        return this.getOperation().getAction();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.wsrmConfig && evt.getPropertyName().equals("version") && evt.getNewValue().equals(WsrmVersionTypeConfig.X_1_0.toString())) {
            this.getWsaConfig().setVersion(WsaVersionTypeConfig.X_200408.toString());
        }
    }

    private class InternalInterfaceListener
    extends InterfaceListenerAdapter
    implements PropertyChangeListener {
        private InternalInterfaceListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(Interface.ENDPOINT_PROPERTY)) {
                String endpoint = WsdlRequest.this.getEndpoint();
                if (evt.getOldValue() != null && evt.getOldValue().equals(endpoint)) {
                    WsdlRequest.this.setEndpoint((String)evt.getNewValue());
                }
            }
        }
    }
}

