/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.HermesUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import hermes.Domain;
import hermes.Hermes;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class AddJMSEndpointAction
extends AbstractSoapUIAction<AbstractInterface<?>> {
    public static final String SOAPUI_ACTION_ID = "AddJMSEndpointAction";
    private static final String HERMES_IMPL_CLASS_NAME = "hermes.impl.DefaultHermesImpl";
    private static final String DESTINATION_CONFIG_CLASS_NAME = "hermes.config.DestinationConfig";
    private static final String SESSION = "Session";
    private static final String HERMES_CONFIG = "Hermes Config";
    private static final String SEND = "Send/Publish destination";
    private static final String RECEIVE = "Receive/Subscribe destination";
    private XForm mainForm;
    List<Destination> destinationNameList;

    public AddJMSEndpointAction() {
        super("Add JMS endpoint", "Wizard for creating JMS endpoint");
    }

    @Override
    public void perform(AbstractInterface<?> iface, Object param) {
        XFormDialog dialog = this.buildDialog(iface);
        this.initValues(iface);
        if (dialog.show()) {
            String session = dialog.getValue(SESSION);
            int i = dialog.getValueIndex(SEND);
            if (i == -1) {
                UISupport.showErrorMessage("Not supported endpoint");
                return;
            }
            String send = this.destinationNameList.get(i).getDestinationName();
            int j = dialog.getValueIndex(RECEIVE);
            if (j == -1) {
                UISupport.showErrorMessage("Not supported endpoint");
                return;
            }
            String receive = this.destinationNameList.get(j).getDestinationName();
            if ("-".equals(send) && "-".equals(receive)) {
                UISupport.showErrorMessage("Not supported endpoint");
                return;
            }
            iface.addEndpoint(this.createEndpointString(session, send, receive));
        }
    }

    private String createEndpointString(String session, String send, String receive) {
        StringBuilder sb = new StringBuilder("jms://");
        sb.append(session + "::");
        sb.append(send);
        if (!"-".equals(receive)) {
            sb.append("::" + receive);
        }
        return sb.toString();
    }

    private String[] getSessionOptions(AbstractInterface<?> iface, String hermesConfigPath) {
        ArrayList<Hermes> hermesList = new ArrayList<Hermes>();
        try {
            Context ctx = this.getHermesContext(iface, hermesConfigPath);
            if (ctx != null) {
                NamingEnumeration<NameClassPair> sessions = ctx.list("");
                while (sessions.hasMore()) {
                    NameClassPair pair = sessions.next();
                    if (!pair.getClassName().equals(HERMES_IMPL_CLASS_NAME)) continue;
                    hermesList.add((Hermes)ctx.lookup(pair.getName()));
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
            SoapUI.log.warn("no HermesJMS context!");
        }
        ArrayList<String> hermesSessionList = new ArrayList<String>();
        for (Hermes h : hermesList) {
            if (h.getSessionConfig().getId().equals("<new>")) continue;
            hermesSessionList.add(h.getSessionConfig().getId());
        }
        return hermesSessionList.toArray(new String[hermesSessionList.size()]);
    }

    private void initValues(AbstractInterface<?> iface) {
        String hermesConfigPath = PropertyExpander.expandProperties(iface, iface.getProject().getHermesConfig());
        this.mainForm.getComponent(HERMES_CONFIG).setValue(hermesConfigPath);
        Object[] sessionOptions = this.getSessionOptions(iface, hermesConfigPath);
        this.mainForm.setOptions(SESSION, sessionOptions);
        Context ctx = null;
        try {
            ctx = this.getHermesContext(iface, hermesConfigPath);
        }
        catch (Exception e) {
            SoapUI.log.info("no hermes context");
        }
        Hermes hermes = null;
        try {
            if (sessionOptions != null && sessionOptions.length > 0) {
                hermes = (Hermes)ctx.lookup((String)sessionOptions[0]);
            }
            if (hermes != null) {
                this.updateDestinations(hermes);
            }
        }
        catch (NamingException e) {
            SoapUI.logError(e);
        }
    }

    private void updateDestinations(Hermes hermes) {
        this.destinationNameList = new ArrayList<Destination>();
        this.destinationNameList.add(new Destination("-", Domain.UNKNOWN));
        this.extractDestinations(hermes, this.destinationNameList);
        this.mainForm.setOptions(SEND, this.destinationNameList.toArray());
        this.mainForm.setOptions(RECEIVE, this.destinationNameList.toArray());
    }

    private Context getHermesContext(AbstractInterface<?> iface, String hermesConfigPath) throws MalformedURLException, NamingException, IOException {
        WsdlProject project = iface.getProject();
        HermesUtils.flushHermesCache();
        Context ctx = HermesUtils.hermesContext(project, hermesConfigPath);
        return ctx;
    }

    protected XFormDialog buildDialog(final AbstractInterface<?> iface) {
        if (iface == null) {
            return null;
        }
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Add JMS endpoint");
        this.mainForm = builder.createForm("Basic");
        this.mainForm.addTextField(HERMES_CONFIG, "choose folder where hermes-config.xml is", XForm.FieldType.FOLDER).addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                if (!"".equals(newValue)) {
                    Hermes hermes = null;
                    try {
                        Context ctx = AddJMSEndpointAction.this.getHermesContext(iface, newValue);
                        iface.getProject().setHermesConfig(newValue);
                        Object[] sessions = AddJMSEndpointAction.this.getSessionOptions(iface, newValue);
                        AddJMSEndpointAction.this.mainForm.setOptions(AddJMSEndpointAction.SESSION, sessions);
                        if (sessions != null && sessions.length > 0) {
                            hermes = (Hermes)ctx.lookup((String)sessions[0]);
                        }
                    }
                    catch (Exception e) {
                        SoapUI.logError(e);
                    }
                    if (hermes != null) {
                        AddJMSEndpointAction.this.updateDestinations(hermes);
                    } else {
                        AddJMSEndpointAction.this.mainForm.setOptions(AddJMSEndpointAction.SESSION, new String[0]);
                        AddJMSEndpointAction.this.mainForm.setOptions(AddJMSEndpointAction.SEND, new String[0]);
                        AddJMSEndpointAction.this.mainForm.setOptions(AddJMSEndpointAction.RECEIVE, new String[0]);
                    }
                }
            }
        });
        this.mainForm.addComboBox(SESSION, new String[0], "Session name from HermesJMS").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                String hermesConfigPath = AddJMSEndpointAction.this.mainForm.getComponent(AddJMSEndpointAction.HERMES_CONFIG).getValue();
                Hermes hermes = null;
                try {
                    Context ctx = AddJMSEndpointAction.this.getHermesContext(iface, hermesConfigPath);
                    hermes = (Hermes)ctx.lookup(newValue);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
                if (hermes != null) {
                    AddJMSEndpointAction.this.updateDestinations(hermes);
                } else {
                    AddJMSEndpointAction.this.mainForm.setOptions(AddJMSEndpointAction.SEND, new String[0]);
                    AddJMSEndpointAction.this.mainForm.setOptions(AddJMSEndpointAction.RECEIVE, new String[0]);
                }
            }
        });
        this.mainForm.addComboBox(SEND, new String[0], "Queue/Topic  sending/publishing");
        this.mainForm.addComboBox(RECEIVE, new String[0], "Queue/Topic  receive/subscribe");
        return builder.buildDialog(builder.buildOkCancelActions(), "create JMS endpoint by selecting proper values", null);
    }

    private void extractDestinations(Hermes hermes, List<Destination> destinationList) {
        try {
            ClassLoader hermesClassLoader = HermesUtils.getHermesClassLoader();
            Class<?> cl = hermesClassLoader.loadClass(DESTINATION_CONFIG_CLASS_NAME);
            if (cl != null) {
                Iterator hermesDestinations = hermes.getDestinations();
                while (hermesDestinations.hasNext()) {
                    Object dest = hermesDestinations.next();
                    Field nameField = cl.getDeclaredField("name");
                    nameField.setAccessible(true);
                    String name = (String)nameField.get(dest);
                    Field domainField = cl.getDeclaredField("domain");
                    domainField.setAccessible(true);
                    Integer domain = (Integer)domainField.get(dest);
                    Destination temp = new Destination(name, Domain.getDomain((int)domain));
                    destinationList.add(temp);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private class Destination {
        private String destinationName;
        private Domain domain;

        public Destination(String destinationName, Domain domain) {
            this.domain = domain;
            this.destinationName = destinationName.equals("-") || destinationName.equals("") ? destinationName : (domain.equals((Object)Domain.QUEUE) ? "queue_" + destinationName : "topic_" + destinationName);
        }

        public String getDestinationName() {
            return this.destinationName;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public String toString() {
            return this.getDestinationName().replace("queue_", "").replace("topic_", "");
        }
    }
}

