/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ShowConfigFileAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.XFormTextField;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.jbosswsTools.ConfigurationDocument;
import org.jboss.jbosswsTools.ConfigurationType;
import org.jboss.jbosswsTools.GlobalType;
import org.jboss.jbosswsTools.PkgNSType;
import org.jboss.jbosswsTools.WsdlToJavaType;
import org.jboss.jbosswsTools.WsxmlType;
import org.w3c.dom.Element;

public class WSToolsWsdl2JavaAction
extends AbstractToolsAction<Interface> {
    public static final String SOAPUI_ACTION_ID = "WSToolsWsdl2JavaAction";
    private static final String NAMESPACE_MAPPING = "Namespace mapping";
    private static final String OUTPUT = "Output Directory";
    private static final String MAPPING = "Mapping file";
    private static final String UNWRAP = "Unwrap";
    private static final String APPEND = "Append";
    private static final String SERVLET_LINK = "Servlet Link";
    private static final String EJB_LINK = "EJB Link";
    private XFormTextField ejbLinkField;
    private XFormTextField servletLinkField;
    private XFormField appendField;

    public WSToolsWsdl2JavaAction() {
        super("JBossWS Artifacts", "Generates JBossWS artifacts using the jboss wstools utility");
    }

    @Override
    public boolean applies(Interface target) {
        Interface iface = target;
        return !iface.getProject().hasNature("com.eviware.soapui.jbosside.jbosswsNature");
    }

    @Override
    protected StringToStringMap initValues(Interface modelItem, Object param) {
        boolean hasServletLink;
        StringToStringMap values = super.initValues(modelItem, param);
        boolean hasEjbLink = values.get(EJB_LINK, "").length() > 0;
        boolean bl = hasServletLink = values.get(SERVLET_LINK, "").length() > 0;
        if (!hasEjbLink && !hasServletLink) {
            this.ejbLinkField.setEnabled(true);
            this.servletLinkField.setEnabled(true);
        } else {
            this.ejbLinkField.setEnabled(hasEjbLink && !hasServletLink);
            this.servletLinkField.setEnabled(hasServletLink && !hasEjbLink);
            if (hasEjbLink && hasServletLink) {
                values.put(SERVLET_LINK, "");
            }
        }
        this.appendField.setEnabled(hasEjbLink || hasServletLink);
        return values;
    }

    @Override
    protected XFormDialog buildDialog(Interface modelItem) {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("JBossWS Artifacts");
        XForm mainForm = builder.createForm("Basic");
        this.addWSDLFields(mainForm, modelItem);
        mainForm.addTextField(OUTPUT, "The root directory for all emitted files.", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(MAPPING, "mapping file to generate", XForm.FieldType.PROJECT_FILE);
        mainForm.addCheckBox(UNWRAP, "unwrap doc-literal operations");
        mainForm.addNameSpaceTable(NAMESPACE_MAPPING, modelItem);
        mainForm.addSeparator("webservices.xml generation options");
        this.ejbLinkField = mainForm.addTextField(EJB_LINK, "The ejb-jar.xml ejb-link for Stateless Session Bean endpoints", XForm.FieldType.TEXT);
        this.ejbLinkField.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                WSToolsWsdl2JavaAction.this.servletLinkField.setEnabled(newValue.length() == 0);
                WSToolsWsdl2JavaAction.this.appendField.setEnabled(newValue.length() > 0);
            }
        });
        this.servletLinkField = mainForm.addTextField(SERVLET_LINK, "The web.xml servlet-link that is used by Java Service Endpoints (WAR)", XForm.FieldType.TEXT);
        this.servletLinkField.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                WSToolsWsdl2JavaAction.this.ejbLinkField.setEnabled(newValue.length() == 0);
                WSToolsWsdl2JavaAction.this.appendField.setEnabled(newValue.length() > 0);
            }
        });
        this.appendField = mainForm.addCheckBox(APPEND, "append to existing file");
        this.appendField.setEnabled(false);
        this.buildArgsForm(builder, false, "wstools");
        ActionList actions = this.buildDefaultActions("http://jbossas.jboss.org/docs", modelItem);
        actions.addAction(new JBossWSShowConfigFileAction("JBossWS Wsdl2Java", "Contents of generated wsconfig.xml file", modelItem));
        return builder.buildDialog(actions, "Specify arguments for JBossWS wstools wsdl2java functionality", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, Interface modelItem) throws Exception {
        String wstoolsDir = SoapUI.getSettings().getString(ToolsSettings.JBOSSWS_WSTOOLS_LOCATION, null);
        if (Tools.isEmpty(wstoolsDir)) {
            UISupport.showErrorMessage("wstools directory must be set in global preferences");
            return;
        }
        String wsToolsExtension = UISupport.isWindows() ? ".bat" : ".sh";
        File wstoolsFile = new File(wstoolsDir + File.separatorChar + "wstools" + wsToolsExtension);
        if (!wstoolsFile.exists()) {
            UISupport.showErrorMessage("Could not find wstools script at [" + wstoolsFile + "]");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(values, UISupport.isWindows(), modelItem);
        builder.command(args.getArgs());
        builder.directory(new File(wstoolsDir));
        toolHost.run(new ProcessToolRunner(builder, "JBossWS wstools", (ModelItem)modelItem, args));
        Analytics.trackAction(SoapUIActions.USE_JBOSSWS_ARTIFACTS_TOOL);
    }

    private ArgumentBuilder buildArgs(StringToStringMap values, boolean isWindows, Interface modelItem) throws IOException {
        values.put(OUTPUT, Tools.ensureDir((String)values.get(OUTPUT), ""));
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript("wstools");
        builder.addArgs("-config", this.buildConfigFile(values, modelItem));
        builder.addString(OUTPUT, "-dest");
        this.addToolArgs(values, builder);
        return builder;
    }

    private String buildConfigFile(StringToStringMap values, Interface modelItem) throws IOException {
        File file = File.createTempFile("wstools-config", ".xml");
        ConfigurationDocument configDocument = this.createConfigFile(values, modelItem);
        configDocument.save(file);
        return file.getAbsolutePath();
    }

    private ConfigurationDocument createConfigFile(StringToStringMap values, Interface modelItem) {
        WsxmlType webservices;
        ConfigurationDocument configDocument = ConfigurationDocument.Factory.newInstance();
        ConfigurationType config = configDocument.addNewConfiguration();
        try {
            StringToStringMap nsMappings = StringToStringMap.fromXml((String)values.get(NAMESPACE_MAPPING));
            if (!nsMappings.isEmpty()) {
                GlobalType global = config.addNewGlobal();
                for (Map.Entry namespaceEntry : nsMappings.entrySet()) {
                    PkgNSType entry = global.addNewPackageNamespace();
                    entry.setNamespace((String)namespaceEntry.getKey());
                    entry.setPackage((String)namespaceEntry.getValue());
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        WsdlToJavaType wsdl2Java = config.addNewWsdlJava();
        String wsdlUrl = this.getWsdlUrl(values, modelItem);
        try {
            new URL(wsdlUrl);
            wsdl2Java.setLocation(wsdlUrl);
        }
        catch (MalformedURLException e) {
            ((Element)wsdl2Java.getDomNode()).setAttribute("file", wsdlUrl);
        }
        if (values.getBoolean(UNWRAP)) {
            wsdl2Java.setParameterStyle(WsdlToJavaType.ParameterStyle.BARE);
        } else {
            wsdl2Java.setParameterStyle(WsdlToJavaType.ParameterStyle.WRAPPED);
        }
        if (values.get(EJB_LINK) != null && ((String)values.get(EJB_LINK)).length() > 0) {
            webservices = wsdl2Java.addNewWebservices();
            webservices.setEjbLink((String)values.get(EJB_LINK));
            webservices.setAppend(values.getBoolean(APPEND));
        } else if (values.get(SERVLET_LINK) != null && ((String)values.get(SERVLET_LINK)).length() > 0) {
            webservices = wsdl2Java.addNewWebservices();
            webservices.setServletLink((String)values.get(SERVLET_LINK));
            webservices.setAppend(values.getBoolean(APPEND));
        }
        String mappingFile = ((String)values.get(MAPPING)).toString().trim();
        if (mappingFile.length() > 0) {
            wsdl2Java.addNewMapping().setFile(mappingFile);
        }
        return configDocument;
    }

    private final class JBossWSShowConfigFileAction
    extends ShowConfigFileAction {
        private final Interface modelItem;

        private JBossWSShowConfigFileAction(String title, String description, Interface modelItem) {
            super(title, description);
            this.modelItem = modelItem;
        }

        @Override
        protected String getConfigFile() {
            ConfigurationDocument configDocument = WSToolsWsdl2JavaAction.this.createConfigFile(WSToolsWsdl2JavaAction.this.getDialog().getValues(), this.modelItem);
            return configDocument.toString();
        }
    }
}

