/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

public class StopMockServiceAction<MockServiceType extends MockService>
extends AbstractSoapUIAction<MockServiceType> {
    public static final String SOAPUI_ACTION_ID = "StopMockServiceAction";

    public StopMockServiceAction() {
        super("Stop", "Stops the MockService if running");
    }

    @Override
    public void perform(MockServiceType mockService, Object param) {
        try {
            MockRunner mockRunner = mockService.getMockRunner();
            if (mockRunner != null) {
                mockRunner.stop();
                this.sendAnalytic(mockService);
            }
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    private void sendAnalytic(MockServiceType mockService) {
        if (mockService != null) {
            if (mockService instanceof WsdlMockService) {
                Analytics.trackAction(SoapUIActions.STOP_SOAP_MOCK_FROM_NAVIGATOR);
            } else if (mockService instanceof RestMockService) {
                Analytics.trackAction(SoapUIActions.STOP_REST_MOCK_FROM_NAVIGATOR);
            }
        }
    }
}

