/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.impl.support.AbstractMockResponse;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlContentPart;
import com.eviware.soapui.impl.wsdl.WsdlHeaderPart;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.submit.filters.RemoveEmptyContentRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.BodyPartAttachment;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.IconAnimator;
import com.eviware.soapui.impl.wsdl.support.MockFileAttachment;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaConfig;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaContainer;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.settings.CommonSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ws.security.WSSecurityException;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;

public class WsdlMockResponse
extends AbstractMockResponse<MockResponseConfig>
implements WsaContainer {
    private static final Logger log = LogManager.getLogger(WsdlMockResponse.class);
    public static final String MOCKRESULT_PROPERTY = WsdlMockResponse.class.getName() + "@mockresult";
    public static final String HEADERS_PROPERTY = WsdlMockResponse.class.getName() + "@headers";
    public static final String DISABLE_MULTIPART_ATTACHMENTS = WsdlMockResponse.class.getName() + "@disable-multipart-attachments";
    public static final String FORCE_MTOM = WsdlMockResponse.class.getName() + "@force_mtom";
    public static final String ENABLE_INLINE_FILES = WsdlMockResponse.class.getName() + "@enable_inline_files";
    public static final String RESPONSE_DELAY_PROPERTY = WsdlMockResponse.class.getName() + "@response-delay";
    public static final String STRIP_WHITESPACES = WsdlMockResponse.class.getName() + "@strip-whitespaces";
    public static final String REMOVE_EMPTY_CONTENT = WsdlMockResponse.class.getName() + "@remove_empty_content";
    public static final String ENCODE_ATTACHMENTS = WsdlMockResponse.class.getName() + "@encode_attachments";
    public static final String OUGOING_WSS = WsdlMockResponse.class.getName() + "@outgoing-wss";
    public static final String ICON_NAME = "/mockResponse.gif";
    protected List<FileAttachment<WsdlMockResponse>> attachments = new ArrayList<FileAttachment<WsdlMockResponse>>();
    private List<HttpAttachmentPart> definedAttachmentParts;
    private IconAnimator<WsdlMockResponse> iconAnimator;
    private WsaConfig wsaConfig;

    public WsdlMockResponse(WsdlMockOperation operation, MockResponseConfig config) {
        super(config, operation, ICON_NAME);
        for (AttachmentConfig ac : ((MockResponseConfig)this.getConfig()).getAttachmentList()) {
            this.attachments.add(new MockFileAttachment(ac, this));
        }
        if (!config.isSetEncoding()) {
            config.setEncoding("UTF-8");
        }
        this.iconAnimator = new IconAnimator<WsdlMockResponse>(this, ICON_NAME, "/exec_request.png", 4);
    }

    @Override
    public void setConfig(MockResponseConfig config) {
        super.setConfig(config);
        if (this.wsaConfig != null) {
            if (config.isSetWsaConfig()) {
                this.wsaConfig.setConfig(config.getWsaConfig());
            } else {
                this.wsaConfig = null;
            }
        }
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    protected String getContentType(Operation operation, String encoding) {
        SoapVersion soapVersion = ((WsdlOperation)operation).getInterface().getSoapVersion();
        return soapVersion.getContentTypeHttpHeader(encoding, null);
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator.getIcon();
    }

    @Override
    public WsdlMockOperation getMockOperation() {
        return (WsdlMockOperation)this.getParent();
    }

    @Override
    public String getScriptHelpUrl() {
        return "/soap-mocking/mockoperations-and-responses.html";
    }

    public MessagePart[] getRequestParts() {
        try {
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            result.addAll(Arrays.asList(this.getMockOperation().getOperation().getDefaultRequestParts()));
            if (this.getMockResult() != null) {
                result.addAll(AttachmentUtils.extractAttachmentParts(this.getMockOperation().getOperation(), this.getMockResult().getMockRequest().getRequestContent(), true, false, this.isMtomEnabled()));
            }
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    public MessagePart[] getResponseParts() {
        try {
            WsdlOperation op = this.getMockOperation().getOperation();
            if (op == null || op.isUnidirectional()) {
                return new MessagePart[0];
            }
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            WsdlContext wsdlContext = op.getInterface().getWsdlContext();
            BindingOperation bindingOperation = op.findBindingOperation(wsdlContext.getDefinition());
            if (bindingOperation == null) {
                return new MessagePart[0];
            }
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            List<Object> headers = bindingOutput == null ? new ArrayList() : WsdlUtils.getSoapHeaders(bindingOutput.getExtensibilityElements());
            for (int i = 0; i < headers.size(); ++i) {
                WsdlUtils.SoapHeader header = (WsdlUtils.SoapHeader)headers.get(i);
                Message message = wsdlContext.getDefinition().getMessage(header.getMessage());
                if (message == null) {
                    log.error("Missing message for header: " + header.getMessage());
                    continue;
                }
                Part part = message.getPart(header.getPart());
                if (part != null) {
                    SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                    SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                    if (schemaType == null) continue;
                    result.add(new WsdlHeaderPart(part.getName(), schemaType, part.getElementName(), schemaElement));
                    continue;
                }
                log.error("Missing part for header; " + header.getPart());
            }
            Part[] parts = WsdlUtils.getOutputParts(bindingOperation);
            for (int i = 0; i < parts.length; ++i) {
                Part part = parts[i];
                if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) continue;
                SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                if (schemaType == null) continue;
                result.add(new WsdlContentPart(part.getName(), schemaType, part.getElementName(), schemaElement));
            }
            result.addAll(Arrays.asList(this.getDefinedAttachmentParts()));
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    @Override
    public Attachment attachFile(File file, boolean cache) throws IOException {
        MockFileAttachment fileAttachment = new MockFileAttachment(file, cache, this);
        this.attachments.add(fileAttachment);
        this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, fileAttachment);
        return fileAttachment;
    }

    @Override
    public int getAttachmentCount() {
        return this.attachments.size();
    }

    @Override
    public WsdlAttachment getAttachmentAt(int index) {
        return this.attachments.get(index);
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        int ix = this.attachments.indexOf(attachment);
        this.attachments.remove(ix);
        try {
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, attachment, null);
        }
        finally {
            ((MockResponseConfig)this.getConfig()).removeAttachment(ix);
        }
    }

    public HttpAttachmentPart[] getDefinedAttachmentParts() {
        if (this.definedAttachmentParts == null) {
            try {
                WsdlOperation operation = this.getMockOperation().getOperation();
                if (operation == null) {
                    this.definedAttachmentParts = new ArrayList<HttpAttachmentPart>();
                } else {
                    UISupport.setHourglassCursor();
                    this.definedAttachmentParts = AttachmentUtils.extractAttachmentParts(operation, this.getResponseContent(), true, true, this.isMtomEnabled());
                }
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                UISupport.resetCursor();
            }
        }
        return this.definedAttachmentParts.toArray(new HttpAttachmentPart[this.definedAttachmentParts.size()]);
    }

    @Override
    public HttpAttachmentPart getAttachmentPart(String partName) {
        HttpAttachmentPart[] parts;
        for (HttpAttachmentPart part : parts = this.getDefinedAttachmentParts()) {
            if (!part.getName().equals(partName)) continue;
            return part;
        }
        return null;
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : this.attachments) {
            if (!attachment.getPart().equals(partName)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    @Override
    public String getContentType() {
        return this.getContentType(this.getOperation(), this.getEncoding());
    }

    @Override
    public boolean isMtomEnabled() {
        return this.getSettings().getBoolean(WsdlSettings.ENABLE_MTOM);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        boolean old = this.isMtomEnabled();
        this.getSettings().setBoolean(WsdlSettings.ENABLE_MTOM, mtomEnabled);
        this.definedAttachmentParts = null;
        this.notifyPropertyChanged(MTOM_NABLED_PROPERTY, old, mtomEnabled);
    }

    @Override
    protected String executeSpecifics(MockRequest request, String responseContent, WsdlMockRunContext context) throws IOException, WSSecurityException {
        OutgoingWss outgoing;
        String outgoingWss;
        if (this.getWsaConfig().isWsaEnabled()) {
            WsdlOperation operation = this.getMockOperation().getOperation();
            WsaUtils wsaUtils = new WsaUtils(responseContent, this.getSoapVersion(), operation, context);
            responseContent = wsaUtils.addWSAddressingMockResponse(this, (WsdlMockRequest)request);
        }
        if (StringUtils.isNullOrEmpty(outgoingWss = this.getOutgoingWss())) {
            outgoingWss = this.getMockOperation().getMockService().getOutgoingWss();
        }
        if (StringUtils.hasContent(outgoingWss) && (outgoing = this.getMockOperation().getMockService().getProject().getWssContainer().getOutgoingWssByName(outgoingWss)) != null) {
            Document dom = XmlUtils.parseXml(responseContent);
            outgoing.processOutgoing(dom, context);
            StringWriter writer = new StringWriter();
            XmlUtils.serialize(dom, (Writer)writer);
            responseContent = writer.toString();
        }
        return responseContent;
    }

    public Attachment addAttachment(Attachment attachment) {
        if (attachment instanceof BodyPartAttachment) {
            try {
                BodyPartAttachment att = (BodyPartAttachment)attachment;
                AttachmentConfig newConfig = ((MockResponseConfig)this.getConfig()).addNewAttachment();
                newConfig.setData(Tools.readAll(att.getInputStream(), 0L).toByteArray());
                newConfig.setContentId(att.getContentID());
                newConfig.setContentType(att.getContentType());
                newConfig.setName(att.getName());
                MockFileAttachment newAttachment = new MockFileAttachment(newConfig, this);
                this.attachments.add(newAttachment);
                return newAttachment;
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        } else if (attachment instanceof FileAttachment) {
            AttachmentConfig oldConfig = ((FileAttachment)attachment).getConfig();
            AttachmentConfig newConfig = (AttachmentConfig)((MockResponseConfig)this.getConfig()).addNewAttachment().set(oldConfig);
            MockFileAttachment newAttachment = new MockFileAttachment(newConfig, this);
            this.attachments.add(newAttachment);
            return newAttachment;
        }
        return null;
    }

    public void setResponseDelay(long delay) {
        long oldDelay = this.getResponseDelay();
        if (delay == 0L) {
            this.getSettings().clearSetting(RESPONSE_DELAY_PROPERTY);
        } else {
            this.getSettings().setLong(RESPONSE_DELAY_PROPERTY, delay);
        }
        this.notifyPropertyChanged(RESPONSE_DELAY_PROPERTY, oldDelay, delay);
    }

    @Override
    public long getResponseDelay() {
        return this.getSettings().getLong(RESPONSE_DELAY_PROPERTY, 0L);
    }

    public long getContentLength() {
        return this.getResponseContent() == null ? 0L : (long)this.getResponseContent().length();
    }

    @Override
    public boolean isMultipartEnabled() {
        return !this.getSettings().getBoolean(DISABLE_MULTIPART_ATTACHMENTS);
    }

    public void setMultipartEnabled(boolean multipartEnabled) {
        this.getSettings().setBoolean(DISABLE_MULTIPART_ATTACHMENTS, multipartEnabled);
    }

    public void setEntitizeProperties(boolean entitizeProperties) {
        this.getSettings().setBoolean(CommonSettings.ENTITIZE_PROPERTIES, entitizeProperties);
    }

    @Override
    public boolean isForceMtom() {
        return this.getSettings().getBoolean(FORCE_MTOM);
    }

    public void setForceMtom(boolean forceMtom) {
        boolean old = this.getSettings().getBoolean(FORCE_MTOM);
        this.getSettings().setBoolean(FORCE_MTOM, forceMtom);
        this.notifyPropertyChanged(FORCE_MTOM, old, forceMtom);
    }

    @Override
    protected String removeEmptyContent(String responseContent) {
        if (this.isRemoveEmptyContent()) {
            responseContent = RemoveEmptyContentRequestFilter.removeEmptyContent(responseContent, this.getSoapVersion().getEnvelopeNamespace(), true);
        }
        return responseContent;
    }

    @Override
    public void setResponseContent(String responseContent) {
        super.setResponseContent(responseContent);
        this.handleFault(responseContent);
    }

    private void handleFault(String responseContent) {
        try {
            if (SoapUtils.isSoapFault(responseContent)) {
                this.setResponseHttpStatus(500);
            }
        }
        catch (XmlException e) {
            SoapUI.logError(e);
        }
    }

    public boolean isRemoveEmptyContent() {
        return this.getSettings().getBoolean(REMOVE_EMPTY_CONTENT);
    }

    public void setRemoveEmptyContent(boolean removeEmptyContent) {
        boolean old = this.getSettings().getBoolean(REMOVE_EMPTY_CONTENT);
        this.getSettings().setBoolean(REMOVE_EMPTY_CONTENT, removeEmptyContent);
        this.notifyPropertyChanged(REMOVE_EMPTY_CONTENT, old, removeEmptyContent);
    }

    @Override
    public boolean isEncodeAttachments() {
        return this.getSettings().getBoolean(ENCODE_ATTACHMENTS);
    }

    public void setEncodeAttachments(boolean encodeAttachments) {
        boolean old = this.getSettings().getBoolean(ENCODE_ATTACHMENTS);
        this.getSettings().setBoolean(ENCODE_ATTACHMENTS, encodeAttachments);
        this.notifyPropertyChanged(ENCODE_ATTACHMENTS, old, encodeAttachments);
    }

    @Override
    public boolean isStripWhitespaces() {
        return this.getSettings().getBoolean(STRIP_WHITESPACES);
    }

    public void setStripWhitespaces(boolean stripWhitespaces) {
        boolean old = this.getSettings().getBoolean(STRIP_WHITESPACES);
        this.getSettings().setBoolean(STRIP_WHITESPACES, stripWhitespaces);
        this.notifyPropertyChanged(STRIP_WHITESPACES, old, stripWhitespaces);
    }

    @Override
    public boolean isInlineFilesEnabled() {
        return this.getSettings().getBoolean(ENABLE_INLINE_FILES);
    }

    public void setInlineFilesEnabled(boolean inlineFilesEnabled) {
        this.getSettings().setBoolean(ENABLE_INLINE_FILES, inlineFilesEnabled);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        CompressedStringSupport.setString(((MockResponseConfig)this.getConfig()).getResponseContent(), this.getResponseContent());
    }

    @Override
    public void addAttachmentsChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(ATTACHMENTS_PROPERTY, listener);
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(ATTACHMENTS_PROPERTY, listener);
    }

    public SoapVersion getSoapVersion() {
        if (this.getMockOperation().getOperation() == null) {
            return SoapVersion.Soap11;
        }
        return this.getMockOperation().getOperation().getInterface().getSoapVersion();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "responseContent"));
        StringToStringsMap responseHeaders = this.getResponseHeaders();
        for (Map.Entry headerEntry : responseHeaders.entrySet()) {
            for (String value : (List)headerEntry.getValue()) {
                result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, new ResponseHeaderHolder((String)headerEntry.getKey(), value, this), "value"));
            }
        }
        this.addWsaPropertyExpansions(result, this.getWsaConfig(), this);
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public void addWsaPropertyExpansions(List<PropertyExpansion> result, WsaConfig wsaConfig, ModelItem modelItem) {
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "action"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "from"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "to"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "replyTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "replyToRefParams"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "faultTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "faultToRefParams"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "relatesTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "relationshipType"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "messageID"));
    }

    public String getOutgoingWss() {
        return ((MockResponseConfig)this.getConfig()).getOutgoingWss();
    }

    public void setOutgoingWss(String outgoingWss) {
        String old = this.getOutgoingWss();
        ((MockResponseConfig)this.getConfig()).setOutgoingWss(outgoingWss);
        this.notifyPropertyChanged(OUGOING_WSS, old, outgoingWss);
    }

    @Override
    public String getPropertiesLabel() {
        return "Custom Properties";
    }

    @Override
    public Attachment.AttachmentEncoding getAttachmentEncoding(String partName) {
        HttpAttachmentPart attachmentPart = this.getAttachmentPart(partName);
        if (attachmentPart == null) {
            return AttachmentUtils.getAttachmentEncoding(this.getOperation(), partName, true);
        }
        return AttachmentUtils.getAttachmentEncoding(this.getOperation(), attachmentPart, true);
    }

    @Override
    public WsaConfig getWsaConfig() {
        if (this.wsaConfig == null) {
            if (!((MockResponseConfig)this.getConfig()).isSetWsaConfig()) {
                ((MockResponseConfig)this.getConfig()).addNewWsaConfig();
            }
            this.wsaConfig = new WsaConfig(((MockResponseConfig)this.getConfig()).getWsaConfig(), this);
        }
        return this.wsaConfig;
    }

    public boolean isWsAddressing() {
        return ((MockResponseConfig)this.getConfig()).getUseWsAddressing();
    }

    public void setWsAddressing(boolean wsAddressing) {
        boolean old = ((MockResponseConfig)this.getConfig()).getUseWsAddressing();
        ((MockResponseConfig)this.getConfig()).setUseWsAddressing(wsAddressing);
        this.notifyPropertyChanged("wsAddressing", old, wsAddressing);
    }

    @Override
    public boolean isWsaEnabled() {
        return this.isWsAddressing();
    }

    @Override
    public void setWsaEnabled(boolean arg0) {
        this.setWsAddressing(arg0);
    }

    @Override
    public WsdlOperation getOperation() {
        return this.getMockOperation().getOperation();
    }

    @Override
    public void setOperation(WsdlOperation operation) {
        this.getMockOperation().setOperation(operation);
    }

    @Override
    protected String mockresultProperty() {
        return MOCKRESULT_PROPERTY;
    }

    public static class ResponseHeaderHolder {
        private final String key;
        private final String oldValue;
        private WsdlMockResponse mockResponse;

        public ResponseHeaderHolder(String key, String oldValue, WsdlMockResponse mockResponse) {
            this.key = key;
            this.oldValue = oldValue;
            this.mockResponse = mockResponse;
        }

        public String getValue() {
            return this.oldValue;
        }

        public void setValue(String value) {
            StringToStringsMap valueMap = this.mockResponse.getResponseHeaders();
            valueMap.replace(this.key, this.oldValue, value);
            this.mockResponse.setResponseHeaders(valueMap);
        }
    }
}

