/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock.dispatch;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.dispatch.AbstractMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchFactory;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class XPathMockOperationDispatcher
extends AbstractMockOperationDispatcher {
    private GroovyEditor xpathEditor;

    public XPathMockOperationDispatcher(MockOperation mockOperation) {
        super(mockOperation);
    }

    @Override
    public MockResponse selectMockResponse(MockRequest request, MockResult result) throws DispatchException {
        String[] values;
        XmlObject xmlObject;
        try {
            xmlObject = request.getRequestXmlObject();
        }
        catch (XmlException e) {
            throw new DispatchException("Error getting XmlObject for request: " + e);
        }
        String path = this.getMockOperation().getScript();
        if (StringUtils.isNullOrEmpty(path)) {
            throw new DispatchException("Missing dispatch XPath expression");
        }
        for (String value : values = XmlUtils.selectNodeValues(xmlObject, path)) {
            MockResponse mockResponse = this.getMockOperation().getMockResponseByName(value);
            if (mockResponse == null) continue;
            return mockResponse;
        }
        return null;
    }

    @Override
    public JComponent getEditorComponent() {
        JPanel xpathEditorPanel = new JPanel(new BorderLayout());
        DispatchXPathGroovyEditorModel editorModel = new DispatchXPathGroovyEditorModel();
        this.xpathEditor = new GroovyEditor(editorModel);
        xpathEditorPanel.add((Component)this.xpathEditor, "Center");
        xpathEditorPanel.add((Component)this.buildXPathEditorToolbar(editorModel), "First");
        return xpathEditorPanel;
    }

    public GroovyEditor getXPathEditor() {
        return this.xpathEditor;
    }

    @Override
    public void release() {
        this.releaseEditorComponent();
        super.release();
    }

    @Override
    public void releaseEditorComponent() {
        if (this.xpathEditor != null) {
            this.xpathEditor.release();
        }
        super.releaseEditorComponent();
    }

    @Override
    public boolean hasDefaultResponse() {
        return true;
    }

    protected JXToolBar buildXPathEditorToolbar(DispatchXPathGroovyEditorModel editorModel) {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        this.addToolbarActions(editorModel, toolbar);
        toolbar.addGlue();
        toolbar.addFixed(ModelItemDesktopPanel.createActionButton(new ShowOnlineHelpAction("/soap-mocking/working-with-mockservices.html"), true));
        return toolbar;
    }

    protected void addToolbarActions(DispatchXPathGroovyEditorModel editorModel, JXToolBar toolbar) {
        toolbar.addFixed(UISupport.createToolbarButton(editorModel.getRunAction()));
    }

    public class DispatchXPathGroovyEditorModel
    implements GroovyEditorModel {
        private RunXPathAction runXPathAction;

        public DispatchXPathGroovyEditorModel() {
            this.runXPathAction = new RunXPathAction();
        }

        @Override
        public String[] getKeywords() {
            return new String[]{"define", "namespace"};
        }

        @Override
        public Action getRunAction() {
            return this.runXPathAction;
        }

        @Override
        public String getScript() {
            return XPathMockOperationDispatcher.this.getMockOperation().getScript();
        }

        @Override
        public Settings getSettings() {
            return XPathMockOperationDispatcher.this.getMockOperation().getSettings();
        }

        @Override
        public void setScript(String text) {
            XPathMockOperationDispatcher.this.getMockOperation().setScript(text);
        }

        @Override
        public String getScriptName() {
            return null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public ModelItem getModelItem() {
            return XPathMockOperationDispatcher.this.getMockOperation();
        }
    }

    private class RunXPathAction
    extends AbstractAction {
        public RunXPathAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
            this.putValue("ShortDescription", "Evaluates this xpath expression against the latest request");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MockResult lastMockResult = XPathMockOperationDispatcher.this.getMockOperation().getLastMockResult();
            if (lastMockResult == null) {
                UISupport.showErrorMessage("Missing last request to select from");
                return;
            }
            try {
                MockResponse retVal = XPathMockOperationDispatcher.this.selectMockResponse(lastMockResult.getMockRequest(), null);
                UISupport.showInfoMessage("XPath Selection returned [" + (retVal == null ? "null" : retVal.getName()) + "]");
            }
            catch (Exception e1) {
                SoapUI.logError(e1);
            }
        }
    }

    public static class Factory
    implements MockOperationDispatchFactory {
        @Override
        public MockOperationDispatcher build(MockOperation mockOperation) {
            return new XPathMockOperationDispatcher(mockOperation);
        }
    }
}

