/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.monitor.SoapMonitorAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.monitor.ContentTypes;
import com.eviware.soapui.impl.wsdl.monitor.MonitorListener;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorEngine;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorEngineImpl;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorListenerCallBack;
import com.eviware.soapui.impl.wsdl.monitor.WsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeRequestMessageEditor;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeResponseMessageEditor;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.HttpRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.list.TreeList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;

public class SoapMonitor
extends JPanel {
    private static final String ALL_FILTER_OPTION = "- all -";
    private JProgressBar progressBar;
    private JButton stopButton = null;
    private JXTable logTable = null;
    private MonitorLogTableModel tableModel = null;
    private String httpProxyHost = null;
    private int httpProxyPort = 80;
    private JButton startButton;
    private final WsdlProject project;
    private MessageExchangeRequestMessageEditor requestViewer;
    private MessageExchangeResponseMessageEditor responseViewer;
    private MessageExchangeModelItem requestModelItem;
    private JButton optionsButton;
    private int listenPort;
    private String targetEndpoint;
    private JButton clearButton;
    private int maxRows;
    private JButton addToTestCaseButton;
    private JButton createRequestButton;
    private JButton addToMockServiceButton;
    private Stack<WsdlMonitorMessageExchange> messageExchangeStack = new Stack();
    private StackProcessor stackProcessor = new StackProcessor();
    private PatternFilter operationFilter;
    private PatternFilter interfaceFilter;
    private PatternFilter targetHostFilter;
    private JLabel infoLabel;
    private PatternFilter requestHostFilter;
    private JComboBox requestHostFilterCombo;
    private JComboBox targetHostFilterCombo;
    private JComboBox interfaceFilterCombo;
    private JComboBox operationFilterCombo;
    private DefaultComboBoxModel operationFilterModel;
    private DefaultComboBoxModel requestFilterModel;
    private DefaultComboBoxModel targetHostFilterModel;
    private JLabel rowCountLabel = new JLabel();
    private Map<AbstractInterface<?>, String> addedEndpoints;
    private JXToolBar toolbar;
    private String incomingRequestWss;
    private String incomingResponseWss;
    private boolean setAsProxy;
    private XFormDialog optionsDialog;
    private SoapMonitorEngine monitorEngine;
    private String oldProxyHost;
    private String oldProxyPort;
    private boolean oldProxyEnabled;
    private boolean oldProxyAuto;
    private String sslEndpoint;
    private JInspectorPanel inspectorPanel;
    private SoapMonitorListenerCallBack listenerCallBack;

    public SoapMonitor(WsdlProject project, int listenPort, String incomingRequestWss, String incomingResponseWss, JXToolBar mainToolbar, boolean setAsProxy, String sslEndpoint) {
        super(new BorderLayout());
        this.project = project;
        this.listenPort = listenPort;
        this.incomingRequestWss = incomingRequestWss;
        this.incomingResponseWss = incomingResponseWss;
        this.setAsProxy = setAsProxy;
        this.maxRows = 100;
        this.sslEndpoint = sslEndpoint;
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildToolbars(mainToolbar), "North");
        this.add((Component)this.buildContent(), "Center");
        this.start();
    }

    public SoapMonitor(WsdlProject project, int sourcePort, String incomingRequestWss, String incomingResponseWss, JXToolBar toolbar, boolean setAsProxy) {
        this(project, sourcePort, incomingRequestWss, incomingResponseWss, toolbar, setAsProxy, null);
    }

    private JComponent buildContent() {
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildLog());
        JComponentInspector<JComponent> viewInspector = new JComponentInspector<JComponent>(this.buildViewer(), "Message Content", "Shows message content", true);
        this.inspectorPanel.addInspector(viewInspector);
        return this.inspectorPanel.getComponent();
    }

    private JComponent buildLog() {
        this.tableModel = new MonitorLogTableModel();
        this.logTable = new JXTable(1, 2);
        this.logTable.setColumnControlVisible(true);
        this.logTable.setModel((TableModel)this.tableModel);
        this.logTable.setHorizontalScrollEnabled(true);
        this.logTable.setSelectionMode(2);
        this.operationFilter = new PatternFilter(".*", 0, 4);
        this.operationFilter.setAcceptNull(true);
        this.interfaceFilter = new PatternFilter(".*", 0, 3);
        this.interfaceFilter.setAcceptNull(true);
        this.targetHostFilter = new PatternFilter(".*", 0, 2);
        this.targetHostFilter.setAcceptNull(true);
        this.requestHostFilter = new PatternFilter(".*", 0, 1);
        this.requestHostFilter.setAcceptNull(true);
        Filter[] filters = new Filter[]{this.requestHostFilter, this.targetHostFilter, this.interfaceFilter, this.operationFilter};
        FilterPipeline pipeline = new FilterPipeline(filters);
        this.logTable.setFilters(pipeline);
        ListSelectionModel sel = this.logTable.getSelectionModel();
        sel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int row = SoapMonitor.this.logTable.getSelectedRow();
                if (row == -1) {
                    SoapMonitor.this.requestModelItem.setMessageExchange(null);
                } else {
                    WsdlMonitorMessageExchange exchange = SoapMonitor.this.tableModel.getMessageExchangeAt(row);
                    SoapMonitor.this.requestModelItem.setMessageExchange(exchange);
                }
                SoapMonitor.this.addToMockServiceButton.setEnabled(row != -1);
                SoapMonitor.this.addToTestCaseButton.setEnabled(row != -1);
                SoapMonitor.this.createRequestButton.setEnabled(row != -1);
            }
        });
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BorderLayout());
        this.toolbar.addGlue();
        tablePane.add((Component)this.buildFilterBar(), "North");
        tablePane.add((Component)new JScrollPane((Component)this.logTable), "Center");
        return tablePane;
    }

    private JPanel buildFilterBar() {
        this.requestFilterModel = new DefaultComboBoxModel<String>(new String[]{ALL_FILTER_OPTION});
        this.targetHostFilterModel = new DefaultComboBoxModel<String>(new String[]{ALL_FILTER_OPTION});
        Dimension comboBoxSize = new Dimension(90, 18);
        this.requestHostFilterCombo = UISupport.setFixedSize(new JComboBox(this.requestFilterModel), comboBoxSize);
        ButtonBarBuilder toolbar = new ButtonBarBuilder();
        toolbar.addFixed((JComponent)new JLabel("Request Host"));
        toolbar.addRelatedGap();
        toolbar.addFixed((JComponent)this.requestHostFilterCombo);
        toolbar.addUnrelatedGap();
        this.requestHostFilterCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int ix = SoapMonitor.this.requestHostFilterCombo.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                SoapMonitor.this.requestHostFilter.setAcceptNull(ix == 0);
                if (ix == 0) {
                    SoapMonitor.this.requestHostFilter.setPattern(".*", 0);
                } else {
                    SoapMonitor.this.requestHostFilter.setPattern(SoapMonitor.this.requestHostFilterCombo.getSelectedItem().toString(), 0);
                }
                SoapMonitor.this.updateRowCountLabel();
            }
        });
        toolbar.addFixed((JComponent)new JLabel("Target Host"));
        toolbar.addRelatedGap();
        this.targetHostFilterCombo = UISupport.setFixedSize(new JComboBox(this.targetHostFilterModel), comboBoxSize);
        toolbar.addFixed((JComponent)this.targetHostFilterCombo);
        toolbar.addUnrelatedGap();
        this.targetHostFilterCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int ix = SoapMonitor.this.targetHostFilterCombo.getSelectedIndex();
                if (ix == -1) {
                    return;
                }
                SoapMonitor.this.targetHostFilter.setAcceptNull(ix == 0);
                if (ix == 0) {
                    SoapMonitor.this.targetHostFilter.setPattern(".*", 0);
                } else {
                    SoapMonitor.this.targetHostFilter.setPattern(SoapMonitor.this.targetHostFilterCombo.getSelectedItem().toString(), 0);
                }
                SoapMonitor.this.updateRowCountLabel();
            }
        });
        String[] interfaceNames = ModelSupport.getNames(new String[]{ALL_FILTER_OPTION}, ModelSupport.getChildren(this.getProject(), WsdlInterface.class));
        toolbar.addFixed((JComponent)new JLabel("Interface"));
        toolbar.addRelatedGap();
        this.interfaceFilterCombo = UISupport.setFixedSize(new JComboBox<String>(interfaceNames), comboBoxSize);
        toolbar.addFixed((JComponent)this.interfaceFilterCombo);
        toolbar.addUnrelatedGap();
        this.operationFilterModel = new DefaultComboBoxModel<String>(new String[]{ALL_FILTER_OPTION});
        this.interfaceFilterCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String item = (String)SoapMonitor.this.interfaceFilterCombo.getSelectedItem();
                SoapMonitor.this.operationFilterModel.removeAllElements();
                if (item == null || SoapMonitor.this.getProject().getInterfaceByName(item) == null) {
                    SoapMonitor.this.operationFilterModel.addElement(SoapMonitor.ALL_FILTER_OPTION);
                    SoapMonitor.this.interfaceFilter.setPattern(".*", 0);
                } else if (SoapMonitor.this.getProject().getInterfaceByName(item) != null) {
                    String[] operationNames;
                    WsdlInterface iface = (WsdlInterface)SoapMonitor.this.getProject().getInterfaceByName(item);
                    for (String s : operationNames = ModelSupport.getNames(new String[]{SoapMonitor.ALL_FILTER_OPTION}, iface.getOperationList())) {
                        SoapMonitor.this.operationFilterModel.addElement(s);
                    }
                    SoapMonitor.this.interfaceFilter.setPattern(iface.getName(), 0);
                }
            }
        });
        toolbar.addFixed((JComponent)new JLabel("Operation"));
        toolbar.addRelatedGap();
        this.operationFilterCombo = UISupport.setFixedSize(new JComboBox(this.operationFilterModel), comboBoxSize);
        toolbar.addFixed((JComponent)this.operationFilterCombo);
        this.operationFilterCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int ix = SoapMonitor.this.operationFilterCombo.getSelectedIndex();
                if (ix == -1) {
                    SoapMonitor.this.operationFilter.setPattern(".*", 0);
                    SoapMonitor.this.updateRowCountLabel();
                    return;
                }
                SoapMonitor.this.operationFilter.setAcceptNull(ix == 0);
                if (ix == 0) {
                    SoapMonitor.this.operationFilter.setPattern(".*", 0);
                } else {
                    SoapMonitor.this.operationFilter.setPattern(SoapMonitor.this.operationFilterCombo.getSelectedItem().toString(), 0);
                }
                SoapMonitor.this.updateRowCountLabel();
            }
        });
        toolbar.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 0));
        return toolbar.getPanel();
    }

    protected void updateRowCountLabel() {
        this.rowCountLabel.setText(this.logTable.getRowCount() + "/" + this.tableModel.getRowCount() + " entries");
    }

    private JComponent buildViewer() {
        this.requestModelItem = new MessageExchangeModelItem("monitor message exchange", null){

            @Override
            public boolean hasRawData() {
                return true;
            }
        };
        this.requestViewer = new MessageExchangeRequestMessageEditor(this.requestModelItem);
        this.responseViewer = new MessageExchangeResponseMessageEditor(this.requestModelItem);
        return UISupport.createHorizontalSplit(this.requestViewer, this.responseViewer);
    }

    private JComponent buildToolbars(JXToolBar mainToolbar) {
        this.toolbar = UISupport.createSmallToolbar();
        this.startButton = UISupport.createToolbarButton(UISupport.createImageIcon("/start.png"));
        mainToolbar.addFixed(this.startButton);
        this.stopButton = UISupport.createToolbarButton(UISupport.createImageIcon("/stop.png"));
        mainToolbar.addFixed(this.stopButton);
        this.optionsButton = UISupport.createToolbarButton(new SoapMonitorOptionsAction());
        mainToolbar.addFixed(this.optionsButton);
        this.createRequestButton = UISupport.createToolbarButton(UISupport.createImageIcon("/soap_request.png"));
        this.toolbar.addFixed(this.createRequestButton);
        this.addToTestCaseButton = UISupport.createToolbarButton(UISupport.createImageIcon("/testcase.png"));
        this.toolbar.addFixed(this.addToTestCaseButton);
        this.addToMockServiceButton = UISupport.createToolbarButton(UISupport.createImageIcon("/soap_virt.png"));
        this.toolbar.addFixed(this.addToMockServiceButton);
        this.clearButton = UISupport.createToolbarButton(UISupport.createImageIcon("/clear.png"));
        this.toolbar.addFixed(this.clearButton);
        this.startButton.setToolTipText("Starts the HTTP Monitor as configured");
        this.stopButton.setToolTipText("Stops the HTTP Monitor");
        this.optionsButton.setToolTipText("Sets Monitor Options");
        this.clearButton.setToolTipText("Clear all/selected messages from the log");
        this.createRequestButton.setToolTipText("Creates requests from selected messages");
        this.addToTestCaseButton.setToolTipText("Adds selected requests to a test case");
        this.addToMockServiceButton.setToolTipText("Adds selected responses to a mock service");
        this.createRequestButton.setEnabled(false);
        this.addToMockServiceButton.setEnabled(false);
        this.addToTestCaseButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoapMonitor.this.start();
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoapMonitor.this.stop();
            }
        });
        this.clearButton.addActionListener(new ClearAction());
        this.createRequestButton.addActionListener(new CreateRequestsAction());
        this.addToTestCaseButton.addActionListener(new AddToTestCaseAction());
        this.addToMockServiceButton.addActionListener(new AddToMockServiceAction());
        mainToolbar.addGlue();
        this.infoLabel = new JLabel();
        this.infoLabel.setPreferredSize(new Dimension(150, 20));
        this.infoLabel.setOpaque(false);
        mainToolbar.addFixed(this.infoLabel);
        this.progressBar = new JProgressBar();
        JPanel progressBarPanel = UISupport.createProgressBarPanel(this.progressBar, 2, false);
        progressBarPanel.setPreferredSize(new Dimension(60, 20));
        mainToolbar.addFixed(progressBarPanel);
        return this.toolbar;
    }

    public void start() {
        int localPort = this.getLocalPort();
        this.listenerCallBack = new SoapMonitorListenerCallBack(){

            @Override
            public void fireAddMessageExchange(WsdlMonitorMessageExchange messageExchange) {
                SoapMonitor.this.addMessageExchange(messageExchange);
            }
        };
        this.monitorEngine = new SoapMonitorEngineImpl(this.sslEndpoint);
        this.monitorEngine.setIncludedContentTypes(ContentTypes.of(this.project.getSettings().getString("Content types to monitor", SoapMonitorAction.defaultContentTypes().toString())));
        this.monitorEngine.start(this.getProject(), localPort, this.listenerCallBack);
        if (this.monitorEngine.isRunning()) {
            this.stopButton.setEnabled(true);
            this.startButton.setEnabled(false);
            this.optionsButton.setEnabled(false);
            this.infoLabel.setText((this.monitorEngine.isProxy() ? "HTTP Proxy " : "SSL Tunnel ") + "on port " + localPort);
            this.progressBar.setIndeterminate(true);
            if (this.setAsProxy) {
                this.oldProxyHost = SoapUI.getSettings().getString(ProxySettings.HOST, "");
                this.oldProxyPort = SoapUI.getSettings().getString(ProxySettings.PORT, "");
                this.oldProxyEnabled = SoapUI.getSettings().getBoolean(ProxySettings.ENABLE_PROXY);
                this.oldProxyAuto = SoapUI.getSettings().getBoolean(ProxySettings.AUTO_PROXY);
                SoapUI.getSettings().setString(ProxySettings.HOST, "127.0.0.1");
                SoapUI.getSettings().setString(ProxySettings.PORT, String.valueOf(localPort));
                SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, true);
                SoapUI.getSettings().setBoolean(ProxySettings.AUTO_PROXY, false);
                SoapUI.updateProxyFromSettings();
            }
            SoapUI.log.info("Started HTTP Monitor on local port " + localPort);
        } else {
            this.stopButton.setEnabled(false);
            this.startButton.setEnabled(true);
            this.optionsButton.setEnabled(true);
            this.infoLabel.setText("Stopped");
            this.progressBar.setIndeterminate(false);
            SoapUI.log.info("Could not start HTTP Monitor on local port " + localPort);
        }
    }

    public void close() {
        this.stop();
    }

    public void stop() {
        this.monitorEngine.stop();
        if (this.addedEndpoints != null) {
            for (Interface interface_ : this.addedEndpoints.keySet()) {
                interface_.removeEndpoint(this.addedEndpoints.get(interface_));
            }
            this.addedEndpoints.clear();
        }
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(true);
        this.optionsButton.setEnabled(true);
        this.progressBar.setIndeterminate(false);
        this.infoLabel.setText("Stopped");
        if (this.setAsProxy) {
            SoapUI.getSettings().setString(ProxySettings.HOST, this.oldProxyHost);
            SoapUI.getSettings().setString(ProxySettings.PORT, this.oldProxyPort);
            SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, this.oldProxyEnabled);
            SoapUI.getSettings().setBoolean(ProxySettings.AUTO_PROXY, this.oldProxyAuto);
            SoapUI.updateProxyFromSettings();
        }
    }

    protected String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    private StringToStringsMap excludeProxyHeaders(StringToStringsMap requestHeaders) {
        StringToStringsMap stsmap = new StringToStringsMap();
        for (String key : requestHeaders.getKeys()) {
            if (key.contains("Proxy") || key.contains("Content")) continue;
            stsmap.add(key, requestHeaders.get(key, ""));
        }
        return stsmap;
    }

    protected void setHttpProxyHost(String proxyHost) {
        this.httpProxyHost = proxyHost;
    }

    protected int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected void setHttpProxyPort(int proxyPort) {
        this.httpProxyPort = proxyPort;
    }

    public String getTargetHost() {
        String host = this.targetEndpoint;
        try {
            URL url = new URL(host);
            return url.getHost();
        }
        catch (MalformedURLException e) {
            return host;
        }
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public int getTargetPort() {
        try {
            URL url = new URL(this.targetEndpoint);
            return url.getPort() == -1 ? 80 : url.getPort();
        }
        catch (MalformedURLException e) {
            return 80;
        }
    }

    public int getLocalPort() {
        return this.listenPort;
    }

    public synchronized void addMessageExchange(WsdlMonitorMessageExchange messageExchange) {
        this.messageExchangeStack.push(messageExchange);
        if (!this.stackProcessor.isRunning()) {
            new Thread((Runnable)this.stackProcessor, "SoapMonitor StackProcessor for project [" + this.getProject().getName() + "]").start();
        }
    }

    public MonitorLogTableModel getLogModel() {
        return this.tableModel;
    }

    public void addSoapMonitorListener(MonitorListener listener) {
        this.listenerCallBack.addSoapMonitorListener(listener);
    }

    public void removeSoapMonitorListener(MonitorListener listener) {
        this.listenerCallBack.removeSoapMonitorListener(listener);
    }

    public WsdlProject getProject() {
        return this.project;
    }

    public void release() {
        this.requestViewer.release();
        this.responseViewer.release();
        if (this.optionsDialog != null) {
            this.optionsDialog.release();
            this.optionsDialog = null;
        }
        this.inspectorPanel.release();
    }

    public boolean isRunning() {
        return this.monitorEngine.isRunning();
    }

    public MessageExchangeModelItem getRequestModelItem() {
        return this.requestModelItem;
    }

    public class MonitorLogTableModel
    extends AbstractTableModel {
        private List<WsdlMonitorMessageExchange> exchanges = new TreeList();

        public synchronized void clear() {
            int sz = this.exchanges.size();
            while (this.exchanges.size() > 0) {
                WsdlMonitorMessageExchange removed = this.exchanges.remove(0);
                removed.discard();
            }
            this.fireTableRowsDeleted(0, sz);
            while (SoapMonitor.this.requestFilterModel.getSize() > 1) {
                SoapMonitor.this.requestFilterModel.removeElementAt(1);
            }
            while (SoapMonitor.this.targetHostFilterModel.getSize() > 1) {
                SoapMonitor.this.targetHostFilterModel.removeElementAt(1);
            }
            SoapMonitor.this.updateRowCountLabel();
        }

        public synchronized void clearRows(int[] indices) {
            for (int c = indices.length; c > 0; --c) {
                int index = indices[c - 1];
                WsdlMonitorMessageExchange removed = this.exchanges.remove(SoapMonitor.this.logTable.convertRowIndexToModel(index));
                removed.discard();
                this.fireTableRowsDeleted(index, index);
                SoapMonitor.this.updateRowCountLabel();
            }
        }

        @Override
        public int getColumnCount() {
            return 12;
        }

        public WsdlMonitorMessageExchange getMessageExchangeAt(int tableRow) {
            return this.exchanges.get(SoapMonitor.this.logTable.convertRowIndexToModel(tableRow));
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Count.";
                }
                case 1: {
                    return "Time";
                }
                case 2: {
                    return "Request Host";
                }
                case 3: {
                    return "Target Host";
                }
                case 4: {
                    return "Interface";
                }
                case 5: {
                    return "Operation";
                }
                case 6: {
                    return "Time Taken";
                }
                case 7: {
                    return "Req Sz";
                }
                case 8: {
                    return "Resp Sz";
                }
                case 9: {
                    return "Method";
                }
                case 10: {
                    return "Path";
                }
                case 11: {
                    return "Content-Type";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.exchanges.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.exchanges.size()) {
                return null;
            }
            WsdlMonitorMessageExchange exchange = this.exchanges.get(rowIndex);
            if (exchange == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 1: {
                    return DateUtil.formatFull(new Date(exchange.getTimestamp()));
                }
                case 2: {
                    return exchange.getRequestHost();
                }
                case 3: {
                    return exchange.getTargetUrl().getHost();
                }
                case 4: {
                    return exchange.getOperation() == null ? "- unknown -" : exchange.getOperation().getInterface().getName();
                }
                case 5: {
                    return exchange.getOperation() == null ? "- unknown -" : exchange.getOperation().getName();
                }
                case 6: {
                    return String.valueOf(exchange.getTimeTaken());
                }
                case 7: {
                    return String.valueOf(exchange.getRequestContentLength());
                }
                case 8: {
                    return String.valueOf(exchange.getResponseContentLength());
                }
                case 9: {
                    return String.valueOf(exchange.getRequestMethod());
                }
                case 10: {
                    return exchange.getTargetUrl().getPath();
                }
                case 11: {
                    return String.valueOf(exchange.getResponseContentType());
                }
            }
            return null;
        }

        public synchronized void addMessageExchange(WsdlMonitorMessageExchange exchange) {
            this.exchanges.add(exchange);
            int size = this.exchanges.size();
            this.fireTableRowsInserted(size - 1, size - 1);
            this.fitSizeToMaxRows();
            String requestHost = exchange.getRequestHost();
            if (SoapMonitor.this.requestFilterModel.getIndexOf(requestHost) == -1) {
                SoapMonitor.this.requestFilterModel.addElement(requestHost);
            }
            String host = exchange.getTargetUrl().getHost();
            if (SoapMonitor.this.targetHostFilterModel.getIndexOf(host) == -1) {
                SoapMonitor.this.targetHostFilterModel.addElement(host);
            }
            SoapMonitor.this.updateRowCountLabel();
        }

        public void fitSizeToMaxRows() {
            int removeCnt = 0;
            while (this.exchanges.size() > SoapMonitor.this.maxRows) {
                WsdlMonitorMessageExchange removed = this.exchanges.remove(0);
                removed.discard();
                ++removeCnt;
            }
            if (removeCnt > 0) {
                this.fireTableDataChanged();
                SoapMonitor.this.updateRowCountLabel();
            }
        }
    }

    private class StackProcessor
    implements Runnable {
        private boolean canceled;
        private boolean running;

        private StackProcessor() {
        }

        @Override
        public void run() {
            this.running = true;
            SoapUI.log.info("Started stackprocessor for soapmonitor in project [" + SoapMonitor.this.getProject().getName() + "]");
            while (!this.canceled && SoapMonitor.this.messageExchangeStack.size() > 0) {
                WsdlMonitorMessageExchange messageExchange = (WsdlMonitorMessageExchange)SoapMonitor.this.messageExchangeStack.pop();
                if (messageExchange != null) {
                    this.processMessage(messageExchange);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.running = false;
        }

        private synchronized void processMessage(WsdlMonitorMessageExchange messageExchange) {
            messageExchange.prepare(SoapMonitor.this.project.getWssContainer().getIncomingWssByName(SoapMonitor.this.incomingRequestWss), SoapMonitor.this.project.getWssContainer().getIncomingWssByName(SoapMonitor.this.incomingResponseWss));
            SoapMonitor.this.tableModel.addMessageExchange(messageExchange);
            SoapMonitor.this.listenerCallBack.fireOnMessageExchange(messageExchange);
        }

        public void cancel() {
            this.canceled = true;
        }

        protected boolean isCanceled() {
            return this.canceled;
        }

        protected boolean isRunning() {
            return this.running;
        }
    }

    public class SoapMonitorOptionsAction
    extends AbstractAction {
        public SoapMonitorOptionsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/preferences.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SoapMonitor.this.optionsDialog == null) {
                SoapMonitor.this.optionsDialog = ADialogBuilder.buildDialog(OptionsForm.class);
            }
            StringList endpoints = new StringList();
            endpoints.add(null);
            for (WsdlInterface iface : ModelSupport.getChildren(SoapMonitor.this.getProject(), WsdlInterface.class)) {
                endpoints.addAll(iface.getEndpoints());
            }
            SoapMonitor.this.optionsDialog.setIntValue("Port", SoapMonitor.this.listenPort);
            SoapMonitor.this.optionsDialog.setIntValue("Max Log", SoapMonitor.this.maxRows);
            SoapMonitor.this.optionsDialog.setOptions("Incoming Request WSS", StringUtils.merge(SoapMonitor.this.project.getWssContainer().getIncomingWssNames(), "<none>"));
            SoapMonitor.this.optionsDialog.setOptions("Incoming Response WSS", StringUtils.merge(SoapMonitor.this.project.getWssContainer().getIncomingWssNames(), "<none>"));
            SoapMonitor.this.optionsDialog.setValue("Incoming Request WSS", SoapMonitor.this.incomingRequestWss);
            SoapMonitor.this.optionsDialog.setValue("Incoming Response WSS", SoapMonitor.this.incomingResponseWss);
            SoapMonitor.this.optionsDialog.setValue("Content types to monitor", SoapMonitor.this.project.getSettings().getString("Content types to monitor", SoapMonitorAction.defaultContentTypes().toString()));
            if (SoapMonitor.this.optionsDialog.show()) {
                XmlBeansSettingsImpl settings = SoapMonitor.this.getProject().getSettings();
                settings.setLong("Port", SoapMonitor.this.listenPort = SoapMonitor.this.optionsDialog.getIntValue("Port", SoapMonitor.this.listenPort));
                settings.setLong("Max Log", SoapMonitor.this.maxRows = SoapMonitor.this.optionsDialog.getIntValue("Max Log", SoapMonitor.this.maxRows));
                settings.setString("Content types to monitor", SoapMonitor.this.optionsDialog.getValue("Content types to monitor"));
                SoapMonitor.this.incomingRequestWss = SoapMonitor.this.optionsDialog.getValue("Incoming Request WSS");
                SoapMonitor.this.incomingResponseWss = SoapMonitor.this.optionsDialog.getValue("Incoming Response WSS");
                SoapMonitor.this.tableModel.fitSizeToMaxRows();
            }
        }

        @AForm(name="HTTP Monitor Options", description="Set options for HTTP Monitor", helpUrl="/http-recording/reference/general-options.html", icon="/preferences-system.png")
        private class OptionsForm {
            @AField(description="The local port to listen on", name="Port", type=AField.AFieldType.INT)
            public static final String PORT = "Port";
            @AField(description="The maximum number of exchanges to log", name="Max Log", type=AField.AFieldType.INT)
            public static final String MAXROWS = "Max Log";
            @AField(description="The Incoming WSS configuration to use for processing requests", name="Incoming Request WSS", type=AField.AFieldType.ENUMERATION)
            public static final String REQUEST_WSS = "Incoming Request WSS";
            @AField(description="The Outgoing WSS configuration to use for processing responses", name="Incoming Response WSS", type=AField.AFieldType.ENUMERATION)
            public static final String RESPONSE_WSS = "Incoming Response WSS";
            @AField(description="Content types to monitor", name="Content types to monitor", type=AField.AFieldType.STRINGAREA)
            public static final String SET_CONTENT_TYPES = "Content types to monitor";

            private OptionsForm() {
            }
        }
    }

    private final class ClearAction
    implements ActionListener {
        private ClearAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SoapMonitor.this.logTable.getRowCount() == 0) {
                return;
            }
            int[] rows = SoapMonitor.this.logTable.getSelectedRows();
            if (rows.length == 0) {
                if (UISupport.confirm("Clear monitor log?", "Clear Log")) {
                    SoapMonitor.this.tableModel.clear();
                }
            } else if (UISupport.confirm("Clear " + rows.length + " rows from monitor log?", "Clear Log")) {
                SoapMonitor.this.tableModel.clearRows(rows);
            }
        }
    }

    private final class CreateRequestsAction
    implements ActionListener {
        private CreateRequestsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = SoapMonitor.this.logTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            if (UISupport.confirm("Create " + rows.length + " requests", "Create Request")) {
                int withoutOperation = 0;
                for (int row : rows) {
                    WsdlMonitorMessageExchange me = SoapMonitor.this.tableModel.getMessageExchangeAt(row);
                    if (me.getOperation() == null) {
                        ++withoutOperation;
                        continue;
                    }
                    WsdlRequest request = me.getOperation().addNewRequest("Monitor Request " + (row + 1));
                    request.setRequestContent(me.getRequestContent());
                    request.setEndpoint(me.getTargetUrl().toString());
                    Attachment[] requestAttachments = me.getRequestAttachments();
                    if (requestAttachments == null) continue;
                    for (Attachment attachment : requestAttachments) {
                        request.importAttachment(attachment);
                    }
                }
                if (withoutOperation > 0) {
                    UISupport.showInfoMessage("For " + withoutOperation + "request(s) there are no operations", "Create Request");
                }
            }
        }
    }

    @AForm(description="Set options for adding selected requests to a TestCase", name="Add To TestCase")
    private final class AddToTestCaseAction
    implements ActionListener {
        private static final String CREATE_NEW_OPTION = "<Create New>";
        private XFormDialog dialog;
        @AField(name="Target TestSuite", description="The target TestSuite", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "Target TestSuite";
        @AField(name="Target TestCase", description="The target TestCase for the requests", type=AField.AFieldType.ENUMERATION)
        public static final String TESTCASE = "Target TestCase";
        @AField(name="Open Editor", description="Open the created TestCase", type=AField.AFieldType.BOOLEAN)
        public static final String OPENEDITOR = "Open Editor";
        TestSuite testSuite;

        private AddToTestCaseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] objectArray;
            int[] rows = SoapMonitor.this.logTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(this.getClass());
                this.dialog.getFormField(TESTSUITE).addFormFieldListener(new XFormFieldListener(){

                    @Override
                    public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                        if (newValue.equals(AddToTestCaseAction.CREATE_NEW_OPTION)) {
                            AddToTestCaseAction.this.dialog.setOptions(AddToTestCaseAction.TESTCASE, new String[]{AddToTestCaseAction.CREATE_NEW_OPTION});
                        } else {
                            Object[] objectArray;
                            AddToTestCaseAction.this.testSuite = SoapMonitor.this.getProject().getTestSuiteByName(newValue);
                            XFormDialog xFormDialog = AddToTestCaseAction.this.dialog;
                            if (AddToTestCaseAction.this.testSuite == null) {
                                Object[] objectArray2 = new String[1];
                                objectArray = objectArray2;
                                objectArray2[0] = AddToTestCaseAction.CREATE_NEW_OPTION;
                            } else {
                                objectArray = ModelSupport.getNames(AddToTestCaseAction.this.testSuite.getTestCaseList(), new String[]{AddToTestCaseAction.CREATE_NEW_OPTION});
                            }
                            xFormDialog.setOptions(AddToTestCaseAction.TESTCASE, objectArray);
                        }
                    }
                });
            }
            Object[] testSuiteNames = ModelSupport.getNames(new String[]{CREATE_NEW_OPTION}, SoapMonitor.this.getProject().getTestSuiteList());
            this.dialog.setOptions(TESTSUITE, testSuiteNames);
            this.testSuite = SoapMonitor.this.getProject().getTestSuiteByName(this.dialog.getValue(TESTSUITE));
            if (this.testSuite == null) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = CREATE_NEW_OPTION;
            } else {
                objectArray = ModelSupport.getNames(this.testSuite.getTestCaseList(), new String[]{CREATE_NEW_OPTION});
            }
            this.dialog.setOptions(TESTCASE, objectArray);
            if (this.dialog.show()) {
                WsdlTestCase testCase;
                String targetTestSuiteName = this.dialog.getValue(TESTSUITE);
                String targetTestCaseName = this.dialog.getValue(TESTCASE);
                WsdlTestSuite testSuite = SoapMonitor.this.getProject().getTestSuiteByName(targetTestSuiteName);
                if (testSuite == null) {
                    targetTestSuiteName = ModelSupport.promptForUniqueName("TestSuite", SoapMonitor.this.getProject(), "");
                    if (targetTestSuiteName == null) {
                        return;
                    }
                    testSuite = SoapMonitor.this.getProject().addNewTestSuite(targetTestSuiteName);
                }
                if ((testCase = testSuite.getTestCaseByName(targetTestCaseName)) == null) {
                    targetTestCaseName = ModelSupport.promptForUniqueName("TestCase", testSuite, "");
                    if (targetTestCaseName == null) {
                        return;
                    }
                    testCase = testSuite.addNewTestCase(targetTestCaseName);
                }
                for (int row : rows) {
                    WsdlMonitorMessageExchange me = SoapMonitor.this.tableModel.getMessageExchangeAt(row);
                    if (me.getOperation() != null) {
                        WsdlTestRequestStep test = (WsdlTestRequestStep)testCase.insertTestStep(WsdlTestRequestStepFactory.createConfig(me.getOperation(), "Monitor Request " + (row + 1)), -1);
                        WsdlTestRequest request = test.getTestRequest();
                        request.setRequestContent(me.getRequestContent());
                        request.setEndpoint(me.getTargetUrl().toString());
                        request.setIncomingWss(SoapMonitor.this.incomingRequestWss);
                        Attachment[] requestAttachments = me.getRequestAttachments();
                        if (requestAttachments == null) continue;
                        for (Attachment attachment : requestAttachments) {
                            request.importAttachment(attachment);
                        }
                        continue;
                    }
                    HttpRequestStepFactory httpRequestStepFactory = new HttpRequestStepFactory();
                    HttpTestRequestStep test = (HttpTestRequestStep)testCase.insertTestStep(httpRequestStepFactory.createConfig(me, "Monitor Request " + (row + 1)), -1);
                    test.getTestRequest().setRequestHeaders(SoapMonitor.this.excludeProxyHeaders(me.getRequestHeaders()));
                    HttpTestRequest request = (HttpTestRequest)test.getHttpRequest();
                    request.setEndpoint(me.getTargetUrl().toString());
                    String existingMediaType = me.getResponseHeaders().get("Content-Type", "");
                    if (!StringUtils.isNullOrEmpty(existingMediaType)) {
                        request.setMediaType(existingMediaType);
                    }
                    if ("application/octet-stream".equals(existingMediaType) || "application/x-amf".equals(existingMediaType)) {
                        request.attachBinaryData(me.getRequestContent().getBytes(), existingMediaType);
                    } else {
                        request.setRequestContent(me.getRequestContent());
                        test.getTestRequest().setRequestContent(me.getRequestContent());
                    }
                    Attachment[] requestAttachments = me.getRequestAttachments();
                    if (requestAttachments == null) continue;
                    for (Attachment attachment : requestAttachments) {
                        request.importAttachment(attachment);
                    }
                }
                if (this.dialog.getBooleanValue(OPENEDITOR)) {
                    UISupport.selectAndShow(testCase);
                }
            }
        }
    }

    @AForm(description="Set options for adding selected requests to a MockService", name="Add To MockService")
    private final class AddToMockServiceAction
    implements ActionListener {
        private static final String CREATE_NEW_OPTION = "<Create New>";
        private XFormDialog dialog;
        @AField(name="Target MockService", description="The target TestSuite", type=AField.AFieldType.ENUMERATION)
        public static final String MOCKSERVICE = "Target MockService";
        @AField(name="Open Editor", description="Open the created MockService", type=AField.AFieldType.BOOLEAN)
        public static final String OPENEDITOR = "Open Editor";

        private AddToMockServiceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = SoapMonitor.this.logTable.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(this.getClass());
            }
            Object[] testSuiteNames = ModelSupport.getNames(new String[]{CREATE_NEW_OPTION}, SoapMonitor.this.getProject().getMockServiceList());
            this.dialog.setOptions(MOCKSERVICE, testSuiteNames);
            if (this.dialog.show()) {
                int withoutOperation = 0;
                for (int row : rows) {
                    WsdlMonitorMessageExchange me = SoapMonitor.this.tableModel.getMessageExchangeAt(row);
                    if (me.getOperation() != null) continue;
                    ++withoutOperation;
                }
                if (withoutOperation == rows.length) {
                    UISupport.showInfoMessage("No SOAP requests selected!");
                    return;
                }
                String targetMockServiceName = this.dialog.getValue(MOCKSERVICE);
                WsdlMockService mockService = SoapMonitor.this.getProject().getMockServiceByName(targetMockServiceName);
                if (mockService == null) {
                    targetMockServiceName = ModelSupport.promptForUniqueName("MockService", SoapMonitor.this.getProject(), "");
                    if (targetMockServiceName == null) {
                        return;
                    }
                    mockService = SoapMonitor.this.getProject().addNewMockService(targetMockServiceName);
                    mockService.setIncomingWss(SoapMonitor.this.incomingResponseWss);
                }
                int cnt = 0;
                for (int row : rows) {
                    WsdlMonitorMessageExchange me = SoapMonitor.this.tableModel.getMessageExchangeAt(row);
                    if (me.getOperation() == null) continue;
                    WsdlMockOperation mockOperation = mockService.getMockOperation(me.getOperation());
                    if (mockOperation == null) {
                        mockOperation = (WsdlMockOperation)mockService.addNewMockOperation(me.getOperation());
                    }
                    WsdlMockResponse mockResponse = mockOperation.addNewMockResponse("Monitor Response " + ++cnt, false);
                    mockResponse.setResponseContent(me.getResponseContent());
                    Attachment[] requestAttachments = me.getResponseAttachments();
                    if (requestAttachments == null) continue;
                    for (Attachment attachment : requestAttachments) {
                        mockResponse.addAttachment(attachment);
                    }
                }
                if (cnt == 0) {
                    UISupport.showInfoMessage("No response messages found");
                } else {
                    UISupport.showInfoMessage("Added " + cnt + " MockResponses to MockService");
                    if (this.dialog.getBooleanValue(OPENEDITOR)) {
                        UISupport.selectAndShow(mockService);
                    }
                }
            }
        }
    }
}

