/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.loadtest.data.StatisticsHistory;
import com.eviware.soapui.model.testsuite.TestStep;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JStatisticsGraph
extends JComponent
implements Scrollable {
    private static final Color THREADCOUNT_COLOR = Color.GREEN.darker();
    private static final Color AVERAGE_COLOR = Color.BLUE;
    private static final Color ERRORS_COLOR = Color.RED.darker();
    private static final Color TPS_COLOR = Color.BLACK;
    private static final Color BPS_COLOR = Color.ORANGE;
    private static final Color LAST_COLOR = Color.MAGENTA.brighter();
    private static final int SCROLL_AHEAD = 50;
    private final WsdlLoadTest loadTest;
    private final LoadTestStatistics statisticsModel;
    private StatisticsHistory.StatisticsHistoryModel data;
    private JComponent legend;
    private InternalTableModelListener tableModelListener = new InternalTableModelListener();
    private long[] maxValues;
    private float[] scales;

    public JStatisticsGraph(WsdlLoadTest loadTest) {
        this.loadTest = loadTest;
        this.statisticsModel = loadTest.getStatisticsModel();
        this.data = this.statisticsModel.getHistory().getTestStepHistory(-1);
        this.setAutoscrolls(true);
        this.addMouseMotionListener(new InternalMouseMotionListener());
        this.data.addTableModelListener(this.tableModelListener);
        this.initMaxValues();
        this.initScales();
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JStatisticsGraph.this.initScales();
            }
        });
    }

    public TableModel getModel() {
        return this.data;
    }

    public void release() {
        this.data.removeTableModelListener(this.tableModelListener);
    }

    public void setTestStep(TestStep testStep) {
        if (this.data != null) {
            this.data.removeTableModelListener(this.tableModelListener);
            this.data.release();
        }
        this.data = testStep == null ? this.statisticsModel.getHistory().getTestStepHistory(-1) : this.statisticsModel.getHistory().getTestStepHistory(testStep.getTestCase().getIndexOfTestStep(testStep));
        this.initMaxValues();
        this.initScales();
        this.data.addTableModelListener(this.tableModelListener);
        this.getParent().invalidate();
        this.revalidate();
        this.repaint();
    }

    public long getResolution() {
        return this.statisticsModel.getHistory().getResolution();
    }

    public void setResolution(long resolution) {
        this.statisticsModel.getHistory().setResolution(resolution);
    }

    private void initMaxValues() {
        this.maxValues = new long[this.data.getColumnCount()];
        for (int c = 0; c < this.data.getRowCount(); ++c) {
            for (int i = 0; i < this.data.getColumnCount(); ++i) {
                long value = (Long)this.data.getValueAt(c, i);
                if (value <= this.maxValues[i]) continue;
                this.maxValues[i] = value;
            }
        }
    }

    private void initScales() {
        this.scales = new float[this.maxValues.length];
        for (int c = 0; c < this.maxValues.length; ++c) {
            this.recalcScale(c);
        }
    }

    private boolean recalcScale(int index) {
        float scale;
        float f = scale = index == 0 || this.maxValues[index] == 0L ? 1.0f : (float)this.getHeight() / (float)(this.maxValues[index] + 10L);
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        if (Float.compare(scale, this.scales[index]) == 0) {
            return false;
        }
        this.scales[index] = scale;
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle clip = g.getClipBounds();
        g.fillRect((int)clip.getX(), (int)clip.getY(), (int)clip.getWidth(), (int)clip.getHeight());
        double right = clip.getX() + clip.getWidth();
        int rowCount = this.data.getRowCount();
        int height = this.getHeight();
        for (int c = (int)clip.getX(); c < rowCount && (double)c < right; ++c) {
            for (int i = 0; i < this.data.getColumnCount(); ++i) {
                if (i == 0) {
                    g.setColor(THREADCOUNT_COLOR);
                } else if (i == LoadTestStatistics.Statistic.AVERAGE.getIndex() + 1) {
                    g.setColor(AVERAGE_COLOR);
                } else if (i == LoadTestStatistics.Statistic.ERRORS.getIndex() + 1) {
                    g.setColor(ERRORS_COLOR);
                } else if (i == LoadTestStatistics.Statistic.TPS.getIndex() + 1) {
                    g.setColor(TPS_COLOR);
                } else {
                    if (i != LoadTestStatistics.Statistic.BPS.getIndex() + 1) continue;
                    g.setColor(BPS_COLOR);
                }
                int yOffset = (int)((float)((Long)this.data.getValueAt(c, i)).longValue() * this.scales[i]);
                if (!clip.contains(c, height - yOffset - 1)) continue;
                g.drawLine(c, height - yOffset - 1, c, height - yOffset - 1);
            }
        }
    }

    public JComponent getLegend() {
        if (this.legend == null) {
            this.buildLegend();
        }
        return this.legend;
    }

    private void buildLegend() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("ThreadCount", this.createLegendIcon(THREADCOUNT_COLOR), 2));
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JLabel("Average (ms)", this.createLegendIcon(AVERAGE_COLOR), 2));
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JLabel("ErrorCount", this.createLegendIcon(ERRORS_COLOR), 2));
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JLabel("Transaction/Sec", this.createLegendIcon(TPS_COLOR), 2));
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JLabel("Bytes/Sec", this.createLegendIcon(BPS_COLOR), 2));
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.legend = builder.getPanel();
    }

    private Icon createLegendIcon(Color color) {
        BufferedImage image = new BufferedImage(10, 10, 5);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(1, 1, 8, 8);
        g.setColor(Color.DARK_GRAY);
        g.drawRect(0, 0, 10, 10);
        return new ImageIcon(image);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.getHeight();
        int width = this.data.getRowCount() + 50;
        return new Dimension(width, height);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    private final class InternalTableModelListener
    implements TableModelListener {
        private InternalTableModelListener() {
        }

        @Override
        public synchronized void tableChanged(TableModelEvent e) {
            boolean repaint = false;
            if (e.getType() == 1) {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                int height = JStatisticsGraph.this.getHeight();
                for (int c = firstRow; c <= lastRow; ++c) {
                    for (int i = 0; i < JStatisticsGraph.this.data.getColumnCount(); ++i) {
                        long value = (Long)JStatisticsGraph.this.data.getValueAt(c, i);
                        if (value <= JStatisticsGraph.this.maxValues[i]) continue;
                        ((JStatisticsGraph)JStatisticsGraph.this).maxValues[i] = value;
                        repaint = JStatisticsGraph.this.recalcScale(i);
                    }
                }
                if (!repaint) {
                    Rectangle rect = new Rectangle(firstRow, 0, lastRow - firstRow + 1, height);
                    JStatisticsGraph.this.repaint(rect);
                }
                Dimension size = JStatisticsGraph.this.getSize();
                Rectangle r = JStatisticsGraph.this.getVisibleRect();
                double x2 = r.getX() + r.getWidth();
                if (x2 >= (double)JStatisticsGraph.this.data.getRowCount() && x2 < (double)(JStatisticsGraph.this.data.getRowCount() + 50)) {
                    JStatisticsGraph.this.scrollRectToVisible(new Rectangle(firstRow + 25, 0, lastRow - firstRow + 1, height));
                }
                if (!repaint && size.getWidth() < (double)(JStatisticsGraph.this.data.getRowCount() + 50)) {
                    JStatisticsGraph.this.revalidate();
                }
            } else if (e.getType() == 0) {
                JStatisticsGraph.this.initMaxValues();
                JStatisticsGraph.this.initScales();
                repaint = true;
            }
            if (repaint) {
                JStatisticsGraph.this.getParent().invalidate();
                JStatisticsGraph.this.revalidate();
                JStatisticsGraph.this.repaint();
            }
        }
    }

    private class InternalMouseMotionListener
    implements MouseMotionListener {
        private InternalMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
            JStatisticsGraph.this.scrollRectToVisible(r);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

