/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportStatisticsAction;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyRegistry;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JLoadTestAssertionsTable;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JLoadTestLogTable;
import com.eviware.soapui.impl.wsdl.panels.loadtest.JStatisticsTable;
import com.eviware.soapui.impl.wsdl.panels.loadtest.StatisticsDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.loadtest.StatisticsHistoryDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.support.MockLoadTestRunContext;
import com.eviware.soapui.impl.wsdl.panels.support.MockLoadTestRunner;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DesktopListenerAdapter;
import com.eviware.soapui.ui.support.KeySensitiveModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WsdlLoadTestDesktopPanel
extends KeySensitiveModelItemDesktopPanel<WsdlLoadTest>
implements PropertyChangeListener {
    private static final String SECONDS_LIMIT = "Seconds";
    private static final String RUNS_LIMIT = "Total Runs";
    private static final String RUNS_PER_THREAD_LIMIT = "Runs per Thread";
    private JSplitPane mainSplit;
    private JTabbedPane mainTabs;
    private JPanel graphPanel;
    protected JButton runButton;
    protected JButton cancelButton;
    protected JButton statisticsGraphButton;
    private WsdlLoadTestRunner runner;
    protected JSpinner threadsSpinner;
    private LoadTestRunListener internalLoadTestListener = new InternalLoadTestListener();
    protected JComboBox strategyCombo;
    protected JPanel loadStrategyConfigurationPanel;
    protected JButton resetButton;
    private LoadTestLog loadTestLog;
    protected JButton optionsButton;
    protected JButton testTimesGraphButton;
    private Object limit;
    private JSpinner limitSpinner;
    private JComboBox limitTypeCombo;
    private SpinnerNumberModel limitSpinnerModel;
    protected JProgressBar progressBar;
    private StatisticsDesktopPanel statisticsDesktopPanel;
    private StatisticsHistoryDesktopPanel statisticsHistoryDesktopPanel;
    public boolean loadTestIsRunning;
    private InternalDesktopListener desktopListener;
    protected JButton exportButton;
    private JLoadTestAssertionsTable assertionsTable;
    private JStatisticsTable statisticsTable;
    private GroovyEditorComponent tearDownGroovyEditor;
    private GroovyEditorComponent setupGroovyEditor;
    private JInspectorPanel inspectorPanel;

    public WsdlLoadTestDesktopPanel(WsdlLoadTest loadTest) {
        super(loadTest);
        this.loadTestLog = loadTest.getLoadTestLog();
        loadTest.addPropertyChangeListener(this);
        loadTest.addLoadTestRunListener(this.internalLoadTestListener);
        this.desktopListener = new InternalDesktopListener();
        SoapUI.getDesktop().addDesktopListener(this.desktopListener);
        this.buildUI();
    }

    private void buildUI() {
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildContent(), "Center");
        this.setPreferredSize(new Dimension(600, 500));
    }

    private JComponent buildContent() {
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildStatistics());
        this.addInspectors(this.inspectorPanel);
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("LoadTest Log");
        return this.inspectorPanel.getComponent();
    }

    protected void addInspectors(JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildLog(), "LoadTest Log", "The current LoadTest execution log", true));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildAssertions(), "LoadTest Assertions", "The assertions for this LoadTest", true));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildSetupScriptPanel(), "Setup Script", "Script to run before tunning a TestCase"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildTearDownScriptPanel(), "TearDown Script", "Script to run after a TestCase Run"));
    }

    protected GroovyEditorComponent buildTearDownScriptPanel() {
        this.tearDownGroovyEditor = new GroovyEditorComponent(new TearDownScriptGroovyEditorModel(), null);
        return this.tearDownGroovyEditor;
    }

    protected GroovyEditorComponent buildSetupScriptPanel() {
        this.setupGroovyEditor = new GroovyEditorComponent(new SetupScriptGroovyEditorModel(), null);
        return this.setupGroovyEditor;
    }

    protected JComponent buildStatistics() {
        this.statisticsTable = new JStatisticsTable((WsdlLoadTest)this.getModelItem());
        return this.statisticsTable;
    }

    protected JComponent buildLog() {
        JLoadTestLogTable loadTestLogTable = new JLoadTestLogTable(this.loadTestLog);
        return loadTestLogTable;
    }

    protected JComponent buildAssertions() {
        this.assertionsTable = new JLoadTestAssertionsTable((WsdlLoadTest)this.getModelItem());
        return this.assertionsTable;
    }

    protected JComponent buildToolbar() {
        WsdlLoadTest loadTest = (WsdlLoadTest)this.getModelItem();
        JXToolBar toolbar = UISupport.createToolbar();
        this.runButton = UISupport.createToolbarButton(new RunLoadTestAction());
        this.cancelButton = UISupport.createToolbarButton(new CancelRunTestCaseAction(), false);
        this.resetButton = UISupport.createToolbarButton(new ResetAction());
        this.exportButton = UISupport.createToolbarButton(new ExportStatisticsAction(loadTest.getStatisticsModel()));
        this.statisticsGraphButton = UISupport.createToolbarButton(new ShowStatisticsGraphAction());
        this.testTimesGraphButton = UISupport.createToolbarButton(new ShowTestTimesGraphAction());
        this.statisticsGraphButton.setEnabled(((WsdlLoadTest)this.getModelItem()).getHistoryLimit() != 0L);
        this.testTimesGraphButton.setEnabled(((WsdlLoadTest)this.getModelItem()).getHistoryLimit() != 0L);
        SwingActionDelegate<?> optionsDelegate = SwingActionDelegate.createDelegate("LoadTestOptionsAction", loadTest);
        optionsDelegate.putValue("SmallIcon", UISupport.createImageIcon("/preferences.png"));
        this.optionsButton = UISupport.createToolbarButton(optionsDelegate);
        this.strategyCombo = new JComboBox<String>(LoadStrategyRegistry.getInstance().getStrategies());
        this.strategyCombo.setToolTipText("Selects which LoadTest Strategy to use");
        UISupport.setPreferredHeight(this.strategyCombo, 18);
        this.strategyCombo.setSelectedItem(loadTest.getLoadStrategy().getType());
        this.strategyCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (item == null) {
                    return;
                }
                WsdlLoadTestDesktopPanel.this.setLoadStrategy(item.toString());
            }
        });
        toolbar.add(this.runButton);
        toolbar.add(this.cancelButton);
        toolbar.add(this.statisticsGraphButton);
        toolbar.add(this.testTimesGraphButton);
        toolbar.add(this.resetButton);
        toolbar.add(this.exportButton);
        toolbar.add(this.optionsButton);
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("/load-testing/getting-started.html")));
        toolbar.add(Box.createHorizontalGlue());
        this.buildLimitBar(toolbar);
        toolbar.addSeparator();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(70, 20));
        toolbar.addFixed(this.progressBar);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("Threads:"));
        builder.addRelatedGap();
        this.threadsSpinner = new JSpinner(new SpinnerNumberModel(((WsdlLoadTest)this.getModelItem()).getThreadCount(), 1.0, 9999.0, 1.0));
        this.threadsSpinner.setToolTipText("Sets the number of threads (\"Virtual Users\") to run this TestCase");
        UISupport.setPreferredHeight(this.threadsSpinner, 18);
        this.threadsSpinner.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setThreadCount(((SpinnerNumberModel)WsdlLoadTestDesktopPanel.this.threadsSpinner.getModel()).getNumber().intValue());
            }
        });
        builder.addFixed((JComponent)this.threadsSpinner);
        builder.addUnrelatedGap();
        LoadStrategy loadStrategy = loadTest.getLoadStrategy();
        builder.addFixed((JComponent)new JLabel("Strategy"));
        builder.addRelatedGap();
        builder.addFixed((JComponent)this.strategyCombo);
        builder.addUnrelatedGap();
        this.loadStrategyConfigurationPanel = new JPanel(new BorderLayout());
        this.loadStrategyConfigurationPanel.add((Component)loadStrategy.getConfigurationPanel(), "Center");
        builder.addFixed((JComponent)this.loadStrategyConfigurationPanel);
        builder.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 3));
        return UISupport.buildPanelWithToolbar(toolbar, builder.getPanel());
    }

    public void buildLimitBar(JXToolBar toolbar) {
        this.limitSpinnerModel = new SpinnerNumberModel(((WsdlLoadTest)this.getModelItem()).getTestLimit(), 0.0, 9.223372036854776E18, 100.0);
        this.limitSpinner = new JSpinner(this.limitSpinnerModel);
        this.limitSpinner.setPreferredSize(new Dimension(70, 20));
        this.limitSpinner.setToolTipText("Sets the limit for this test; total number of requests or seconds to run");
        this.limitSpinner.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int intValue = ((SpinnerNumberModel)WsdlLoadTestDesktopPanel.this.limitSpinner.getModel()).getNumber().intValue();
                ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setTestLimit(intValue);
            }
        });
        toolbar.addSeparator();
        toolbar.addFixed(new JLabel("Limit:"));
        toolbar.addSeparator();
        toolbar.addFixed(this.limitSpinner);
        toolbar.addSeparator();
        this.limitTypeCombo = new JComboBox<String>(new String[]{RUNS_LIMIT, SECONDS_LIMIT, RUNS_PER_THREAD_LIMIT});
        if (((WsdlLoadTest)this.getModelItem()).getLimitType() == LoadTestLimitTypesConfig.TIME) {
            this.limitTypeCombo.setSelectedIndex(1);
        } else if (((WsdlLoadTest)this.getModelItem()).getLimitType() == LoadTestLimitTypesConfig.COUNT_PER_THREAD) {
            this.limitTypeCombo.setSelectedIndex(2);
        }
        toolbar.addFixed(this.limitTypeCombo);
        toolbar.addSeparator();
        this.limitTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (WsdlLoadTestDesktopPanel.RUNS_LIMIT.equals(item)) {
                    ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setLimitType(LoadTestLimitTypesConfig.COUNT);
                } else if (WsdlLoadTestDesktopPanel.SECONDS_LIMIT.equals(item)) {
                    ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setLimitType(LoadTestLimitTypesConfig.TIME);
                } else if (WsdlLoadTestDesktopPanel.RUNS_PER_THREAD_LIMIT.equals(item)) {
                    ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setLimitType(LoadTestLimitTypesConfig.COUNT_PER_THREAD);
                }
            }
        });
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING && !UISupport.confirm("Running test will be canceled when closing window. Close anyway?", "Close LoadTest")) {
            return false;
        }
        ((WsdlLoadTest)this.getModelItem()).removeLoadTestRunListener(this.internalLoadTestListener);
        ((WsdlLoadTest)this.getModelItem()).removePropertyChangeListener(this);
        ((WsdlLoadTest)this.getModelItem()).getStatisticsModel().reset();
        if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
            this.runner.cancel("closing window");
        }
        if (this.statisticsDesktopPanel != null) {
            SoapUI.getDesktop().closeDesktopPanel(this.statisticsDesktopPanel);
        }
        if (this.statisticsHistoryDesktopPanel != null) {
            SoapUI.getDesktop().closeDesktopPanel(this.statisticsHistoryDesktopPanel);
        }
        this.assertionsTable.release();
        this.loadStrategyConfigurationPanel.removeAll();
        SoapUI.getDesktop().removeDesktopListener(this.desktopListener);
        this.statisticsTable.release();
        this.inspectorPanel.release();
        this.setupGroovyEditor.release();
        this.tearDownGroovyEditor.release();
        return this.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        WsdlLoadTest loadTest = (WsdlLoadTest)this.getModelItem();
        return modelItem == loadTest || modelItem == loadTest.getTestCase() || modelItem == loadTest.getTestCase().getTestSuite() || modelItem == loadTest.getTestCase().getTestSuite().getProject();
    }

    public void setLoadStrategy(String type) {
        LoadStrategyFactory factory = LoadStrategyRegistry.getInstance().getFactory(type);
        LoadStrategy loadStrategy = factory.create((WsdlLoadTest)this.getModelItem());
        ((WsdlLoadTest)this.getModelItem()).setLoadStrategy(loadStrategy);
        this.loadStrategyConfigurationPanel.removeAll();
        this.loadStrategyConfigurationPanel.add((Component)loadStrategy.getConfigurationPanel(), "Center");
        this.loadStrategyConfigurationPanel.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(WsdlLoadTest.THREADCOUNT_PROPERTY)) {
            this.threadsSpinner.setValue(evt.getNewValue());
        } else if (evt.getPropertyName().equals(WsdlLoadTest.HISTORYLIMIT_PROPERTY)) {
            long lng = (Long)evt.getNewValue();
            this.statisticsGraphButton.setEnabled(lng != 0L);
            this.testTimesGraphButton.setEnabled(lng != 0L);
        }
        super.propertyChange(evt);
    }

    @Override
    protected void renameModelItem() {
        SoapUI.getActionRegistry().performAction("RenameLoadTestAction", (ModelItem)this.getModelItem(), null);
    }

    @Override
    protected void cloneModelItem() {
        SoapUI.getActionRegistry().performAction("CloneLoadTestAction", (ModelItem)this.getModelItem(), null);
    }

    private class InternalLoadTestListener
    extends LoadTestRunListenerAdapter {
        private InternalLoadTestListener() {
        }

        @Override
        public void beforeLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            WsdlLoadTestDesktopPanel.this.loadTestLog.clear();
            WsdlLoadTestDesktopPanel.this.loadTestIsRunning = true;
            if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestLimit() > 0L) {
                WsdlLoadTestDesktopPanel.this.progressBar.setValue(0);
                WsdlLoadTestDesktopPanel.this.progressBar.setString(null);
            } else {
                WsdlLoadTestDesktopPanel.this.progressBar.setString("...");
            }
            WsdlLoadTestDesktopPanel.this.progressBar.setStringPainted(true);
            WsdlLoadTestDesktopPanel.this.runButton.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.cancelButton.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.strategyCombo.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.limitTypeCombo.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.optionsButton.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.threadsSpinner.setEnabled(((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getLoadStrategy().allowThreadCountChangeDuringRun());
            new Thread((Runnable)new ProgressBarUpdater(), ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getName() + " ProgressBarUpdater").start();
        }

        @Override
        public void afterLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            WsdlLoadTestDesktopPanel.this.runButton.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.cancelButton.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.strategyCombo.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.limitTypeCombo.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.threadsSpinner.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.optionsButton.setEnabled(true);
            WsdlLoadTestDesktopPanel.this.runner = null;
            WsdlLoadTestDesktopPanel.this.loadTestIsRunning = false;
            if (WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(false);
                WsdlLoadTestDesktopPanel.this.progressBar.setValue(0);
            } else if (testRunner.getStatus() == TestRunner.Status.FINISHED) {
                WsdlLoadTestDesktopPanel.this.progressBar.setValue(100);
            }
            if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                UISupport.showErrorMessage("LoadTest failed; " + testRunner.getReason());
            }
        }
    }

    private final class InternalDesktopListener
    extends DesktopListenerAdapter {
        private InternalDesktopListener() {
        }

        @Override
        public void desktopPanelClosed(DesktopPanel desktopPanel) {
            if (desktopPanel == WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel) {
                WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel = null;
            } else if (desktopPanel == WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel) {
                WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel = null;
            }
        }
    }

    private class TearDownScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        @Override
        public Action createRunAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MockLoadTestRunner mockTestRunner = new MockLoadTestRunner((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem(), SoapUI.ensureGroovyLog());
                        ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).runTearDownScript(new MockLoadTestRunContext(mockTestRunner), mockTestRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }

        public TearDownScriptGroovyEditorModel() {
            super(new String[]{"log", "context", "loadTestRunner"}, (ModelItem)WsdlLoadTestDesktopPanel.this.getModelItem(), "TearDown");
        }

        @Override
        public String getScript() {
            return ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTearDownScript();
        }

        @Override
        public void setScript(String text) {
            ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setTearDownScript(text);
        }
    }

    private class SetupScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        @Override
        public Action createRunAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MockLoadTestRunner mockTestRunner = new MockLoadTestRunner((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem(), SoapUI.ensureGroovyLog());
                        ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).runSetupScript(new MockLoadTestRunContext(mockTestRunner), mockTestRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }

        public SetupScriptGroovyEditorModel() {
            super(new String[]{"log", "context", "loadTestRunner"}, (ModelItem)WsdlLoadTestDesktopPanel.this.getModelItem(), "Setup");
        }

        @Override
        public String getScript() {
            return ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getSetupScript();
        }

        @Override
        public void setScript(String text) {
            ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).setSetupScript(text);
        }
    }

    public class RunLoadTestAction
    extends AbstractAction {
        public RunLoadTestAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
            this.putValue("ShortDescription", "Runs this LoadTest");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsdlLoadTest loadtest = (WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem();
            if (loadtest.getTestCase().getTestStepCount() == 0) {
                UISupport.showErrorMessage("Missing TestSteps for testing!");
                return;
            }
            if (loadtest.getLimitType() == LoadTestLimitTypesConfig.COUNT && loadtest.getTestLimit() < loadtest.getThreadCount() && !UISupport.confirm("The run limit is set to a lower count than number of threads\nRun Anyway?", "Run LoadTest")) {
                return;
            }
            WsdlLoadTestDesktopPanel.this.runButton.setEnabled(false);
            WsdlLoadTestDesktopPanel.this.runner = loadtest.run();
            Analytics.trackAction(SoapUIActions.RUN_LOAD_TEST_FROM_LOAD_TEST_PANEL);
        }
    }

    public class CancelRunTestCaseAction
    extends AbstractAction {
        public CancelRunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop.png"));
            this.putValue("ShortDescription", "Stops running this LoadTest");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WsdlLoadTestDesktopPanel.this.runner != null) {
                WsdlLoadTestDesktopPanel.this.runner.cancel("Canceled");
                WsdlLoadTestDesktopPanel.this.cancelButton.setEnabled(false);
            }
        }
    }

    public class ResetAction
    extends AbstractAction {
        public ResetAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/reset_loadtest_statistics.gif"));
            this.putValue("ShortDescription", "Resets statistics for this LoadTest");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getStatisticsModel().reset();
        }
    }

    public class ShowStatisticsGraphAction
    extends AbstractAction {
        public ShowStatisticsGraphAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stats_graph.gif"));
            this.putValue("ShortDescription", "Shows the statistics graph");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel == null) {
                WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel = new StatisticsDesktopPanel((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem());
            }
            UISupport.showDesktopPanel(WsdlLoadTestDesktopPanel.this.statisticsDesktopPanel);
        }
    }

    public class ShowTestTimesGraphAction
    extends AbstractAction {
        public ShowTestTimesGraphAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/samples_graph.gif"));
            this.putValue("ShortDescription", "Shows the Statistics History graph");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel == null) {
                WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel = new StatisticsHistoryDesktopPanel((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem());
            }
            UISupport.showDesktopPanel(WsdlLoadTestDesktopPanel.this.statisticsHistoryDesktopPanel);
        }
    }

    private class ProgressBarUpdater
    implements Runnable {
        private ProgressBarUpdater() {
        }

        @Override
        public void run() {
            while (WsdlLoadTestDesktopPanel.this.loadTestIsRunning) {
                if (((WsdlLoadTest)WsdlLoadTestDesktopPanel.this.getModelItem()).getTestLimit() == 0L) {
                    if (WsdlLoadTestDesktopPanel.this.loadTestIsRunning && !WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                        WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(true);
                        WsdlLoadTestDesktopPanel.this.progressBar.setString("...");
                    }
                } else {
                    if (WsdlLoadTestDesktopPanel.this.loadTestIsRunning && WsdlLoadTestDesktopPanel.this.progressBar.isIndeterminate()) {
                        WsdlLoadTestDesktopPanel.this.progressBar.setIndeterminate(false);
                        WsdlLoadTestDesktopPanel.this.progressBar.setString(null);
                    }
                    WsdlLoadTestDesktopPanel.this.progressBar.setValue(WsdlLoadTestDesktopPanel.this.runner == null ? 0 : (int)(WsdlLoadTestDesktopPanel.this.runner.getProgress() * 100.0f));
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    SoapUI.logError(e);
                }
            }
        }
    }
}

