/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class MockRequestXmlDocument
extends AbstractXmlDocument {
    private final MockResponse mockResponse;

    public MockRequestXmlDocument(MockResponse response) {
        this.mockResponse = response;
    }

    @Override
    public SchemaTypeSystem getTypeSystem() {
        try {
            WsdlOperation operation;
            if (this.mockResponse instanceof WsdlMockResponse && (operation = (WsdlOperation)this.mockResponse.getMockOperation().getOperation()) != null) {
                WsdlInterface iface = operation.getInterface();
                WsdlContext wsdlContext = iface.getWsdlContext();
                return wsdlContext.getSchemaTypeSystem();
            }
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        return XmlBeans.getBuiltinTypeSystem();
    }

    @Override
    public void setDocumentContent(DocumentContent documentContent) {
        MockResult mockResult = this.mockResponse.getMockResult();
        if (mockResult != null) {
            mockResult.getMockRequest().setRequestContent(documentContent.getContentAsString());
            this.fireContentChanged();
        } else {
            this.fireContentChanged();
        }
    }

    @Override
    public String getContentType() {
        MockResult mockResult = this.mockResponse.getMockResult();
        return String.valueOf(mockResult == null ? null : mockResult.getMockRequest().getRequestHeaders().get("Content-Type"));
    }

    @Override
    @Nonnull
    public DocumentContent getDocumentContent(EditorDocument.Format format) {
        MockResult mockResult = this.mockResponse.getMockResult();
        String requestContent = mockResult == null ? null : mockResult.getMockRequest().getRequestContent();
        return new DocumentContent(null, requestContent);
    }
}

