/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunContext;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunner;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlGroovyScriptTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListModel;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroovyScriptStepDesktopPanel
extends ModelItemDesktopPanel<WsdlGroovyScriptTestStep>
implements PropertyChangeListener {
    private final WsdlGroovyScriptTestStep groovyStep;
    private GroovyEditor editor;
    private JLogList logArea;
    private Logger logger;
    private TestRunComponentEnabler componentEnabler;
    private RunAction runAction = new RunAction();
    private JEditorStatusBarWithProgress statusBar;
    private SettingsListener settingsListener;
    private JComponentInspector<JComponent> logInspector;
    public boolean updating;
    private JInspectorPanel inspectorPanel;

    public GroovyScriptStepDesktopPanel(WsdlGroovyScriptTestStep groovyStep) {
        super(groovyStep);
        this.groovyStep = groovyStep;
        this.componentEnabler = new TestRunComponentEnabler(groovyStep.getTestCase());
        this.buildUI();
        this.setPreferredSize(new Dimension(600, 440));
        this.logger = LogManager.getLogger((String)(groovyStep.getName() + "#" + this.hashCode()));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GroovyScriptStepDesktopPanel.this.editor.requestFocusInWindow();
            }
        });
        groovyStep.addPropertyChangeListener(this);
    }

    protected GroovyEditor getEditor() {
        return this.editor;
    }

    private void buildUI() {
        this.editor = new GroovyEditor(new ScriptStepGroovyEditorModel());
        this.logArea = new JLogList("Groovy Test Log");
        this.logArea.addLogger(this.groovyStep.getName() + "#" + this.hashCode(), true);
        this.logArea.getLogList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                String value = GroovyScriptStepDesktopPanel.this.logArea.getLogList().getSelectedValue().toString();
                if (value == null) {
                    return;
                }
                GroovyScriptStepDesktopPanel.this.editor.selectError(value);
            }
        });
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            @Override
            public void dataChanged(ListModel model) {
                GroovyScriptStepDesktopPanel.this.logInspector.setTitle("Log Output (" + model.getSize() + ")");
            }
        });
        this.inspectorPanel = JInspectorPanelFactory.build(this.editor);
        this.logInspector = this.inspectorPanel.addInspector(new JComponentInspector<JLogList>(this.logArea, "Log Output (0)", "Groovy Log output for this script", true));
        this.inspectorPanel.setDefaultDividerLocation(0.8f);
        this.inspectorPanel.activate(this.logInspector);
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add(this.buildStatusBar(), "South");
        this.componentEnabler.add(this.editor);
    }

    private Component buildStatusBar() {
        this.statusBar = new JEditorStatusBarWithProgress(this.editor);
        return this.statusBar;
    }

    private JComponent buildToolbar() {
        JXToolBar toolBar = UISupport.createToolbar();
        JButton runButton = UISupport.createToolbarButton(this.runAction);
        toolBar.add(runButton);
        toolBar.add(Box.createHorizontalGlue());
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code> and <code>testRunner</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolBar.add(label);
        toolBar.addRelatedGap();
        toolBar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("/functional-testing/working-with-scripts.html")));
        this.componentEnabler.add(runButton);
        return toolBar;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        this.componentEnabler.release();
        this.editor.release();
        SoapUI.getSettings().removeSettingsListener(this.settingsListener);
        this.logArea.removeLogger(this.logger.getName());
        this.logger = null;
        this.inspectorPanel.release();
        ((WsdlGroovyScriptTestStep)this.getModelItem()).removePropertyChangeListener(this);
        return super.release();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.groovyStep || modelItem == this.groovyStep.getTestCase() || modelItem == this.groovyStep.getTestCase().getTestSuite() || modelItem == this.groovyStep.getTestCase().getTestSuite().getProject();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("script") && !this.updating) {
            this.updating = true;
            this.editor.getEditArea().setText((String)evt.getNewValue());
            this.updating = false;
        }
        super.propertyChange(evt);
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
            this.putValue("ShortDescription", "Runs this script in a seperate thread using a mock testRunner and testContext");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    MockTestRunner mockTestRunner = new MockTestRunner(GroovyScriptStepDesktopPanel.this.groovyStep.getTestCase(), GroovyScriptStepDesktopPanel.this.logger);
                    GroovyScriptStepDesktopPanel.this.statusBar.setIndeterminate(true);
                    WsdlTestStepResult result = (WsdlTestStepResult)GroovyScriptStepDesktopPanel.this.groovyStep.run(mockTestRunner, new MockTestRunContext(mockTestRunner, GroovyScriptStepDesktopPanel.this.groovyStep));
                    GroovyScriptStepDesktopPanel.this.statusBar.setIndeterminate(false);
                    Throwable er = result.getError();
                    if (er != null) {
                        String message = er.getMessage();
                        GroovyScriptStepDesktopPanel.this.editor.selectError(message);
                        UISupport.showErrorMessage(StringUtils.join((Object[])result.getMessages(), (String)"\n"));
                        GroovyScriptStepDesktopPanel.this.editor.requestFocus();
                    } else if (result.getMessages().length > 0) {
                        UISupport.showInfoMessage(StringUtils.join((Object[])result.getMessages(), (String)"\n"));
                    }
                }
            });
        }
    }

    private class ScriptStepGroovyEditorModel
    implements GroovyEditorModel {
        private ScriptStepGroovyEditorModel() {
        }

        @Override
        public String[] getKeywords() {
            return new String[]{"log", "context", "testRunner"};
        }

        @Override
        public Action getRunAction() {
            return GroovyScriptStepDesktopPanel.this.runAction;
        }

        @Override
        public String getScript() {
            return GroovyScriptStepDesktopPanel.this.groovyStep.getScript();
        }

        @Override
        public void setScript(String text) {
            if (GroovyScriptStepDesktopPanel.this.updating) {
                return;
            }
            GroovyScriptStepDesktopPanel.this.updating = true;
            GroovyScriptStepDesktopPanel.this.groovyStep.setScript(text);
            GroovyScriptStepDesktopPanel.this.updating = false;
        }

        @Override
        public Settings getSettings() {
            return SoapUI.getSettings();
        }

        @Override
        public String getScriptName() {
            return null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public ModelItem getModelItem() {
            return GroovyScriptStepDesktopPanel.this.groovyStep;
        }
    }
}

