/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcRequest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.NamedParameterStatement;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Future;

public class JdbcSubmit
implements Submit,
Runnable {
    public static final String JDBC_ERROR = "JDBC_ERROR";
    public static final String JDBC_TIMEOUT = "JDBC_TIMEOUT";
    private volatile Future<?> future;
    private SubmitContext context;
    private Submit.Status status;
    private SubmitListener[] listeners;
    private Exception error;
    private long timestamp;
    protected ResultSet resultSet;
    protected PreparedStatement statement;
    private Connection connection;
    private long timeTaken;
    private final JdbcRequest request;
    private JdbcResponse response;
    private String rawSql;

    public JdbcSubmit(JdbcRequest request, SubmitContext submitContext, boolean async) {
        int c;
        this.request = request;
        this.context = submitContext;
        List<SubmitListener> regListeners = SoapUI.getListenerRegistry().getListeners(SubmitListener.class);
        SubmitListener[] submitListeners = request.getSubmitListeners();
        this.listeners = new SubmitListener[submitListeners.length + regListeners.size()];
        for (c = 0; c < submitListeners.length; ++c) {
            this.listeners[c] = submitListeners[c];
        }
        for (c = 0; c < regListeners.size(); ++c) {
            this.listeners[submitListeners.length + c] = regListeners.get(c);
        }
        this.error = null;
        this.status = Submit.Status.INITIALIZED;
        if (async) {
            this.future = SoapUI.getThreadPool().submit(this);
        } else {
            this.run();
        }
    }

    @Override
    public void cancel() {
        if (this.status == Submit.Status.CANCELED) {
            return;
        }
        JdbcRequest.logger.info("Canceling request..");
        if (this.status == Submit.Status.RUNNING) {
            this.cancelQuery();
        }
        this.status = Submit.Status.CANCELED;
        for (int i = 0; i < this.listeners.length; ++i) {
            try {
                this.listeners[i].afterSubmit(this, this.context);
                continue;
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public JdbcResponse getResponse() {
        return this.response;
    }

    @Override
    public Submit.Status getStatus() {
        return this.status;
    }

    @Override
    public Submit.Status waitUntilFinished() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        } else {
            throw new RuntimeException("cannot wait on null future");
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block17: {
            try {
                for (int i = 0; i < this.listeners.length; ++i) {
                    if (this.listeners[i].beforeSubmit(this, this.context)) continue;
                    this.status = Submit.Status.CANCELED;
                    System.err.println("listener cancelled submit..");
                    return;
                }
                this.status = Submit.Status.RUNNING;
                this.runQuery();
                if (this.status == Submit.Status.CANCELED) break block17;
                this.status = Submit.Status.FINISHED;
            }
            catch (Exception e) {
                SoapUI.logError(e);
                this.error = e;
            }
            finally {
                if (this.error != null) {
                    this.status = Submit.Status.ERROR;
                }
                if (this.status == Submit.Status.CANCELED) break block17;
                for (int i = 0; i < this.listeners.length; ++i) {
                    try {
                        this.listeners[i].afterSubmit(this, this.context);
                        continue;
                    }
                    catch (Throwable e) {
                        SoapUI.logError(e);
                    }
                }
            }
        }
    }

    private void runQuery() throws Exception {
        this.prepare();
        this.load();
        this.createResponse();
    }

    public void cancelQuery() {
        try {
            if (this.statement != null) {
                this.statement.cancel();
            }
        }
        catch (SQLException ex) {
            SoapUI.logError(ex);
        }
    }

    private void getDatabaseConnection() throws SQLException, SoapUIException {
        JdbcRequestTestStep testStep = this.request.getTestStep();
        this.connection = JdbcUtils.initConnection(this.context, testStep.getDriver(), testStep.getConnectionString(), testStep.getPassword());
    }

    private void load() throws Exception {
        try {
            JdbcRequestTestStep testStep = this.request.getTestStep();
            if (testStep.isStoredProcedure()) {
                this.timestamp = System.currentTimeMillis();
                this.statement.execute();
            } else {
                this.timestamp = System.currentTimeMillis();
                this.statement.execute();
            }
            this.timeTaken = System.currentTimeMillis() - this.timestamp;
            if (!StringUtils.isNullOrEmpty(this.request.getTimeout()) && this.timeTaken > Long.parseLong(this.request.getTimeout())) {
                this.context.setProperty(JDBC_TIMEOUT, PropertyExpander.expandProperties(this.context, this.request.getTimeout()));
            }
        }
        catch (SQLException e) {
            this.context.setProperty(JDBC_ERROR, e);
            throw e;
        }
        finally {
            this.timeTaken = System.currentTimeMillis() - this.timestamp;
        }
    }

    private void prepare() throws Exception {
        JdbcRequestTestStep testStep = this.request.getTestStep();
        this.getDatabaseConnection();
        List<TestProperty> props = testStep.getPropertyList();
        if (testStep.isStoredProcedure()) {
            this.rawSql = PropertyExpander.expandProperties(this.context, testStep.getQuery());
            if (!this.rawSql.startsWith("{call ") && !this.rawSql.endsWith("}")) {
                this.rawSql = "{call " + this.rawSql + "}";
            }
        } else {
            this.rawSql = PropertyExpander.expandProperties(this.context, testStep.getQuery());
        }
        NamedParameterStatement p = new NamedParameterStatement(this.connection, this.rawSql);
        for (TestProperty testProperty : props) {
            String value = PropertyExpander.expandProperties(this.context, testProperty.getValue());
            if (testProperty.getName().equals(WsdlTestStepWithProperties.RESPONSE_AS_XML)) continue;
            p.setString(testProperty.getName(), value);
        }
        this.statement = p.getStatement();
        try {
            if (!StringUtils.isNullOrEmpty(testStep.getQueryTimeout())) {
                String queryTimeout = PropertyExpander.expandProperties(testStep, testStep.getQueryTimeout());
                this.statement.setQueryTimeout(Integer.parseInt(queryTimeout));
            }
        }
        catch (NumberFormatException e) {
            SoapUI.logError(e, "Problem setting timeout");
        }
        try {
            if (!StringUtils.isNullOrEmpty(testStep.getMaxRows())) {
                String maxRows = PropertyExpander.expandProperties(testStep, testStep.getMaxRows());
                this.statement.setMaxRows(Integer.parseInt(maxRows));
            }
        }
        catch (NumberFormatException e) {
            SoapUI.logError(e, "Problem setting maxRows");
        }
        try {
            if (!StringUtils.isNullOrEmpty(testStep.getFetchSize())) {
                String fetchSize = PropertyExpander.expandProperties(testStep, testStep.getFetchSize());
                this.statement.setFetchSize(Integer.parseInt(fetchSize));
            }
        }
        catch (NumberFormatException e) {
            SoapUI.logError(e, "Problem setting fetchSize");
        }
    }

    public String getRawSql() {
        return this.rawSql;
    }

    protected String createResponse() {
        try {
            this.response = new JdbcResponse(this.request, this.statement, this.rawSql);
            this.response.setTimestamp(this.timestamp);
            this.response.setTimeTaken(this.timeTaken);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

