/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.support.ProgressBarTestCaseAdapter;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropHandler;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropable;
import com.eviware.soapui.support.swing.AutoscrollSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JTestSuiteTestCaseList
extends JPanel {
    private Map<TestCase, TestCaseListPanel> panels = new HashMap<TestCase, TestCaseListPanel>();
    private final WsdlTestSuite testSuite;
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private TestCaseListPanel selectedTestCase;

    public JTestSuiteTestCaseList(WsdlTestSuite testSuite) {
        this.testSuite = testSuite;
        this.setLayout(new BoxLayout(this, 1));
        for (int c = 0; c < testSuite.getTestCaseCount(); ++c) {
            TestCaseListPanel testCaseListPanel = this.createTestCaseListPanel(testSuite.getTestCaseAt(c));
            this.panels.put(testSuite.getTestCaseAt(c), testCaseListPanel);
            this.add(testCaseListPanel);
        }
        this.add(Box.createVerticalGlue());
        this.setBackground(Color.WHITE);
        testSuite.addTestSuiteListener(this.testSuiteListener);
        ActionList actions = ActionListBuilder.buildActions(testSuite);
        actions.removeAction(0);
        actions.removeAction(0);
        this.setComponentPopupMenu(ActionSupport.buildPopup(actions));
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler dragAndDropHandler = new SoapUIDragAndDropHandler(new TestCaseListDragAndDropable(this), 2);
        dragSource.createDefaultDragGestureRecognizer(this, 3, dragAndDropHandler);
    }

    public void reset() {
        for (TestCaseListPanel testCasePanel : this.panels.values()) {
            testCasePanel.reset();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.testSuite.addTestSuiteListener(this.testSuiteListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.testSuite.removeTestSuiteListener(this.testSuiteListener);
    }

    protected int getIndexOf(TestCaseListPanel panel) {
        return Arrays.asList(this.getComponents()).indexOf(panel);
    }

    protected TestCaseListPanel createTestCaseListPanel(TestCase testCase) {
        TestCaseListPanel testCaseListPanel = new TestCaseListPanel((WsdlTestCase)testCase);
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler dragAndDropHandler = new SoapUIDragAndDropHandler(new TestCaseListPanelDragAndDropable(testCaseListPanel), 3);
        dragSource.createDefaultDragGestureRecognizer(testCaseListPanel, 3, dragAndDropHandler);
        return testCaseListPanel;
    }

    public final class TestCaseListPanel
    extends JPanel
    implements Autoscroll {
        private final WsdlTestCase testCase;
        private JProgressBar progressBar;
        private JLabel label;
        private ProgressBarTestCaseAdapter progressBarAdapter;
        private TestCasePropertyChangeListener testCasePropertyChangeListener;
        private AutoscrollSupport autoscrollSupport;

        public TestCaseListPanel(WsdlTestCase testCase) {
            super(new BorderLayout());
            this.setFocusable(true);
            this.testCase = testCase;
            this.autoscrollSupport = new AutoscrollSupport(this);
            this.progressBar = new JProgressBar(0, 100){

                @Override
                protected void processMouseEvent(MouseEvent e) {
                    if (e.getID() == 501 || e.getID() == 502) {
                        TestCaseListPanel.this.processMouseEvent(this.translateMouseEvent(e));
                    }
                }

                @Override
                protected void processMouseMotionEvent(MouseEvent e) {
                    TestCaseListPanel.this.processMouseMotionEvent(this.translateMouseEvent(e));
                }

                private MouseEvent translateMouseEvent(MouseEvent e) {
                    return new MouseEvent(TestCaseListPanel.this, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + this.getX(), e.getY() + this.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                }
            };
            JPanel progressPanel = UISupport.createProgressBarPanel(this.progressBar, 5, false);
            this.progressBar.setMinimumSize(new Dimension(0, 10));
            this.progressBar.setBackground(Color.WHITE);
            this.progressBar.setInheritsPopupMenu(true);
            this.label = new JLabel(testCase.getLabel());
            this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.label.setInheritsPopupMenu(true);
            this.label.setEnabled(!testCase.isDisabled());
            this.add((Component)progressPanel, "Center");
            this.add((Component)this.label, "North");
            this.testCasePropertyChangeListener = new TestCasePropertyChangeListener();
            this.initPopup(testCase);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TestCaseListPanel.this.requestFocus();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        if (JTestSuiteTestCaseList.this.selectedTestCase != null) {
                            JTestSuiteTestCaseList.this.selectedTestCase.setSelected(false);
                        }
                        TestCaseListPanel.this.setSelected(true);
                        JTestSuiteTestCaseList.this.selectedTestCase = TestCaseListPanel.this;
                        return;
                    }
                    UISupport.selectAndShow(TestCaseListPanel.this.testCase);
                }
            });
            this.addKeyListener(new TestCaseListPanelKeyHandler());
            this.setSelected(false);
        }

        public void reset() {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }

        private void initPopup(WsdlTestCase testCase) {
            ActionList actions = ActionListBuilder.buildActions(testCase);
            actions.insertAction(SwingActionDelegate.createDelegate("AddNewTestCaseAction", JTestSuiteTestCaseList.this.testSuite, null, null), 0);
            actions.insertAction(ActionSupport.SEPARATOR_ACTION, 1);
            this.setComponentPopupMenu(ActionSupport.buildPopup(actions));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.testCase.addPropertyChangeListener(this.testCasePropertyChangeListener);
            this.progressBarAdapter = new ProgressBarTestCaseAdapter(this.progressBar, this.testCase);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.progressBarAdapter != null) {
                this.testCase.removePropertyChangeListener(this.testCasePropertyChangeListener);
                this.progressBarAdapter.release();
                this.progressBarAdapter = null;
            }
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension size = super.getMaximumSize();
            size.height = 50;
            return size;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            } else {
                this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            }
        }

        public boolean isSelected() {
            return JTestSuiteTestCaseList.this.selectedTestCase != null && JTestSuiteTestCaseList.this.selectedTestCase.getTestCase() == this.testCase;
        }

        protected TestCase getTestCase() {
            return this.testCase;
        }

        public ModelItem getModelItem() {
            return this.testCase;
        }

        @Override
        public void autoscroll(Point pt) {
            int ix = JTestSuiteTestCaseList.this.getIndexOf(this);
            if (pt.getY() < 12.0 && ix > 0) {
                Rectangle bounds = JTestSuiteTestCaseList.this.getComponent(ix - 1).getBounds();
                JTestSuiteTestCaseList.this.scrollRectToVisible(bounds);
            } else if (pt.getY() > (double)(this.getHeight() - 12) && ix < JTestSuiteTestCaseList.this.testSuite.getTestCaseCount() - 1) {
                Rectangle bounds = JTestSuiteTestCaseList.this.getComponent(ix + 1).getBounds();
                JTestSuiteTestCaseList.this.scrollRectToVisible(bounds);
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.autoscrollSupport.getAutoscrollInsets();
        }

        private final class TestCasePropertyChangeListener
        implements PropertyChangeListener {
            private TestCasePropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(TestCase.LABEL_PROPERTY)) {
                    TestCaseListPanel.this.label.setEnabled(!TestCaseListPanel.this.testCase.isDisabled());
                    TestCaseListPanel.this.label.setText(TestCaseListPanel.this.testCase.getLabel());
                } else if (evt.getPropertyName().equals(TestCase.DISABLED_PROPERTY)) {
                    TestCaseListPanel.this.initPopup(TestCaseListPanel.this.testCase);
                }
            }
        }

        private final class TestCaseListPanelKeyHandler
        extends KeyAdapter {
            private TestCaseListPanelKeyHandler() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    UISupport.selectAndShow(TestCaseListPanel.this.testCase);
                    e.consume();
                } else {
                    ActionList actions = ActionListBuilder.buildActions(TestCaseListPanel.this.testCase);
                    if (actions != null) {
                        actions.dispatchKeyEvent(e);
                    }
                }
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testCaseAdded(TestCase testCase) {
            TestCaseListPanel testCaseListPanel = JTestSuiteTestCaseList.this.createTestCaseListPanel(testCase);
            JTestSuiteTestCaseList.this.panels.put(testCase, testCaseListPanel);
            JTestSuiteTestCaseList.this.add((Component)testCaseListPanel, testCase.getTestSuite().getIndexOfTestCase(testCase));
            JTestSuiteTestCaseList.this.revalidate();
            JTestSuiteTestCaseList.this.repaint();
        }

        @Override
        public void testCaseRemoved(TestCase testCase) {
            TestCaseListPanel testCaseListPanel = (TestCaseListPanel)JTestSuiteTestCaseList.this.panels.get(testCase);
            if (testCaseListPanel != null) {
                JTestSuiteTestCaseList.this.remove(testCaseListPanel);
                JTestSuiteTestCaseList.this.panels.remove(testCase);
                JTestSuiteTestCaseList.this.revalidate();
                JTestSuiteTestCaseList.this.repaint();
            }
        }

        @Override
        public void testCaseMoved(TestCase testCase, int index, int offset) {
            TestCaseListPanel testCaseListPanel = (TestCaseListPanel)JTestSuiteTestCaseList.this.panels.get(testCase);
            if (testCaseListPanel != null) {
                boolean hadFocus = testCaseListPanel.hasFocus();
                JTestSuiteTestCaseList.this.remove(testCaseListPanel);
                JTestSuiteTestCaseList.this.add((Component)testCaseListPanel, index + offset);
                JTestSuiteTestCaseList.this.revalidate();
                JTestSuiteTestCaseList.this.repaint();
                if (hadFocus) {
                    testCaseListPanel.requestFocus();
                }
            }
        }
    }

    private class TestCaseListDragAndDropable
    implements SoapUIDragAndDropable<ModelItem> {
        private final JTestSuiteTestCaseList list;

        public TestCaseListDragAndDropable(JTestSuiteTestCaseList list) {
            this.list = list;
        }

        @Override
        public JComponent getComponent() {
            return this.list;
        }

        @Override
        public Rectangle getModelItemBounds(ModelItem modelItem) {
            return this.list.getBounds();
        }

        @Override
        public ModelItem getModelItemForLocation(int x, int y) {
            int testCaseCount = JTestSuiteTestCaseList.this.testSuite.getTestCaseCount();
            return testCaseCount == 0 ? JTestSuiteTestCaseList.this.testSuite : JTestSuiteTestCaseList.this.testSuite.getTestCaseAt(testCaseCount - 1);
        }

        @Override
        public Component getRenderer(ModelItem modelItem) {
            return null;
        }

        @Override
        public void selectModelItem(ModelItem modelItem) {
        }

        @Override
        public void setDragInfo(String dropInfo) {
            this.list.setToolTipText(dropInfo);
        }

        @Override
        public void toggleExpansion(ModelItem modelItem) {
        }
    }

    private static class TestCaseListPanelDragAndDropable
    implements SoapUIDragAndDropable<ModelItem> {
        private final TestCaseListPanel testCasePanel;

        public TestCaseListPanelDragAndDropable(TestCaseListPanel testCasePanel) {
            this.testCasePanel = testCasePanel;
        }

        @Override
        public JComponent getComponent() {
            return this.testCasePanel;
        }

        @Override
        public void setDragInfo(String dropInfo) {
            this.testCasePanel.setToolTipText(dropInfo.length() == 0 ? null : dropInfo);
        }

        @Override
        public Rectangle getModelItemBounds(ModelItem path) {
            return new Rectangle(this.testCasePanel.getSize());
        }

        @Override
        public ModelItem getModelItemForLocation(int x, int y) {
            return this.testCasePanel.getModelItem();
        }

        @Override
        public Component getRenderer(ModelItem path) {
            return null;
        }

        @Override
        public void selectModelItem(ModelItem path) {
            this.testCasePanel.setSelected(!this.testCasePanel.isSelected());
        }

        @Override
        public void toggleExpansion(ModelItem last) {
        }
    }
}

