/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.support.http.HttpCredentialsProvider;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import org.apache.http.Header;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;

public class HttpAuthenticationRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        String username = PropertyExpander.expandProperties(context, wsdlRequest.getUsername());
        if (username == null || username.length() == 0) {
            return;
        }
        XmlBeansSettingsImpl settings = wsdlRequest.getSettings();
        String password = PropertyExpander.expandProperties(context, wsdlRequest.getPassword());
        String domain = PropertyExpander.expandProperties(context, wsdlRequest.getDomain());
        CredentialsConfig.AuthType.Enum authType = CredentialsConfig.AuthType.Enum.forString(wsdlRequest.getAuthType());
        String wssPasswordType = null;
        if (wsdlRequest instanceof WsdlRequest) {
            wssPasswordType = PropertyExpander.expandProperties(context, ((WsdlRequest)wsdlRequest).getWssPasswordType());
        }
        if (StringUtils.isNullOrEmpty(wssPasswordType)) {
            HttpAuthenticationRequestFilter.initRequestCredentials(context, username, settings, password, domain, authType);
        }
    }

    public static void initRequestCredentials(SubmitContext context, String username, Settings settings, String password, String domain, CredentialsConfig.AuthType.Enum authType) {
        HttpRequestBase httpMethod = (HttpRequestBase)context.getProperty("httpMethod");
        HttpContext httpContext = (HttpContext)context.getProperty("#HTTP_STATE");
        if (!StringUtils.isNullOrEmpty(username) && !StringUtils.isNullOrEmpty(password) && (((Object)((Object)authType)).equals((Object)CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS) && settings.getBoolean(HttpSettings.AUTHENTICATE_PREEMPTIVELY) || ((Object)((Object)authType)).equals((Object)CredentialsConfig.AuthType.PREEMPTIVE))) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            Header header = BasicScheme.authenticate((Credentials)creds, (String)"utf-8", (boolean)false);
            httpMethod.removeHeaders("Authorization");
            httpMethod.addHeader(header);
        }
        String requestAuthPolicy = HttpAuthenticationRequestFilter.getCorrespondingAuthPolicy(authType);
        HttpCredentialsProvider credentialsProvider = new HttpCredentialsProvider();
        credentialsProvider.loadProxyCredentialsFromSettings();
        credentialsProvider.setRequestCredentials(username, password, domain, requestAuthPolicy);
        httpContext.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
    }

    private static String getCorrespondingAuthPolicy(CredentialsConfig.AuthType.Enum authType) {
        String authPolicy = null;
        if (authType == CredentialsConfig.AuthType.NTLM) {
            authPolicy = "NTLM";
        } else if (authType == CredentialsConfig.AuthType.SPNEGO_KERBEROS) {
            authPolicy = "Negotiate";
        }
        return authPolicy;
    }
}

