/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class CompressionSupport {
    public static final String ALG_GZIP = "gzip";
    public static final String ALG_DEFLATE = "deflate";
    private static final String[] algs = new String[]{"gzip", "deflate"};

    public static String getAvailableAlgorithms(String separator) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < algs.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(algs[i]);
        }
        return buf.toString();
    }

    public static String getAvailableAlgorithm(String httpContentEncoding) {
        for (String alg : algs) {
            if (!httpContentEncoding.toLowerCase().endsWith(alg)) continue;
            return alg;
        }
        return null;
    }

    private static void checkAlg(String alg) throws Exception {
        if (!ALG_GZIP.equals(alg) && !ALG_DEFLATE.equals(alg)) {
            throw new Exception("Compression algorithm not supported: " + alg);
        }
    }

    public static byte[] compress(String alg, byte[] content) throws Exception {
        CompressionSupport.checkAlg(alg);
        if (ALG_GZIP.equals(alg)) {
            return CompressionSupport.GZIPCompress(content);
        }
        if (ALG_DEFLATE.equals(alg)) {
            return CompressionSupport.DeflaterCompress(content);
        }
        return null;
    }

    public static byte[] decompress(String alg, byte[] content) throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)new HttpVersion(1, 0), 0, null));
        ByteArrayEntity entity = new ByteArrayEntity(content);
        entity.setContentEncoding(alg);
        response.setEntity((HttpEntity)entity);
        BasicHttpContext httpContext = new BasicHttpContext();
        new ResponseContentEncoding().process((HttpResponse)response, (HttpContext)httpContext);
        return IOUtils.toByteArray((InputStream)response.getEntity().getContent());
    }

    public static InputStream createCompressionInputStream(String alg, byte[] content) throws Exception {
        CompressionSupport.checkAlg(alg);
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        if (ALG_GZIP.equals(alg)) {
            return new GZIPInputStream(bais);
        }
        if (ALG_DEFLATE.equals(alg)) {
            return new InflaterInputStream(bais);
        }
        return null;
    }

    private static byte[] GZIPCompress(byte[] requestContent) throws IOException {
        ByteArrayOutputStream compressedContent = new ByteArrayOutputStream();
        GZIPOutputStream gzipstream = new GZIPOutputStream(compressedContent);
        gzipstream.write(requestContent);
        gzipstream.finish();
        return compressedContent.toByteArray();
    }

    private static byte[] DeflaterCompress(byte[] requestContent) throws IOException {
        ByteArrayOutputStream compressedContent = new ByteArrayOutputStream();
        DeflaterOutputStream defstream = new DeflaterOutputStream(compressedContent);
        defstream.write(requestContent);
        defstream.finish();
        return compressedContent.toByteArray();
    }
}

