/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.support.MessageSupport;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDigestScheme
extends DigestScheme {
    private static final Logger logger = LoggerFactory.getLogger(FixedDigestScheme.class);
    private static final MessageSupport messages = MessageSupport.getMessages(FixedDigestScheme.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        URI originalUri = ((HttpRequestWrapper)request).getURI();
        HttpHost httphost = ((HttpRequestWrapper)request).getTarget();
        try {
            String digestUri = originalUri.toString();
            ((HttpRequestWrapper)request).setURI(URI.create(digestUri.replaceAll(httphost.toString(), "")));
            Header header = super.authenticate(credentials, request, context);
            return header;
        }
        catch (Exception ex) {
            logger.warn(messages.get("FixedDigestScheme.WarnMessage"));
            Header header = super.authenticate(credentials, request, context);
            return header;
        }
        finally {
            ((HttpRequestWrapper)request).setURI(originalUri);
        }
    }
}

