/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.Stopwatch;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.protocol.HttpContext;

class SoapUiHttpClientConnectionOperator
extends DefaultHttpClientConnectionOperator {
    private static final String HTTP_REQUEST_ATTRIBUTE = "http.request";

    public SoapUiHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        super(socketFactoryRegistry, schemePortResolver, dnsResolver);
    }

    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        HttpRequest request = (HttpRequest)context.getAttribute(HTTP_REQUEST_ATTRIBUTE);
        if (request instanceof HttpRequestWrapper) {
            request = ((HttpRequestWrapper)request).getOriginal();
        }
        if (!request.getRequestLine().getUri().contains(host.toURI())) {
            Object sslConfig = null;
            sslConfig = request.getParams().getParameter("soapui.sslConfig");
            if (sslConfig == null) {
                sslConfig = request.getParams().getParameter("testserver.sslConfig");
            }
            if (sslConfig != null) {
                context.setAttribute("soapui.layered.socket.ssl.config", (Object)sslConfig.toString());
            }
        }
        Stopwatch connectTimer = null;
        if (request instanceof ExtendedHttpMethod && ((ExtendedHttpMethod)request).getMetrics() != null) {
            connectTimer = ((ExtendedHttpMethod)request).getMetrics().getConnectTimer();
            connectTimer.start();
        }
        super.connect(conn, host, localAddress, connectTimeout, socketConfig, context);
        if (connectTimer != null) {
            connectTimer.stop();
        }
    }
}

