/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.JdbcRequestTestStepConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcRequest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.JdbcSubmit;
import com.eviware.soapui.impl.wsdl.support.JdbcMessageExchange;
import com.eviware.soapui.impl.wsdl.support.XmlBeansPropertiesTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.SamplerTestStep;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;

public class JdbcRequestTestStep
extends WsdlTestStepWithProperties
implements Assertable,
MutableTestPropertyHolder,
PropertyChangeListener,
SamplerTestStep {
    private static final Logger log = LogManager.getLogger(WsdlTestRequestStep.class);
    public static final String JDBCREQUEST = JdbcRequestTestStep.class.getName() + "@jdbcrequest";
    public static final String STATUS_PROPERTY = WsdlTestRequest.class.getName() + "@status";
    public static final String RESPONSE_PROPERTY = "response";
    protected static final String DRIVER_FIELD = "Driver";
    protected static final String CONNSTR_FIELD = "Connection String";
    protected static final String PASS_FIELD = "Password";
    public static final String PASS_TEMPLATE = "PASS_VALUE";
    public static final String QUERY_FIELD = "SQL Query";
    protected static final String STOREDPROCEDURE_FIELD = "Stored Procedure";
    protected static final String DATA_CONNECTION_FIELD = "Connection";
    protected static final String QUERY_ELEMENT = "query";
    protected static final String STOREDPROCEDURE_ELEMENT = "stored-procedure";
    private AssertionsSupport assertionsSupport;
    private PropertyChangeNotifier notifier;
    private XmlBeansPropertiesTestPropertyHolder propertyHolderSupport;
    private JdbcRequestTestStepConfig jdbcRequestTestStepConfig = ((TestStepConfig)this.getConfig()).getConfig() != null ? (JdbcRequestTestStepConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(JdbcRequestTestStepConfig.type) : (JdbcRequestTestStepConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(JdbcRequestTestStepConfig.type);
    private JdbcRequest jdbcRequest;
    private JdbcSubmit submit;

    public JdbcRequestTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (this.jdbcRequestTestStepConfig.getProperties() == null) {
            this.jdbcRequestTestStepConfig.addNewProperties();
        }
        if (!this.jdbcRequestTestStepConfig.isSetConvertColumnNamesToUpperCase()) {
            this.jdbcRequestTestStepConfig.setConvertColumnNamesToUpperCase(true);
        }
        this.jdbcRequest = new JdbcRequest(this, forLoadTest);
        this.propertyHolderSupport = new XmlBeansPropertiesTestPropertyHolder(this, this.jdbcRequestTestStepConfig.getProperties());
        this.addResponseAsXmlVirtualProperty();
        this.initAssertions();
    }

    private void addResponseAsXmlVirtualProperty() {
        TestStepBeanProperty responseProperty = new TestStepBeanProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, true, this, "responseContent", this){

            @Override
            public String getDefaultValue() {
                return "</no-response>";
            }

            @Override
            public QName getType() {
                return this.getSchemaType().getName();
            }

            @Override
            public SchemaType getSchemaType() {
                return XmlAnyTypeImpl.type;
            }
        };
        this.propertyHolderSupport.addVirtualProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, responseProperty);
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.addTestPropertyListener(listener);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.removeTestPropertyListener(listener);
    }

    public JdbcRequestTestStepConfig getJdbcRequestTestStepConfig() {
        return this.jdbcRequestTestStepConfig;
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.jdbcRequestTestStepConfig = (JdbcRequestTestStepConfig)config.getConfig().changeType(JdbcRequestTestStepConfig.type);
        this.propertyHolderSupport.resetPropertiesConfig(this.jdbcRequestTestStepConfig.getProperties());
        this.assertionsSupport.refresh();
    }

    @Override
    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        this.beforeSave();
        TestStepConfig config = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        JdbcRequestTestStep result = (JdbcRequestTestStep)targetTestCase.addTestStep(config);
        return result;
    }

    @Override
    public void release() {
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext runContext) {
        JdbcTestStepResult testStepResult = new JdbcTestStepResult(this);
        testStepResult.startTimer();
        runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
        try {
            this.submit = this.jdbcRequest.submit(runContext, false);
            JdbcResponse response = this.submit.getResponse();
            if (this.submit.getStatus() != Submit.Status.CANCELED) {
                if (this.submit.getStatus() == Submit.Status.ERROR) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage(this.submit.getError().toString());
                    this.jdbcRequest.setResponse(null);
                } else if (response == null) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage("Request is missing response");
                    this.jdbcRequest.setResponse(null);
                } else {
                    runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
                    this.jdbcRequest.setResponse(response);
                    testStepResult.setTimeTaken(response.getTimeTaken());
                    testStepResult.setSize(response.getContentLength());
                    switch (this.jdbcRequest.getAssertionStatus()) {
                        case FAILED: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                            break;
                        }
                        case VALID: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                            break;
                        }
                        case UNKNOWN: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                        }
                    }
                    testStepResult.setResponse(response, testStepResult.getStatus() != TestStepResult.TestStepStatus.FAILED);
                }
            } else {
                testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                testStepResult.addMessage("Request was canceled");
            }
            if (response != null) {
                testStepResult.setRequestContent(response.getRequestContent());
            } else {
                testStepResult.setRequestContent(this.jdbcRequest.getRequestContent());
            }
            testStepResult.stopTimer();
        }
        catch (Request.SubmitException e) {
            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            testStepResult.addMessage("SubmitException: " + e);
            testStepResult.stopTimer();
        }
        finally {
            this.submit = null;
        }
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            this.assertResponse(runContext);
            Assertable.AssertionStatus assertionStatus = this.jdbcRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int c = 0; c < this.getAssertionCount(); ++c) {
                        TestAssertion assertion = this.getAssertionAt(c);
                        AssertionError[] errors = assertion.getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage("[" + assertion.getName() + "] " + error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        if (this.isDiscardResponse() && !SoapUI.getDesktop().hasDesktopPanel(this)) {
            this.jdbcRequest.setResponse(null);
        }
        this.firePropertyValueChanged("ResponseAsXml", null, testStepResult.getResponseContentAsXml());
        return testStepResult;
    }

    @Override
    public boolean cancel() {
        if (this.submit == null) {
            return false;
        }
        this.submit.cancel();
        return true;
    }

    @Override
    public String getDefaultSourcePropertyName() {
        return "Response";
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return JdbcRequestTestStep.this.getJdbcRequestTestStepConfig().addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return JdbcRequestTestStep.this.getJdbcRequestTestStepConfig().getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                JdbcRequestTestStep.this.getJdbcRequestTestStepConfig().removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = JdbcRequestTestStep.this.getJdbcRequestTestStepConfig().insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public TestAssertion addAssertion(String assertionLabel) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(assertionLabel);
            if (assertion == null) {
                return null;
            }
            if (this.getJdbcRequest().getResponse() != null) {
                assertion.assertResponse(new JdbcMessageExchange(this, this.getJdbcRequest().getResponse()), new WsdlTestRunContext(this));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.getAssertableContent();
    }

    @Override
    public String getAssertableContent() {
        TestProperty property = this.getProperty("ResponseAsXml");
        String value = property.getValue();
        return StringUtils.hasContent(value) ? value : property.getDefaultValue();
    }

    public boolean isConvertColumnNamesToUpperCase() {
        return this.jdbcRequestTestStepConfig.getConvertColumnNamesToUpperCase();
    }

    public String getResponseContent() {
        return this.getJdbcRequest().getResponse() == null ? "" : this.getJdbcRequest().getResponse().getContentAsString();
    }

    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.assertionsSupport.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.RESPONSE;
    }

    @Override
    public TestAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if ((arg0.getPropertyName().equals(TestAssertion.CONFIGURATION_PROPERTY) || arg0.getPropertyName().equals(TestAssertion.DISABLED_PROPERTY)) && this.getJdbcRequest().getResponse() != null) {
            this.assertResponse(new WsdlTestRunContext(this));
        }
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return null;
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        return this.jdbcRequest.getAssertionStatus();
    }

    @Override
    public ImageIcon getIcon() {
        return this.jdbcRequest.getIcon();
    }

    @Override
    public Interface getInterface() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        TestAssertion assertion = this.getAssertionAt(ix);
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    public void assertResponse(SubmitContext context) {
        try {
            if (this.notifier == null) {
                this.notifier = new PropertyChangeNotifier();
            }
            JdbcMessageExchange messageExchange = new JdbcMessageExchange(this, this.getJdbcRequest().getResponse());
            if (this.getJdbcRequest().getResponse() != null) {
                for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                    assertion.assertResponse(messageExchange, context);
                }
            }
            this.notifier.notifyChange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TestProperty addProperty(String name) {
        return this.propertyHolderSupport.addProperty(name);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        return this.propertyHolderSupport.removeProperty(propertyName);
    }

    public void removeAllProperties() {
        for (String propertyName : this.propertyHolderSupport.getPropertyNames()) {
            this.propertyHolderSupport.removeProperty(propertyName);
        }
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return PropertyExpansionUtils.renameProperty(this.propertyHolderSupport.getProperty(name), newName, this.getTestCase()) != null;
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolderSupport.getProperties();
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyHolderSupport.getProperty(name);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolderSupport.getPropertyList();
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolderSupport.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolderSupport.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolderSupport.hasProperty(name);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolderSupport.setPropertyValue(name, value);
    }

    public void setPropertyValue(String name, Object value) {
        this.setPropertyValue(name, String.valueOf(value));
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.propertyHolderSupport.moveProperty(propertyName, targetIndex);
    }

    public String getDriver() {
        return this.jdbcRequestTestStepConfig.getDriver();
    }

    public void setDriver(String d) {
        String old = this.getDriver();
        this.jdbcRequestTestStepConfig.setDriver(d);
        this.notifyPropertyChanged("driver", old, d);
    }

    public String getConnectionString() {
        return this.jdbcRequestTestStepConfig.getConnectionString();
    }

    public void setConnectionString(String c) {
        String old = this.getConnectionString();
        this.jdbcRequestTestStepConfig.setConnectionString(c);
        this.notifyPropertyChanged("connectionString", old, c);
    }

    public String getQuery() {
        return this.jdbcRequestTestStepConfig.getQuery();
    }

    public void setQuery(String q) {
        String old = this.getQuery();
        this.jdbcRequestTestStepConfig.setQuery(q);
        this.notifyPropertyChanged(QUERY_ELEMENT, old, q);
    }

    public String getPassword() {
        return this.jdbcRequestTestStepConfig.getPassword();
    }

    public void setPassword(String p) {
        String old = this.getPassword();
        this.jdbcRequestTestStepConfig.setPassword(p);
        this.notifyPropertyChanged("password", old, p);
    }

    public static boolean isNeededPassword(String connStr) {
        return !StringUtils.isNullOrEmpty(connStr) ? connStr.contains(PASS_TEMPLATE) : false;
    }

    public boolean isStoredProcedure() {
        return this.jdbcRequestTestStepConfig.getStoredProcedure();
    }

    public void setStoredProcedure(boolean sp) {
        String old = this.getPassword();
        this.jdbcRequestTestStepConfig.setStoredProcedure(sp);
        this.notifyPropertyChanged("password", (Object)old, (Object)sp);
    }

    public void setConvertColumnNamesToUpperCase(boolean sp) {
        this.jdbcRequestTestStepConfig.setConvertColumnNamesToUpperCase(sp);
    }

    public JdbcRequest getJdbcRequest() {
        return this.jdbcRequest;
    }

    public String getQueryTimeout() {
        return this.jdbcRequestTestStepConfig.getQueryTimeout();
    }

    public String getMaxRows() {
        return this.jdbcRequestTestStepConfig.getMaxRows();
    }

    public String getFetchSize() {
        return this.jdbcRequestTestStepConfig.getFetchSize();
    }

    public void setQueryTimeout(String queryTimeout) {
        String old = this.getQueryTimeout();
        this.jdbcRequestTestStepConfig.setQueryTimeout(queryTimeout);
        this.notifyPropertyChanged("queryTimeout", old, queryTimeout);
    }

    public void setMaxRows(String maxRows) {
        String old = this.getMaxRows();
        this.jdbcRequestTestStepConfig.setMaxRows(maxRows);
        this.notifyPropertyChanged("maxRows", old, maxRows);
    }

    public void setFetchSize(String fetchSize) {
        String old = this.getFetchSize();
        this.jdbcRequestTestStepConfig.setFetchSize(fetchSize);
        this.notifyPropertyChanged("fetchSize", old, fetchSize);
    }

    public void setResponse(JdbcResponse response, SubmitContext context) {
        JdbcResponse oldResponse = this.jdbcRequest.getResponse();
        this.jdbcRequest.setResponse(response);
        this.notifyPropertyChanged(RESPONSE_PROPERTY, oldResponse, response);
        this.assertResponse(context);
    }

    public boolean isDiscardResponse() {
        return this.jdbcRequest.isDiscardResponse();
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.jdbcRequest.setDiscardResponse(discardResponse);
    }

    @Override
    public TestRequest getTestRequest() {
        return this.jdbcRequest;
    }

    @Override
    public TestStep getTestStep() {
        return this;
    }

    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
        super.prepare(testRunner, testRunContext);
        this.setResponse(null, testRunContext);
        for (TestAssertion assertion : this.jdbcRequest.getAssertionList()) {
            assertion.prepare(testRunner, testRunContext);
        }
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = JdbcRequestTestStep.this.getAssertionStatus();
            this.oldIcon = JdbcRequestTestStep.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = JdbcRequestTestStep.this.getAssertionStatus();
            ImageIcon newIcon = JdbcRequestTestStep.this.getIcon();
            if (this.oldStatus != newStatus) {
                JdbcRequestTestStep.this.notifyPropertyChanged(STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                JdbcRequestTestStep.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, JdbcRequestTestStep.this.getIcon());
            }
            this.oldStatus = newStatus;
            this.oldIcon = newIcon;
        }
    }
}

