/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.submit.AbstractMessageExchange;
import com.eviware.soapui.impl.wsdl.support.JdbcMessageExchange;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.RestResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.smartbear.soapui.core.Logging;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class GroovyScriptAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "GroovyScriptAssertion";
    public static final String LABEL = "Script Assertion";
    public static final String DESCRIPTION = "Runs a custom script to perform arbitrary validations. Applicable to any Property.";
    private String scriptText;
    private SoapUIScriptEngine scriptEngine;
    private JDialog dialog;
    private GroovyScriptAssertionPanel groovyScriptAssertionPanel;
    private String oldScriptText;

    public GroovyScriptAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, true, true, true, false);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.scriptText = reader.readString("scriptText", "");
        this.scriptEngine = SoapUIScriptEngineRegistry.create(this);
        this.scriptEngine.setScript(this.scriptText);
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertScript(messageExchange, context, SoapUI.ensureGroovyLog());
    }

    private String assertScript(MessageExchange messageExchange, SubmitContext context, Logger log) throws AssertionException {
        try {
            this.scriptEngine.setVariable("context", context);
            this.scriptEngine.setVariable("messageExchange", messageExchange);
            this.scriptEngine.setVariable("log", log);
            this.scriptEngine.setVariable("assertion", this);
            Object result = this.scriptEngine.run();
            String string = result == null ? null : result.toString();
            return string;
        }
        catch (Throwable e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        finally {
            this.scriptEngine.clearVariables();
        }
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertScript(messageExchange, context, SoapUI.ensureGroovyLog());
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.oldScriptText = this.scriptText;
        UISupport.showDialog(this.dialog);
        return true;
    }

    protected void buildDialog() {
        this.dialog = new JDialog(UISupport.getMainFrame(), LABEL, true);
        this.groovyScriptAssertionPanel = new GroovyScriptAssertionPanel();
        this.dialog.setContentPane(this.groovyScriptAssertionPanel);
        UISupport.initDialogActions(this.dialog, this.groovyScriptAssertionPanel.getShowOnlineHelpAction(), this.groovyScriptAssertionPanel.getDefaultButton());
        this.dialog.setSize(600, 500);
        this.dialog.setModal(true);
        this.dialog.pack();
    }

    protected GroovyScriptAssertionPanel getScriptAssertionPanel() {
        return this.groovyScriptAssertionPanel;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("scriptText", this.scriptText);
        return builder.finish();
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
        this.scriptEngine.setScript(scriptText);
        this.setConfiguration(this.createConfiguration());
    }

    @Override
    public void release() {
        super.release();
        this.scriptEngine.release();
        if (this.groovyScriptAssertionPanel != null) {
            this.groovyScriptAssertionPanel.release();
        }
    }

    protected class GroovyScriptAssertionPanel
    extends JPanel {
        private GroovyEditor editor;
        private JSplitPane mainSplit;
        private JLogList logArea;
        private RunAction runAction;
        private Logger logger;
        private JButton okButton;
        private ShowOnlineHelpAction showOnlineHelpAction;

        public GroovyScriptAssertionPanel() {
            super(new BorderLayout());
            this.runAction = new RunAction();
            this.buildUI();
            this.setPreferredSize(new Dimension(600, 440));
            this.logger = LogManager.getLogger((String)("ScriptAssertion." + this.getName()));
            this.editor.requestFocusInWindow();
        }

        public GroovyEditor getGroovyEditor() {
            return this.editor;
        }

        public void release() {
            this.editor.release();
            this.logger = null;
        }

        private void buildUI() {
            this.editor = new GroovyEditor(new ScriptStepGroovyEditorModel());
            this.logArea = new JLogList("Groovy Test Log");
            this.logArea.addLogger("ScriptAssertion." + this.getName(), true);
            this.logArea.getLogList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        return;
                    }
                    String value = GroovyScriptAssertionPanel.this.logArea.getLogList().getSelectedValue().toString();
                    if (value == null) {
                        return;
                    }
                    GroovyScriptAssertionPanel.this.editor.selectError(value);
                }
            });
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), this.editor.getBorder()));
            this.mainSplit = UISupport.createVerticalSplit(this.editor, this.logArea);
            this.mainSplit.setDividerLocation(280);
            this.mainSplit.setResizeWeight(0.8);
            this.add((Component)this.mainSplit, "Center");
            this.add((Component)this.buildToolbar(), "North");
            this.add(this.buildStatusBar(), "South");
        }

        public JButton getDefaultButton() {
            return this.okButton;
        }

        public ShowOnlineHelpAction getShowOnlineHelpAction() {
            return this.showOnlineHelpAction;
        }

        private Component buildStatusBar() {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.showOnlineHelpAction = new ShowOnlineHelpAction("/functional-testing/validating-messages/using-script-assertions.html");
            builder.addFixed((JComponent)UISupport.createToolbarButton(this.showOnlineHelpAction));
            builder.addGlue();
            this.okButton = new JButton(new OkAction());
            builder.addFixed((JComponent)this.okButton);
            builder.addRelatedGap();
            builder.addFixed((JComponent)new JButton(new CancelAction()));
            builder.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            return builder.getPanel();
        }

        private JComponent buildToolbar() {
            JXToolBar toolBar = UISupport.createToolbar();
            JButton runButton = UISupport.createToolbarButton(this.runAction);
            toolBar.add(runButton);
            toolBar.add(Box.createHorizontalGlue());
            JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code> and <code>messageExchange</code> variables</html>");
            label.setToolTipText(label.getText());
            label.setMaximumSize(label.getPreferredSize());
            toolBar.addFixed(label);
            toolBar.addSpace(3);
            return toolBar;
        }

        private class RunAction
        extends AbstractAction {
            public RunAction() {
                this.putValue("SmallIcon", UISupport.createImageIcon("/run.png"));
                this.putValue("ShortDescription", "Runs this assertion script against the last messageExchange with a mock testContext");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                TestStep testStep = GroovyScriptAssertion.this.getAssertable().getTestStep();
                AbstractMessageExchange exchange = null;
                if (testStep instanceof WsdlTestRequestStep) {
                    exchange = new WsdlResponseMessageExchange(((WsdlTestRequestStep)testStep).getTestRequest());
                } else if (testStep instanceof RestTestRequestStepInterface) {
                    exchange = new RestResponseMessageExchange((RestRequestInterface)((Object)((RestTestRequestStepInterface)testStep).getTestRequest()));
                } else if (testStep instanceof HttpTestRequestStepInterface) {
                    exchange = new HttpResponseMessageExchange((HttpRequestInterface<?>)((Object)((HttpTestRequestStepInterface)testStep).getTestRequest()));
                } else if (testStep instanceof WsdlMockResponseTestStep) {
                    exchange = new WsdlMockResponseMessageExchange(((WsdlMockResponseTestStep)testStep).getMockResponse());
                } else if (testStep instanceof JdbcRequestTestStep) {
                    JdbcRequestTestStep jdbcRequestTestStep = (JdbcRequestTestStep)testStep;
                    exchange = new JdbcMessageExchange(jdbcRequestTestStep, jdbcRequestTestStep.getJdbcRequest().getResponse());
                }
                try {
                    Logging.addAppender(GroovyScriptAssertionPanel.this.logger.getName(), Logging.getAppender("GLOBAL_GROOVY_LOG"));
                    try {
                        GroovyScriptAssertion.this.setScriptText(GroovyScriptAssertionPanel.this.editor.getEditArea().getText());
                        String result = GroovyScriptAssertion.this.assertScript(exchange, new WsdlTestRunContext(testStep), GroovyScriptAssertionPanel.this.logger);
                        UISupport.showInfoMessage("Script Assertion Passed" + (String)(result == null ? "" : ": [" + result + "]"));
                    }
                    finally {
                        Logging.removeAppender(GroovyScriptAssertionPanel.this.logger.getName(), Logging.getAppender("GLOBAL_GROOVY_LOG"));
                    }
                }
                catch (AssertionException e) {
                    UISupport.showErrorMessage(e.getMessage());
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                    UISupport.showErrorMessage(e.getMessage());
                }
                GroovyScriptAssertionPanel.this.editor.requestFocusInWindow();
            }
        }

        private class ScriptStepGroovyEditorModel
        extends AbstractGroovyEditorModel {
            public ScriptStepGroovyEditorModel() {
                super(new String[]{"log", "context", "messageExchange"}, GroovyScriptAssertion.this.getAssertable().getModelItem(), "Assertion");
            }

            @Override
            public Action getRunAction() {
                return GroovyScriptAssertionPanel.this.runAction;
            }

            @Override
            public String getScript() {
                return GroovyScriptAssertion.this.getScriptText();
            }

            @Override
            public void setScript(String text) {
            }
        }

        private final class OkAction
        extends AbstractAction {
            public OkAction() {
                super("OK");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyScriptAssertion.this.dialog.setVisible(false);
                GroovyScriptAssertion.this.setScriptText(GroovyScriptAssertionPanel.this.editor.getEditArea().getText());
            }
        }

        private final class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super("Cancel");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyScriptAssertion.this.dialog.setVisible(false);
                GroovyScriptAssertionPanel.this.editor.getEditArea().setText(GroovyScriptAssertion.this.oldScriptText);
            }
        }
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(GroovyScriptAssertion.ID, GroovyScriptAssertion.LABEL, GroovyScriptAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Script";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return GroovyScriptAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(GroovyScriptAssertion.ID, GroovyScriptAssertion.LABEL, GroovyScriptAssertion.DESCRIPTION);
        }
    }
}

