/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.jms;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import org.apache.xmlbeans.XmlObject;

public class JMSTimeoutAssertion
extends WsdlMessageAssertion
implements ResponseAssertion,
RequestAssertion {
    public static final String JMS_TIMEOUT_DURATION = "JMS timeout duration";
    private static final String JMS_TIMEOUT_SETTING = "timeout";
    public static final String JMS_TIMEOUT_OK = "JMS Timeout OK";
    private XFormDialog dialog;
    public static final String ID = "JMS Timeout";
    public static final String LABEL = "JMS Timeout";
    public static final String DESCRIPTION = "Validates that the JMS statement of the target TestStep did not take longer than the specified duration. Applicable to Request TestSteps with a JMS endpoint.";
    private long jmsTimeoutDuration;
    private static int magicUnreachableNumber = -120184;
    private static long defaultJmsAssertionTimeout = 100L;
    private LastJmsResponseResult lastJmsResponseResult = new LastJmsResponseResult();

    public JMSTimeoutAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, true, false, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.jmsTimeoutDuration = reader.readLong(JMS_TIMEOUT_SETTING, magicUnreachableNumber);
        if (this.jmsTimeoutDuration == (long)magicUnreachableNumber) {
            this.jmsTimeoutDuration = defaultJmsAssertionTimeout;
        }
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        SubmitContext propertyExpansionContext = context;
        boolean isRun = propertyExpansionContext.hasProperty("JMS_MESSAGE_RECEIVE");
        Boolean temp = (Boolean)context.getProperty("JMS_MESSAGE_RECEIVE");
        Boolean messageReceived = temp != null ? temp : false;
        if (isRun) {
            this.lastJmsResponseResult.timeTaken = messageExchange.getTimeTaken();
            this.lastJmsResponseResult.isRecieved = messageReceived;
        }
        Long timeout = this.jmsTimeoutDuration;
        String jmsTimeoutError = "JMS Message timeout error! Message is not received in " + timeout + " ms.";
        if (isRun ? messageReceived == false || this.lastJmsResponseResult.timeTaken > timeout : this.lastJmsResponseResult.timeTaken > timeout || !this.lastJmsResponseResult.isRecieved) {
            throw new AssertionException(new AssertionError(jmsTimeoutError));
        }
        return JMS_TIMEOUT_OK;
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return JMS_TIMEOUT_OK;
    }

    @Override
    public boolean configure() {
        Long newJmsTimeoutDuration;
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(JMS_TIMEOUT_DURATION, new Long(this.jmsTimeoutDuration).toString());
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1 && this.jmsTimeoutDuration != (newJmsTimeoutDuration = new Long((String)values.get(JMS_TIMEOUT_DURATION)))) {
            this.jmsTimeoutDuration = newJmsTimeoutDuration;
            this.setConfiguration(this.createConfiguration());
            return true;
        }
        return false;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(JMS_TIMEOUT_SETTING, this.jmsTimeoutDuration);
        return builder.finish();
    }

    private XFormDialog buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("JMS timeout assertion");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(JMS_TIMEOUT_DURATION, JMS_TIMEOUT_DURATION, XForm.FieldType.TEXT);
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("/jms/validating-jms-responses.html"), "Specify option", UISupport.OPTIONS_ICON);
        return this.dialog;
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    static /* synthetic */ int access$000() {
        return magicUnreachableNumber;
    }

    private class LastJmsResponseResult {
        public long timeTaken = JMSTimeoutAssertion.access$000();
        public boolean isRecieved = false;
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("JMS Timeout", "JMS Timeout", JMSTimeoutAssertion.class, WsdlRequest.class);
        }

        @Override
        public String getCategory() {
            return "JMS";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return JMSTimeoutAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("JMS Timeout", "JMS Timeout", JMSTimeoutAssertion.DESCRIPTION);
        }
    }
}

