/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.registry;

import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.config.MockResponseStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.xmlbeans.XmlObject;

public class WsdlMockResponseStepFactory
extends WsdlTestStepFactory {
    public static final String MOCKRESPONSE_TYPE = "mockresponse";
    private static XFormDialog dialog;
    private static WsdlProject project;

    public WsdlMockResponseStepFactory() {
        super(MOCKRESPONSE_TYPE, "SOAP Mock Response", "Waits for a request and returns the specified response", "/mockResponseStep.gif");
    }

    @Override
    public WsdlTestStep buildTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        return new WsdlMockResponseTestStep(testCase, config, forLoadTest);
    }

    @Override
    public TestStepConfig createNewTestStep(WsdlTestCase testCase, String name) {
        WsdlMockResponseStepFactory.ensureDialog();
        return WsdlMockResponseStepFactory.createFromDialog(testCase.getTestSuite().getProject(), name);
    }

    private static void ensureDialog() {
        if (dialog == null) {
            dialog = ADialogBuilder.buildDialog(CreateForm.class);
            dialog.getFormField("Interface").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    WsdlInterface iface = (WsdlInterface)project.getInterfaceByName(newValue);
                    dialog.setOptions("Operation", new ModelItemNames<Operation>(iface.getOperationList()).getNames());
                }
            });
            dialog.setBooleanValue("Create Response", true);
            dialog.setValue("Path", "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TestStepConfig createFromDialog(WsdlProject project, String name) {
        WsdlMockResponseStepFactory.project = project;
        try {
            Iterator<AbstractInterface<?>> iterator;
            ArrayList<Interface> interfaces = new ArrayList<Interface>();
            for (Interface interface_ : project.getInterfaces("wsdl")) {
                if (interface_.getOperationCount() <= 0) continue;
                interfaces.add(interface_);
            }
            if (interfaces.isEmpty()) {
                UISupport.showErrorMessage("Missing Interfaces/Operations to mock");
                iterator = null;
                return iterator;
            }
            dialog.setValue("Name", name);
            dialog.setOptions("Interface", new ModelItemNames(interfaces).getNames());
            dialog.setOptions("Operation", new ModelItemNames<Operation>(((Interface)interfaces.get(0)).getOperationList()).getNames());
            if (!dialog.show()) {
                iterator = null;
                return iterator;
            }
            TestStepConfig testStepConfig = TestStepConfig.Factory.newInstance();
            testStepConfig.setType(MOCKRESPONSE_TYPE);
            testStepConfig.setName(dialog.getValue("Name"));
            MockResponseStepConfig mockResponseStepConfig = MockResponseStepConfig.Factory.newInstance();
            mockResponseStepConfig.setInterface(dialog.getValue("Interface"));
            mockResponseStepConfig.setOperation(dialog.getValue("Operation"));
            mockResponseStepConfig.setPort(dialog.getIntValue("Port", 8080));
            mockResponseStepConfig.setPath(dialog.getValue("Path"));
            mockResponseStepConfig.addNewResponse();
            mockResponseStepConfig.getResponse().addNewResponseContent();
            if (dialog.getBooleanValue("Create Response")) {
                WsdlInterface iface = (WsdlInterface)project.getInterfaceByName(mockResponseStepConfig.getInterface());
                String response = iface.getOperationByName(mockResponseStepConfig.getOperation()).createResponse(project.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS));
                CompressedStringSupport.setString(mockResponseStepConfig.getResponse().getResponseContent(), response);
            }
            testStepConfig.addNewConfig().set((XmlObject)mockResponseStepConfig);
            TestStepConfig testStepConfig2 = testStepConfig;
            return testStepConfig2;
        }
        finally {
            WsdlMockResponseStepFactory.project = null;
        }
    }

    public static TestStepConfig createConfig(WsdlOperation operation, boolean interactive) {
        return WsdlMockResponseStepFactory.createConfig(operation, null, interactive);
    }

    public static TestStepConfig createConfig(WsdlRequest request, boolean interactive) {
        return WsdlMockResponseStepFactory.createConfig(request.getOperation(), request, interactive);
    }

    public static TestStepConfig createConfig(WsdlOperation operation, WsdlRequest request, boolean interactive) {
        if (interactive) {
            WsdlMockResponseStepFactory.ensureDialog();
            dialog.setValue("Interface", operation.getInterface().getName());
            dialog.setValue("Operation", operation.getName());
            dialog.setBooleanValue("Create Response", request.getResponse() == null);
            return WsdlMockResponseStepFactory.createFromDialog(operation.getInterface().getProject(), request.getName() + " Response");
        }
        TestStepConfig testStepConfig = TestStepConfig.Factory.newInstance();
        testStepConfig.setType(MOCKRESPONSE_TYPE);
        testStepConfig.setName("Mock Response");
        MockResponseStepConfig config = MockResponseStepConfig.Factory.newInstance();
        config.setInterface(operation.getInterface().getName());
        config.setOperation(operation.getName());
        MockResponseConfig response = config.addNewResponse();
        response.addNewResponseContent();
        if (request != null && request.getResponse() != null) {
            CompressedStringSupport.setString(response.getResponseContent(), request.getResponse().getContentAsString());
        }
        testStepConfig.addNewConfig().set((XmlObject)config);
        return testStepConfig;
    }

    public static TestStepConfig createNewTestStep(WsdlMockResponse mockResponse) {
        WsdlOperation operation = mockResponse.getMockOperation().getOperation();
        if (operation == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return null;
        }
        WsdlMockResponseStepFactory.ensureDialog();
        dialog.setValue("Interface", operation.getInterface().getName());
        dialog.setValue("Operation", operation.getName());
        dialog.setBooleanValue("Create Response", false);
        dialog.setIntValue("Port", mockResponse.getMockOperation().getMockService().getPort());
        dialog.setValue("Path", mockResponse.getMockOperation().getMockService().getPath());
        return WsdlMockResponseStepFactory.createFromDialog(operation.getInterface().getProject(), mockResponse.getMockOperation().getName() + " - " + mockResponse.getName());
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canAddTestStepToTestCase(WsdlTestCase testCase) {
        for (Interface iface : testCase.getTestSuite().getProject().getInterfaceList()) {
            if (!(iface instanceof WsdlInterface) || iface.getOperationCount() <= 0) continue;
            return true;
        }
        UISupport.showErrorMessage("Missing SOAP Operations to Mock in Project");
        return false;
    }

    @AForm(description="Specify options for new MockResponse step", name="New MockResponse Step", helpUrl="/Service-Mocking/mocking-soap-services.html", icon="/preferences-system.png")
    private class CreateForm {
        @AField(description="The name of the MockResponse step", name="Name", type=AField.AFieldType.STRING)
        public static final String NAME = "Name";
        @AField(description="Specifies the operation to be mocked", name="Operation", type=AField.AFieldType.ENUMERATION)
        public static final String OPERATION = "Operation";
        @AField(description="Specifies the interface containing the operation to be mocked", name="Interface", type=AField.AFieldType.ENUMERATION)
        public static final String INTERFACE = "Interface";
        @AField(description="Specifies if a mock response is to be created from the schema", name="Create Response", type=AField.AFieldType.BOOLEAN)
        public static final String CREATE_RESPONSE = "Create Response";
        @AField(description="Specifies the port to listen on", name="Port", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(description="Specifies the path to listen on", name="Path")
        public static final String PATH = "Path";

        private CreateForm() {
        }
    }
}

