/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.nodes.PropertyModelItem;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PropertyTreeNode
extends AbstractModelItemTreeNode<PropertyModelItem> {
    private boolean readOnly;
    private final TestProperty property;

    protected PropertyTreeNode(TestProperty property, ModelItem parent, TestPropertyHolder holder, SoapUITreeModel treeModel) {
        super(new PropertyModelItem(property, property.isReadOnly()), parent, treeModel);
        this.property = property;
        this.readOnly = property.isReadOnly();
    }

    public static String buildName(TestProperty property) {
        String name = property.getName();
        Object value = property.getValue();
        if (value == null) {
            value = "";
        } else {
            if (((String)value).length() > 12) {
                value = ((String)value).substring(0, 12) + "..";
            }
            value = "'" + (String)value + "'";
        }
        return name + " : " + (String)value;
    }

    @Override
    public ActionList getActions() {
        if (!this.readOnly) {
            DefaultActionList actions = new DefaultActionList();
            SetPropertyValueAction setPropertyValueAction = new SetPropertyValueAction();
            actions.addAction(setPropertyValueAction);
            actions.setDefaultAction(setPropertyValueAction);
            return actions;
        }
        return super.getActions();
    }

    private class SetPropertyValueAction
    extends AbstractAction {
        public SetPropertyValueAction() {
            super("Set Value");
            this.putValue("ShortDescription", "Prompts to set the value of this property");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = UISupport.prompt("Specify property value", "Set Value", PropertyTreeNode.this.property.getValue());
            if (StringUtils.hasContent(value)) {
                PropertyTreeNode.this.property.setValue(value);
            }
        }
    }
}

