/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.util;

import com.eviware.soapui.impl.rest.support.MediaTypeHandler;
import com.eviware.soapui.impl.rest.support.MediaTypeHandlerRegistry;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;

public class BaseResponse
implements Response {
    private StringToStringMap properties = new StringToStringMap();
    private Request request;
    private String responseContent;
    private String responseContentType;
    private String xmlContent;

    public BaseResponse(Request request, String responseContent, String responseContentType) {
        this.request = request;
        this.responseContent = responseContent;
        this.responseContentType = responseContentType;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public String getRequestContent() {
        return this.request.getRequestContent();
    }

    @Override
    public long getTimeTaken() {
        return 0L;
    }

    @Override
    public Attachment[] getAttachments() {
        return new Attachment[0];
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        return new Attachment[0];
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return new StringToStringsMap();
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return new StringToStringsMap();
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    @Override
    public byte[] getRawRequestData() {
        return this.request.getRequestContent() == null ? null : this.request.getRequestContent().getBytes();
    }

    @Override
    public byte[] getRawResponseData() {
        return this.responseContent == null ? null : this.responseContent.getBytes();
    }

    @Override
    public String getContentAsXml() {
        if (this.xmlContent == null) {
            MediaTypeHandler typeHandler = MediaTypeHandlerRegistry.getTypeHandler(this.getContentType());
            this.xmlContent = typeHandler == null ? "<xml/>" : typeHandler.createXmlRepresentation(this);
        }
        return this.xmlContent;
    }

    @Override
    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.getKeys();
    }

    @Override
    public String getContentAsString() {
        return this.getRequestContent();
    }

    @Override
    public String getContentType() {
        return this.responseContentType;
    }

    @Override
    public long getContentLength() {
        return this.responseContent == null ? 0L : (long)this.responseContent.length();
    }
}

