/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins.auto.factories;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.plugins.PluginProxies;
import com.eviware.soapui.plugins.auto.PluginRequestInspector;
import com.eviware.soapui.plugins.auto.factories.AbstractSoapUIFactory;
import com.eviware.soapui.support.components.Inspector;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.registry.InspectorFactory;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class AutoRequestInspectorFactory
extends AbstractSoapUIFactory<EditorInspector<?>>
implements RequestInspectorFactory {
    private final Class<? extends ModelItem> targetClass;
    private String inspectorId;
    private Class<Inspector> inspectorClass;

    public AutoRequestInspectorFactory(PluginRequestInspector annotation, Class<Inspector> inspectorClass) {
        super(InspectorFactory.class);
        this.inspectorClass = inspectorClass;
        this.targetClass = annotation.targetClass();
        this.inspectorId = annotation.inspectorId();
    }

    @Override
    public String getInspectorId() {
        return this.inspectorId;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        block5: {
            try {
                if (!this.targetClass.isAssignableFrom(modelItem.getClass())) break block5;
                try {
                    Object applies;
                    Method appliesMethod = this.inspectorClass.getMethod("applies", this.targetClass);
                    if (appliesMethod != null && !Boolean.valueOf(String.valueOf(applies = appliesMethod.invoke(null, modelItem))).booleanValue()) {
                        return null;
                    }
                }
                catch (NoSuchMethodException appliesMethod) {
                    // empty catch block
                }
                Constructor<Inspector> constructor = this.inspectorClass.getConstructor(Editor.class, this.targetClass);
                EditorInspector inspectorToReturn = (EditorInspector)constructor.newInstance(editor, modelItem);
                return PluginProxies.proxyIfApplicable(inspectorToReturn);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return null;
    }
}

