/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.report;

import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.testsuite.ProjectRunContext;
import com.eviware.soapui.model.testsuite.ProjectRunListener;
import com.eviware.soapui.model.testsuite.ProjectRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.report.JUnitReport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JUnitReportCollector
implements TestRunListener,
TestSuiteRunListener,
ProjectRunListener {
    HashMap<String, JUnitReport> reports;
    HashMap<TestCase, String> failures;
    HashMap<TestCase, Integer> errorCount;
    protected boolean includeTestPropertiesInReport = false;
    private int maxErrors = 0;

    public JUnitReportCollector() {
        this(0);
    }

    public JUnitReportCollector(int maxErrors) {
        this.maxErrors = maxErrors;
        this.reports = new HashMap();
        this.errorCount = new HashMap();
        this.failures = new HashMap();
    }

    public List<String> saveReports(String path) throws Exception {
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.reports.keySet()) {
            JUnitReport report = this.reports.get(name);
            String fileName = path + File.separatorChar + "TEST-" + StringUtils.createFileName(name, '_') + ".xml";
            this.saveReport(report, fileName);
            result.add(fileName);
        }
        return result;
    }

    public HashMap<String, JUnitReport> getReports() {
        return this.reports;
    }

    public void saveReport(JUnitReport report, String filename) throws Exception {
        report.save(new File(filename));
    }

    public String getReport() {
        Set<String> keys = this.reports.keySet();
        if (keys.size() > 0) {
            String key = (String)keys.toArray()[0];
            return this.reports.get(key).toString();
        }
        return "No reports..:";
    }

    @Override
    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        TestCase testCase = testRunner.getTestCase();
        JUnitReport report = this.reports.get(testCase.getTestSuite().getName());
        HashMap<String, String> testProperties = this.getTestPropertiesAsHashMap(testCase);
        if (TestRunner.Status.INITIALIZED != testRunner.getStatus() && TestRunner.Status.RUNNING != testRunner.getStatus()) {
            if (TestRunner.Status.CANCELED == testRunner.getStatus()) {
                report.addTestCase(testCase.getName(), testRunner.getTimeTaken(), testProperties);
            }
            if (TestRunner.Status.FAILED == testRunner.getStatus()) {
                String msg = "";
                if (this.failures.containsKey(testCase)) {
                    msg = this.failures.get(testCase).toString();
                }
                report.addTestCaseWithFailure(testCase.getName(), testRunner.getTimeTaken(), testRunner.getReason(), msg, testProperties);
            }
            if (TestRunner.Status.FINISHED == testRunner.getStatus()) {
                report.addTestCase(testCase.getName(), testRunner.getTimeTaken(), testProperties);
            }
        }
    }

    protected HashMap<String, String> getTestPropertiesAsHashMap(TestModelItem testCase) {
        HashMap<String, String> testProperties = new HashMap<String, String>();
        for (Map.Entry<String, TestProperty> stringTestPropertyEntry : testCase.getProperties().entrySet()) {
            testProperties.put(stringTestPropertyEntry.getKey(), stringTestPropertyEntry.getValue().getValue());
        }
        return testProperties;
    }

    @Override
    public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
        TestStep currentStep = result.getTestStep();
        TestCase testCase = currentStep.getTestCase();
        if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
            if (this.maxErrors > 0) {
                Integer errors = this.errorCount.get(testCase);
                if (errors == null) {
                    errors = 0;
                }
                if (errors >= this.maxErrors) {
                    return;
                }
                this.errorCount.put(testCase, errors + 1);
            }
            StringBuffer buf = new StringBuffer();
            if (this.failures.containsKey(testCase)) {
                buf.append(this.failures.get(testCase));
            }
            buf.append("<h3><b>").append(XmlUtils.entitize(result.getTestStep().getName())).append(" Failed</b></h3><pre>");
            for (String message : result.getMessages()) {
                if (message.toLowerCase().startsWith("url:")) {
                    String url = XmlUtils.entitize(message.substring(4).trim());
                    buf.append("URL: <a target=\"new\" href=\"").append(url).append("\">").append(url).append("</a>");
                } else {
                    buf.append(message);
                }
                buf.append("\r\n");
            }
            if (testRunner.getTestCase().getSettings().getBoolean("Complete Error Logs")) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                result.writeTo(writer);
                buf.append(XmlUtils.entitize(stringWriter.toString()));
            }
            buf.append("</pre><hr/>");
            this.failures.put(testCase, buf.toString());
        }
    }

    @Override
    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        TestCase testCase = testRunner.getTestCase();
        TestSuite testSuite = testCase.getTestSuite();
        if (!this.reports.containsKey(testSuite.getName())) {
            JUnitReport report = new JUnitReport();
            report.setIncludeTestProperties(this.includeTestPropertiesInReport);
            report.setTestSuiteName(testSuite.getProject().getName() + "." + testSuite.getName());
            this.reports.put(testSuite.getName(), report);
        }
    }

    @Override
    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    @Override
    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
    }

    public void reset() {
        this.reports.clear();
        this.failures.clear();
        this.errorCount.clear();
    }

    @Override
    public void afterRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
    }

    @Override
    public void afterTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCaseRunner testCaseRunner) {
        testCaseRunner.getTestCase().removeTestRunListener(this);
    }

    @Override
    public void beforeRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
    }

    @Override
    public void beforeTestCase(TestSuiteRunner testRunner, TestSuiteRunContext runContext, TestCase testCase) {
        testCase.addTestRunListener(this);
    }

    @Override
    public void afterRun(ProjectRunner testScenarioRunner, ProjectRunContext runContext) {
    }

    @Override
    public void afterTestSuite(ProjectRunner testScenarioRunner, ProjectRunContext runContext, TestSuiteRunner testRunner) {
        testRunner.getTestSuite().removeTestSuiteRunListener(this);
    }

    @Override
    public void beforeRun(ProjectRunner testScenarioRunner, ProjectRunContext runContext) {
    }

    @Override
    public void beforeTestSuite(ProjectRunner testScenarioRunner, ProjectRunContext runContext, TestSuite testSuite) {
        testSuite.addTestSuiteRunListener(this);
    }

    public static JUnitReportCollector createNew(int maxErrors) {
        String className = System.getProperty("soapui.junit.reportCollector", null);
        if (StringUtils.hasContent(className)) {
            try {
                return (JUnitReportCollector)Class.forName(className).getConstructor(Integer.class).newInstance(maxErrors);
            }
            catch (Exception e) {
                System.err.println("Failed to create JUnitReportCollector class [" + className + "]; " + e.toString());
            }
        }
        return new JUnitReportCollector(maxErrors);
    }

    public void setIncludeTestPropertiesInReport(boolean includeTestPropertiesInReport) {
        this.includeTestPropertiesInReport = includeTestPropertiesInReport;
    }
}

