/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.result;

import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class SecurityScanResult
implements SecurityResult {
    public static final String TYPE = "SecurityScanResult";
    private SecurityResult.ResultStatus status;
    public SecurityScan securityCheck;
    private long size;
    private boolean discarded;
    private List<SecurityScanRequestResult> securityRequestResultList;
    private long timeTaken = 0L;
    private long timeStamp;
    public StringBuffer testLog = new StringBuffer();
    private DefaultActionList actionList;
    private boolean hasAddedRequests;
    private boolean hasRequestsWithWarnings;
    private SecurityResult.ResultStatus executionProgressStatus;
    private SecurityResult.ResultStatus logIconStatus;
    private int requestCount = 0;
    public static final int MAX_REQ_LOG_ENTRY_LENGTH = 100;
    public static final int MAX_SECURITY_CHANGED_PARAMETERS_LENGTH = 100;

    public SecurityScanResult(SecurityScan securityCheck) {
        this.securityCheck = securityCheck;
        this.status = SecurityResult.ResultStatus.INITIALIZED;
        this.executionProgressStatus = SecurityResult.ResultStatus.INITIALIZED;
        this.logIconStatus = SecurityResult.ResultStatus.UNKNOWN;
        this.securityRequestResultList = new ArrayList<SecurityScanRequestResult>();
        this.timeStamp = System.currentTimeMillis();
        this.requestCount = 0;
    }

    public List<SecurityScanRequestResult> getSecurityRequestResultList() {
        return this.securityRequestResultList;
    }

    @Override
    public SecurityResult.ResultStatus getStatus() {
        return this.status;
    }

    public void setStatus(SecurityResult.ResultStatus status) {
        this.status = status;
    }

    public SecurityScan getSecurityScan() {
        return this.securityCheck;
    }

    @Override
    public ActionList getActions() {
        if (this.actionList == null) {
            this.actionList = new DefaultActionList(this.getSecurityScan().getName());
            this.actionList.setDefaultAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UISupport.showInfoMessage("Scan [" + SecurityScanResult.this.getSecurityScan().getName() + "] ran with status [" + SecurityScanResult.this.getExecutionProgressStatus() + "]", "SecurityScan Result");
                }
            });
        }
        return this.actionList;
    }

    public void addSecurityRequestResult(SecurityScanRequestResult secReqResult) {
        if (this.securityRequestResultList != null) {
            this.securityRequestResultList.add(secReqResult);
        }
        this.timeTaken += secReqResult.getTimeTaken();
        ++this.requestCount;
        if (!this.hasAddedRequests) {
            this.status = SecurityResult.ResultStatus.UNKNOWN;
            if (secReqResult.getStatus() == SecurityResult.ResultStatus.OK) {
                this.status = SecurityResult.ResultStatus.OK;
            } else if (secReqResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                this.hasRequestsWithWarnings = true;
                this.status = SecurityResult.ResultStatus.FAILED;
            }
        } else if (secReqResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
            this.hasRequestsWithWarnings = true;
            this.status = SecurityResult.ResultStatus.FAILED;
        } else if (secReqResult.getStatus() == SecurityResult.ResultStatus.OK && this.status != SecurityResult.ResultStatus.FAILED) {
            this.status = SecurityResult.ResultStatus.OK;
        }
        this.logIconStatus = this.status;
        this.executionProgressStatus = this.status;
        this.testLog.append("\n").append(secReqResult.getChangedParamsInfo(this.requestCount));
        for (String s : secReqResult.getMessages()) {
            if (s.length() > 100) {
                s = s.substring(0, 100);
            }
            this.testLog.append("\n -> ").append(s);
        }
        this.hasAddedRequests = true;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getSize() {
        return this.size;
    }

    public void writeTo(PrintWriter writer) {
    }

    public void discard() {
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSecurityTestLog() {
        StringBuffer tl = new StringBuffer().append("\nSecurityScan ").append(" [").append(this.securityCheck.getName()).append("] ").append(this.executionProgressStatus.toString()).append(": took ").append(this.timeTaken).append(" ms");
        tl.append(this.testLog);
        return tl.toString();
    }

    @Override
    public String getResultType() {
        return TYPE;
    }

    public boolean isCanceled() {
        return this.status == SecurityResult.ResultStatus.CANCELED;
    }

    public boolean isHasRequestsWithWarnings() {
        return this.hasRequestsWithWarnings;
    }

    @Override
    public SecurityResult.ResultStatus getExecutionProgressStatus() {
        return this.executionProgressStatus;
    }

    public void setExecutionProgressStatus(SecurityResult.ResultStatus status) {
        this.executionProgressStatus = status;
    }

    public void detectMissingItems() {
        SecurityScan securityCheck = this.getSecurityScan();
        if (this.getStatus().equals((Object)SecurityResult.ResultStatus.SKIPPED)) {
            this.executionProgressStatus = SecurityResult.ResultStatus.SKIPPED;
        }
        if (securityCheck instanceof AbstractSecurityScanWithProperties && ((AbstractSecurityScanWithProperties)securityCheck).getParameterHolder().getParameterList().size() == 0) {
            this.logIconStatus = SecurityResult.ResultStatus.MISSING_PARAMETERS;
            this.executionProgressStatus = SecurityResult.ResultStatus.MISSING_PARAMETERS;
        }
        if (securityCheck.getAssertionCount() == 0) {
            this.logIconStatus = SecurityResult.ResultStatus.MISSING_ASSERTIONS;
            this.executionProgressStatus = SecurityResult.ResultStatus.MISSING_ASSERTIONS;
        }
        if (this.getStatus().equals((Object)SecurityResult.ResultStatus.CANCELED)) {
            this.executionProgressStatus = SecurityResult.ResultStatus.CANCELED;
        }
    }

    @Override
    public SecurityResult.ResultStatus getLogIconStatus() {
        return this.logIconStatus;
    }

    public String getSecurityScanName() {
        return this.getSecurityScan().getName();
    }

    public String getLogIconStatusString() {
        return this.logIconStatus.toString();
    }

    public String getStatusString() {
        return this.status.toString();
    }

    public void release() {
        if (this.securityRequestResultList != null) {
            this.securityRequestResultList.clear();
        }
        this.securityCheck = null;
    }
}

