/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.config.FuzzerScanConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.ui.FuzzerScanAdvancedConfigPanel;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.x.impl.swing.JFormDialog;
import javax.swing.JComponent;
import org.apache.commons.lang.RandomStringUtils;

public class FuzzerSecurityScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "FuzzingScan";
    public static final String NAME = "Fuzzing Scan";
    public static final int DEFAULT_MINIMAL = 5;
    public static final int DEFAULT_MAXIMAL = 15;
    public static final int DEFAULT_NUMBER_OF_REQUESTS = 100;
    private JFormDialog dialog;
    private FuzzerScanConfig fuzzerScanConfig;
    private Integer numberOfRequests;
    private int minimal;
    private int maximal;

    public FuzzerSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null || !(config.getConfig() instanceof FuzzerScanConfig)) {
            this.initConfig();
        } else {
            this.fuzzerScanConfig = (FuzzerScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
        this.getExecutionStrategy().setStrategy(StrategyTypeConfig.ALL_AT_ONCE);
        this.getExecutionStrategy().setImmutable(true);
    }

    private void initConfig() {
        ((SecurityScanConfig)this.getConfig()).setConfig(FuzzerScanConfig.Factory.newInstance());
        this.fuzzerScanConfig = (FuzzerScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        this.fuzzerScanConfig.setMinimal(5);
        this.fuzzerScanConfig.setMaximal(15);
        this.fuzzerScanConfig.setNumberOfRequest(100);
    }

    @Override
    protected void execute(SecurityTestRunner runner, TestStep testStep, SecurityTestRunContext context) {
        StringToStringMap parameters = new StringToStringMap();
        XmlObjectTreeModel model = null;
        for (SecurityCheckedParameter scp : this.getParameterHolder().getParameterList()) {
            if (scp.isChecked()) {
                if (scp.getXpath().trim().length() > 0) {
                    model = SecurityScanUtil.getXmlObjectTreeModel(testStep, scp);
                    XmlObjectTreeModel.XmlTreeNode[] treeNodes = null;
                    treeNodes = model.selectTreeNodes(context.expand(scp.getXpath()));
                    if (treeNodes.length > 0) {
                        XmlObjectTreeModel.XmlTreeNode mynode = treeNodes[0];
                        String fuzzed = this.fuzzedValue();
                        mynode.setValue(1, fuzzed);
                        parameters.put(scp.getLabel(), fuzzed);
                    }
                    this.updateRequestProperty(testStep, scp.getName(), model.getXmlObject().toString());
                } else {
                    String fuzzed = this.fuzzedValue();
                    parameters.put(scp.getLabel(), fuzzed);
                    this.updateRequestProperty(testStep, scp.getName(), fuzzed);
                }
            }
            MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)runner), context));
            this.createMessageExchange(parameters, message, context);
        }
    }

    private String fuzzedValue() {
        int count = (int)(Math.random() * (double)(this.maximal + 1 - this.minimal)) + this.minimal;
        return RandomStringUtils.randomAlphanumeric((int)count);
    }

    private void updateRequestProperty(TestStep testStep, String propertyName, String propertyValue) {
        testStep.getProperty(propertyName).setValue(propertyValue);
    }

    @Override
    protected boolean hasNext(TestStep testStep2, SecurityTestRunContext context) {
        if (this.numberOfRequests == null) {
            this.numberOfRequests = this.fuzzerScanConfig.getNumberOfRequest();
            this.minimal = this.fuzzerScanConfig.getMinimal();
            this.maximal = this.fuzzerScanConfig.getMaximal();
        }
        if (this.numberOfRequests > 0) {
            Integer n = this.numberOfRequests;
            this.numberOfRequests = this.numberOfRequests - 1;
            return true;
        }
        this.numberOfRequests = null;
        return false;
    }

    @Override
    public JComponent getAdvancedSettingsPanel() {
        FuzzerScanAdvancedConfigPanel configPanel = new FuzzerScanAdvancedConfigPanel(this.fuzzerScanConfig);
        this.dialog = configPanel.getDialog();
        return this.dialog.getPanel();
    }

    @Override
    public void release() {
        if (this.dialog != null) {
            this.dialog.release();
        }
        super.release();
    }

    @Override
    public String getConfigDescription() {
        return "Configuration for Fuzzing Security Scan";
    }

    @Override
    public String getConfigName() {
        return "Configuration for Fuzzing Security Scan";
    }

    @Override
    public String getHelpURL() {
        return "/Security/security-scans-overview.html";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void clear() {
        this.numberOfRequests = null;
    }
}

