/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MaliciousAttachmentConfig;
import com.eviware.soapui.config.MaliciousAttachmentElementConfig;
import com.eviware.soapui.config.MaliciousAttachmentSecurityScanConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.AttachmentContainer;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import com.eviware.soapui.security.tools.RandomFile;
import com.eviware.soapui.security.ui.MaliciousAttachmentAdvancedSettingsPanel;
import com.eviware.soapui.security.ui.MaliciousAttachmentMutationsPanel;
import com.eviware.soapui.support.UISupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MaliciousAttachmentSecurityScan
extends AbstractSecurityScan
implements PropertyChangeListener {
    public static final String TYPE = "MaliciousAttachmentSecurityScan";
    public static final String NAME = "Malicious Attachment";
    private MaliciousAttachmentSecurityScanConfig config;
    private MaliciousAttachmentAdvancedSettingsPanel advancedSettingsPanel;
    private MaliciousAttachmentMutationsPanel mutationsPanel;
    private int elementIndex = -1;
    private int valueIndex = -1;
    private AbstractHttpRequest<?> request;

    public MaliciousAttachmentSecurityScan(TestStep testStep, SecurityScanConfig newConfig, ModelItem parent, String icon) {
        super(testStep, newConfig, parent, icon);
        if (newConfig.getConfig() == null || !(newConfig.getConfig() instanceof MaliciousAttachmentSecurityScanConfig)) {
            this.initConfig();
        } else {
            this.config = (MaliciousAttachmentSecurityScanConfig)newConfig.getConfig();
        }
        this.request = (AbstractHttpRequest)((Object)this.getRequest(testStep));
        this.request.addAttachmentsChangeListener(this);
    }

    protected void initConfig() {
        ((SecurityScanConfig)this.getConfig()).setConfig(MaliciousAttachmentSecurityScanConfig.Factory.newInstance());
        this.config = (MaliciousAttachmentSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
    }

    private void generateFiles() {
        if (this.config != null) {
            for (MaliciousAttachmentElementConfig element : this.config.getElementList()) {
                for (MaliciousAttachmentConfig value : element.getGenerateAttachmentList()) {
                    File file = new File(value.getFilename());
                    try {
                        if (file.exists() && file.length() != 0L) continue;
                        file = new RandomFile(value.getSize(), value.getFilename(), value.getContentType()).next();
                    }
                    catch (IOException e) {
                        SoapUI.logError(e);
                    }
                }
            }
        }
    }

    @Override
    public void updateSecurityConfig(SecurityScanConfig config) {
        super.updateSecurityConfig(config);
        if (this.config != null) {
            this.config = (MaliciousAttachmentSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
        if (this.advancedSettingsPanel != null) {
            this.advancedSettingsPanel.setConfig((MaliciousAttachmentSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig());
        }
        if (this.mutationsPanel != null) {
            this.mutationsPanel.updateConfig((MaliciousAttachmentSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig());
        }
    }

    public MaliciousAttachmentSecurityScanConfig getMaliciousAttachmentSecurityScanConfig() {
        return this.config;
    }

    private void updateRequestContent(TestStep testStep, SecurityTestRunContext context) {
        if (this.config.getRequestTimeout() > 0) {
            this.setRequestTimeout(testStep, this.config.getRequestTimeout());
        }
        if (this.getExecutionStrategy().getStrategy() == StrategyTypeConfig.ONE_BY_ONE) {
            if (this.elementIndex == -1) {
                ++this.elementIndex;
            }
            if (this.elementIndex < this.config.getElementList().size()) {
                MaliciousAttachmentElementConfig element = this.config.getElementList().get(this.elementIndex);
                this.removeAttachments(testStep, element.getKey(), false);
                if (element.getRemove()) {
                    this.removeAttachments(testStep, element.getKey(), true);
                }
                if (this.valueIndex < element.getGenerateAttachmentList().size() + element.getReplaceAttachmentList().size() - 1) {
                    ++this.valueIndex;
                    this.addAttachments(testStep, element, this.valueIndex);
                }
                if (this.valueIndex == element.getGenerateAttachmentList().size() + element.getReplaceAttachmentList().size() - 1) {
                    this.valueIndex = -1;
                    ++this.elementIndex;
                }
            }
        } else if (this.getExecutionStrategy().getStrategy() == StrategyTypeConfig.ALL_AT_ONCE) {
            if (this.elementIndex == -1) {
                ++this.elementIndex;
            }
            this.executeAllAtOnce(testStep);
            ++this.valueIndex;
        }
    }

    private void executeAllAtOnce(TestStep testStep) {
        for (MaliciousAttachmentElementConfig element : this.config.getElementList()) {
            int valIndex;
            if (element.getRemove()) {
                this.removeAttachments(testStep, element.getKey(), true);
            }
            if ((valIndex = this.valueIndex) < element.getGenerateAttachmentList().size() + element.getReplaceAttachmentList().size() - 1) {
                this.addAttachments(testStep, element, ++valIndex);
            }
            if (valIndex + 1 <= element.getGenerateAttachmentList().size() + element.getReplaceAttachmentList().size() - 1) continue;
            ++this.elementIndex;
        }
    }

    private void addAttachments(TestStep testStep, MaliciousAttachmentElementConfig element, int counter) {
        if (counter == -1) {
            return;
        }
        boolean generated = false;
        List<MaliciousAttachmentConfig> list = null;
        if (counter < element.getGenerateAttachmentList().size()) {
            generated = true;
            list = element.getGenerateAttachmentList();
        } else {
            list = element.getReplaceAttachmentList();
            counter -= element.getGenerateAttachmentList().size();
        }
        MaliciousAttachmentConfig value = list.get(counter);
        File file = new File(value.getFilename());
        if (value.getEnabled()) {
            try {
                if (!file.exists()) {
                    UISupport.showErrorMessage("Missing file: " + file.getName());
                    return;
                }
                this.addAttachment(testStep, file, value.getContentType(), generated, value.getCached());
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }
    }

    @Override
    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        try {
            this.request.removeAttachmentsChangeListener(this);
            this.generateFiles();
            this.updateRequestContent(testStep, context);
            MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)securityTestRunner), context));
            this.getSecurityScanRequestResult().setMessageExchange(message);
            this.request.addAttachmentsChangeListener(this);
        }
        catch (Exception e) {
            SoapUI.logError(e, "[MaliciousAttachmentSecurityScan]Property value is not valid xml!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Attachment addAttachment(TestStep testStep, File file, String contentType, boolean generated, boolean cache) throws IOException {
        AbstractHttpRequest request = (AbstractHttpRequest)((Object)this.getRequest(testStep));
        Attachment attach = request.attachFile(file, cache);
        attach.setContentType(contentType);
        return attach;
    }

    private void removeAttachments(TestStep testStep, String key, boolean equals) {
        ArrayList<Attachment> toRemove = new ArrayList<Attachment>();
        AbstractHttpRequest request = (AbstractHttpRequest)((Object)this.getRequest(testStep));
        for (Attachment attachment : request.getAttachments()) {
            if (equals) {
                if (!attachment.getId().equals(key)) continue;
                toRemove.add(attachment);
                continue;
            }
            if (attachment.getId().equals(key)) continue;
            toRemove.add(attachment);
        }
        for (Attachment remove : toRemove) {
            request.removeAttachment(remove);
        }
    }

    private void setRequestTimeout(TestStep testStep, int timeout) {
        AbstractHttpRequest request = (AbstractHttpRequest)((Object)this.getRequest(testStep));
        request.setTimeout(String.valueOf(timeout));
    }

    @Override
    public JComponent getComponent() {
        if (this.mutationsPanel == null) {
            this.mutationsPanel = new MaliciousAttachmentMutationsPanel(this.config, (AbstractHttpRequest)((Object)this.getRequest(this.getTestStep())));
        }
        return this.mutationsPanel.getPanel();
    }

    @Override
    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        boolean hasNext;
        AbstractHttpRequest request = (AbstractHttpRequest)((Object)this.getRequest(testStep));
        boolean bl = request.getAttachmentCount() == 0 ? false : (hasNext = this.elementIndex < this.config.getElementList().size());
        if (!hasNext) {
            this.elementIndex = -1;
            this.valueIndex = -1;
        }
        return hasNext;
    }

    @Override
    public String getConfigDescription() {
        return "Configures malicious attachment security scan";
    }

    @Override
    public String getConfigName() {
        return "Malicious Attachment Security Scan";
    }

    @Override
    public String getHelpURL() {
        return "http://soapui.org/Security/malicious-attachment.html";
    }

    @Override
    public JComponent getAdvancedSettingsPanel() {
        if (this.advancedSettingsPanel == null) {
            this.advancedSettingsPanel = new MaliciousAttachmentAdvancedSettingsPanel(this.config);
        }
        return this.advancedSettingsPanel.getPanel();
    }

    @Override
    public void copyConfig(SecurityScanConfig config) {
        super.copyConfig(config);
        if (this.advancedSettingsPanel != null) {
            this.advancedSettingsPanel.setConfig((MaliciousAttachmentSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig());
        }
        if (this.mutationsPanel != null) {
            this.mutationsPanel.updateConfig((MaliciousAttachmentSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig());
        }
    }

    @Override
    public void release() {
        if (this.advancedSettingsPanel != null) {
            this.advancedSettingsPanel.release();
        }
        if (this.mutationsPanel != null) {
            this.mutationsPanel.release();
        }
        if (this.request != null) {
            this.request.removeAttachmentsChangeListener(this);
        }
        super.release();
    }

    private void addedAttachment(Attachment attachment) {
        if (this.config != null) {
            MaliciousAttachmentElementConfig element = this.config.addNewElement();
            element.setKey(attachment.getId());
        }
    }

    private void removedAttachment(Attachment attachment) {
        if (this.config != null) {
            int idx = -1;
            for (int i = 0; i < this.config.getElementList().size(); ++i) {
                MaliciousAttachmentElementConfig element = this.config.getElementList().get(i);
                if (!attachment.getId().equals(element.getKey())) continue;
                idx = i;
                break;
            }
            if (idx != -1) {
                this.config.removeElement(idx);
            }
        }
        if (this.mutationsPanel != null) {
            this.mutationsPanel.getHolder().removeAttachment(attachment.getId());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (AttachmentContainer.ATTACHMENTS_PROPERTY.equals(evt.getPropertyName())) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                if (evt.getNewValue() instanceof Attachment) {
                    Attachment attachment = (Attachment)evt.getNewValue();
                    this.addedAttachment(attachment);
                }
            } else if (evt.getOldValue() != null && evt.getNewValue() == null && evt.getOldValue() instanceof Attachment) {
                Attachment attachment = (Attachment)evt.getOldValue();
                this.removedAttachment(attachment);
            }
        }
    }
}

