/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.support;

import com.eviware.soapui.config.MaliciousAttachmentConfig;
import com.eviware.soapui.security.support.MaliciousAttachmentFilesListForm;
import com.eviware.soapui.security.support.MaliciousAttachmentTableModel;
import com.eviware.soapui.security.tools.AttachmentElement;
import com.eviware.x.impl.swing.JFormDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaliciousAttachmentListToTableHolder {
    MaliciousAttachmentFilesListForm filesList;
    MaliciousAttachmentTableModel generateTableModel;
    MaliciousAttachmentTableModel replaceTableModel;
    JFormDialog tablesDialog;
    Map<String, List<MaliciousAttachmentConfig>> generateMap = new HashMap<String, List<MaliciousAttachmentConfig>>();
    Map<String, List<MaliciousAttachmentConfig>> replaceMap = new HashMap<String, List<MaliciousAttachmentConfig>>();
    Map<String, Boolean> removeMap = new HashMap<String, Boolean>();

    public JFormDialog getTablesDialog() {
        return this.tablesDialog;
    }

    public void setTablesDialog(JFormDialog tablesDialog) {
        this.tablesDialog = tablesDialog;
    }

    public MaliciousAttachmentFilesListForm getFilesList() {
        return this.filesList;
    }

    public void setFilesList(MaliciousAttachmentFilesListForm filesList) {
        this.filesList = filesList;
    }

    public MaliciousAttachmentTableModel getGenerateTableModel() {
        return this.generateTableModel;
    }

    public void setGenerateTableModel(MaliciousAttachmentTableModel generateTableModel) {
        this.generateTableModel = generateTableModel;
    }

    public MaliciousAttachmentTableModel getReplaceTableModel() {
        return this.replaceTableModel;
    }

    public void setReplaceTableModel(MaliciousAttachmentTableModel replaceTableModel) {
        this.replaceTableModel = replaceTableModel;
    }

    public void refresh() {
        AttachmentElement item;
        if (this.filesList != null && (item = this.filesList.getFirstItem()) != null) {
            this.load(item);
        }
    }

    public void refresh(AttachmentElement oldItem, AttachmentElement newItem) {
        if (oldItem != null) {
            this.save(oldItem);
            if (newItem != null) {
                this.load(newItem);
            }
        }
    }

    public void addResultToGenerateTable(MaliciousAttachmentConfig config) {
        this.generateTableModel.addResult(config);
    }

    public void addResultToReplaceTable(MaliciousAttachmentConfig config) {
        this.replaceTableModel.addResult(config);
    }

    private void save(AttachmentElement item) {
        int i;
        ArrayList<MaliciousAttachmentConfig> generateList = new ArrayList<MaliciousAttachmentConfig>();
        ArrayList<MaliciousAttachmentConfig> replaceList = new ArrayList<MaliciousAttachmentConfig>();
        for (i = 0; i < this.generateTableModel.getRowCount(); ++i) {
            generateList.add(this.generateTableModel.getRowValue(i));
        }
        for (i = 0; i < this.replaceTableModel.getRowCount(); ++i) {
            replaceList.add(this.replaceTableModel.getRowValue(i));
        }
        Boolean remove = this.tablesDialog.getBooleanValue("Remove");
        this.generateMap.put(item.getId(), generateList);
        this.replaceMap.put(item.getId(), replaceList);
        this.removeMap.put(item.getId(), remove);
    }

    private void load(AttachmentElement item) {
        List<MaliciousAttachmentConfig> generateList = this.generateMap.get(item.getId());
        List<MaliciousAttachmentConfig> replaceList = this.replaceMap.get(item.getId());
        Boolean remove = this.removeMap.get(item.getId());
        this.generateTableModel.clear();
        this.replaceTableModel.clear();
        this.tablesDialog.setBooleanValue("Remove", new Boolean(false));
        if (remove != null) {
            this.tablesDialog.setBooleanValue("Remove", remove);
        }
        if (generateList != null) {
            for (MaliciousAttachmentConfig element : generateList) {
                this.generateTableModel.addResult(element);
            }
        }
        if (replaceList != null) {
            for (MaliciousAttachmentConfig element : replaceList) {
                this.replaceTableModel.addResult(element);
            }
        }
    }

    public void removeAttachment(String key) {
        this.generateMap.remove(key);
        this.replaceMap.remove(key);
        this.removeMap.remove(key);
    }

    public void release() {
        this.filesList.release();
        this.filesList = null;
        this.tablesDialog.release();
        this.generateMap = null;
        this.replaceMap = null;
        this.removeMap = null;
    }
}

