/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.NodeRange;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class JsonLineNumberMapper {
    private Map<JsonPointer, NodeRange> lines;
    private JsonPointer jsonPointer = JsonPointer.compile((String)"");
    private boolean rootProcessed = false;
    private int yamlLineNumberCorrection = 0;

    public Map<JsonPointer, NodeRange> mapLineNumber(JsonParser parser, boolean isYaml) {
        this.lines = new HashMap<JsonPointer, NodeRange>();
        if (isYaml) {
            this.yamlLineNumberCorrection = 1;
        }
        try {
            JsonToken token = parser.nextToken();
            while (token != null) {
                JsonStreamContext context = parser.getParsingContext();
                JsonLocation location = parser.getCurrentLocation();
                this.processLineEntry(token, location, context);
                token = parser.nextToken();
            }
            this.lines.get((Object)this.jsonPointer).endLine = parser.getCurrentLocation().getLineNr();
        }
        catch (IOException e) {
            LogManager.getLogger(JsonLineNumberMapper.class).error(e.getMessage(), (Throwable)e);
        }
        return this.lines;
    }

    private void processLineEntry(JsonToken token, JsonLocation location, JsonStreamContext context) {
        if (!this.rootProcessed) {
            NodeRange nodeRange = new NodeRange(location.getLineNr());
            this.lines.put(this.jsonPointer, nodeRange);
            this.rootProcessed = true;
            return;
        }
        if (context.inRoot()) {
            return;
        }
        if (token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT) {
            this.lines.get((Object)this.jsonPointer).endLine = location.getLineNr();
            this.jsonPointer = JsonPointer.forPath((JsonStreamContext)context.getParent(), (boolean)false);
            return;
        }
        if (token == JsonToken.FIELD_NAME) {
            return;
        }
        JsonStreamContext parentContext = context.getParent();
        int lineNumber = location.getLineNr();
        if (token == JsonToken.START_ARRAY || token == JsonToken.START_OBJECT) {
            this.jsonPointer = JsonPointer.forPath((JsonStreamContext)parentContext, (boolean)false);
            lineNumber = lineNumber <= 1 ? lineNumber : lineNumber - this.yamlLineNumberCorrection;
            this.lines.put(this.jsonPointer, new NodeRange(lineNumber));
            return;
        }
        JsonPointer entryPointer = JsonPointer.forPath((JsonStreamContext)context, (boolean)false);
        this.lines.put(entryPointer, new NodeRange(lineNumber, lineNumber));
    }

    public static String processNodeName(String name) {
        return name.replace("~", "~0").replace("/", "~1");
    }
}

