/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.MutableValue;
import com.eviware.soapui.support.PlainJavaJsonProvider;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;

public class JsonPathFacade {
    private String currentJson;
    private Object jsonObject;

    public JsonPathFacade(String targetJson) {
        if (!JsonUtil.isValidJson(targetJson)) {
            throw new IllegalArgumentException("Invalid JSON: " + targetJson);
        }
        this.currentJson = targetJson;
        this.jsonObject = new JsonSlurper().parseText(targetJson);
    }

    public String readStringValue(String jsonPathExpression) {
        Object data = this.readObjectValue(jsonPathExpression);
        return String.valueOf(data);
    }

    public void writeValue(String jsonPathExpression, Object value) {
        PlainJavaJsonProvider provider = new PlainJavaJsonProvider();
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)provider).build();
        DocumentContext documentContext = JsonPath.parse((String)this.currentJson);
        JsonPath path = JsonPath.compile((String)jsonPathExpression, (Predicate[])new Predicate[0]);
        documentContext.set(path, value);
        this.currentJson = documentContext.jsonString();
        this.jsonObject = new JsonSlurper().parseText(this.currentJson);
    }

    private void removeMutableWrappersFrom(JSON jsonObject) {
        block3: {
            block2: {
                if (!jsonObject.isArray()) break block2;
                JSONArray array = (JSONArray)jsonObject;
                for (int i = 0; i < array.size(); ++i) {
                    array.set(i, this.removeMutableWrapperFrom(array.get(i)));
                }
                break block3;
            }
            if (!(jsonObject instanceof JSONObject)) break block3;
            JSONObject object = (JSONObject)jsonObject;
            for (Object key : object.keySet()) {
                object.put(key, this.removeMutableWrapperFrom(object.get(key)));
            }
        }
    }

    private Object removeMutableWrapperFrom(Object o) {
        Object value = MutableValue.extractValueFromMutable(o);
        if (value instanceof JSON) {
            this.removeMutableWrappersFrom((JSON)value);
        }
        return value;
    }

    public Object getJSON() {
        return this.jsonObject;
    }

    public String getCurrentJson() {
        return this.currentJson;
    }

    public <T> T readObjectValue(String jsonPathExpression) {
        PlainJavaJsonProvider provider = new PlainJavaJsonProvider();
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)provider).build();
        JsonPath jsonPath = JsonPath.compile((String)jsonPathExpression, (Predicate[])new Predicate[0]);
        return (T)jsonPath.read(this.jsonObject, configuration);
    }
}

