/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.types.StringList;
import javax.annotation.Nonnull;

public class ModelItemNamer {
    private ModelItemNamer() {
    }

    public static String createName(String baseName, Iterable nameHolders) {
        int maxExistingIndex = 0;
        for (Object nameHolder : nameHolders) {
            String name;
            if (nameHolder == null || !(name = ModelItemNamer.getName(nameHolder)).contains(baseName)) continue;
            try {
                int beginIndex = name.indexOf(baseName) + baseName.length();
                int indexInProjectName = Integer.parseInt(name.substring(beginIndex).trim());
                if (indexInProjectName <= maxExistingIndex) continue;
                maxExistingIndex = indexInProjectName;
            }
            catch (Exception exception) {}
        }
        return baseName + " " + ++maxExistingIndex;
    }

    public static boolean isUnique(String baseName, Iterable nameHolders) {
        for (Object nameHolder : nameHolders) {
            String name;
            if (nameHolder == null || !baseName.equals(name = ModelItemNamer.getName(nameHolder))) continue;
            return false;
        }
        return true;
    }

    public static String getUniqueName(String def, ModelItem parent) {
        StringList childrenNames = ModelItemNamer.getChildrenNames(parent);
        return ModelItemNamer.createName(def, childrenNames);
    }

    private static StringList getChildrenNames(ModelItem parent) {
        StringList names = new StringList();
        for (ModelItem modelItem : parent.getChildren()) {
            names.add(modelItem.getName());
        }
        return names;
    }

    private static String getName(@Nonnull Object nameHolder) {
        return nameHolder instanceof ModelItem ? ((ModelItem)nameHolder).getName() : nameHolder.toString();
    }
}

